/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckInLicenseRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CheckInLicenseRequest> {
    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConsumptionToken").getter(CheckInLicenseRequest.getter(CheckInLicenseRequest::licenseConsumptionToken)).setter(CheckInLicenseRequest.setter(Builder::licenseConsumptionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build()}).build();
    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Beneficiary").getter(CheckInLicenseRequest.getter(CheckInLicenseRequest::beneficiary)).setter(CheckInLicenseRequest.setter(Builder::beneficiary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONSUMPTION_TOKEN_FIELD, BENEFICIARY_FIELD));
    private final String licenseConsumptionToken;
    private final String beneficiary;

    private CheckInLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.beneficiary = builder.beneficiary;
    }

    public final String licenseConsumptionToken() {
        return this.licenseConsumptionToken;
    }

    public final String beneficiary() {
        return this.beneficiary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.beneficiary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckInLicenseRequest)) {
            return false;
        }
        CheckInLicenseRequest other = (CheckInLicenseRequest)((Object)obj);
        return Objects.equals(this.licenseConsumptionToken(), other.licenseConsumptionToken()) && Objects.equals(this.beneficiary(), other.beneficiary());
    }

    public final String toString() {
        return ToString.builder((String)"CheckInLicenseRequest").add("LicenseConsumptionToken", (Object)this.licenseConsumptionToken()).add("Beneficiary", (Object)this.beneficiary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConsumptionToken": {
                return Optional.ofNullable(clazz.cast(this.licenseConsumptionToken()));
            }
            case "Beneficiary": {
                return Optional.ofNullable(clazz.cast(this.beneficiary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckInLicenseRequest, T> g) {
        return obj -> g.apply((CheckInLicenseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseConsumptionToken;
        private String beneficiary;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckInLicenseRequest model) {
            super(model);
            this.licenseConsumptionToken(model.licenseConsumptionToken);
            this.beneficiary(model.beneficiary);
        }

        public final String getLicenseConsumptionToken() {
            return this.licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        @Transient
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final String getBeneficiary() {
            return this.beneficiary;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        @Override
        @Transient
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckInLicenseRequest build() {
            return new CheckInLicenseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckInLicenseRequest> {
        public Builder licenseConsumptionToken(String var1);

        public Builder beneficiary(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

