/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.GetGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.GetGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTokensRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTokensResponse;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse;

/**
 * Service client for accessing AWS License Manager asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname> AWS License Manager </fullname>
 * <p>
 * AWS License Manager makes it easier to manage licenses from software vendors across multiple AWS accounts and
 * on-premises servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerAsyncClient extends SdkClient {
    String SERVICE_NAME = "license-manager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager";

    /**
     * Create a {@link LicenseManagerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerAsyncClient}.
     */
    static LicenseManagerAsyncClientBuilder builder() {
        return new DefaultLicenseManagerAsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts the specified grant.
     * </p>
     *
     * @param acceptGrantRequest
     * @return A Java Future containing the result of the AcceptGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.AcceptGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/AcceptGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptGrantResponse> acceptGrant(AcceptGrantRequest acceptGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptGrantRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptGrantRequest#builder()}
     * </p>
     *
     * @param acceptGrantRequest
     *        A {@link Consumer} that will call methods on {@link AcceptGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.AcceptGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/AcceptGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcceptGrantResponse> acceptGrant(Consumer<AcceptGrantRequest.Builder> acceptGrantRequest) {
        return acceptGrant(AcceptGrantRequest.builder().applyMutation(acceptGrantRequest).build());
    }

    /**
     * <p>
     * Checks in the specified license. Check in a license when it is no longer in use.
     * </p>
     *
     * @param checkInLicenseRequest
     * @return A Java Future containing the result of the CheckInLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckInLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckInLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckInLicenseResponse> checkInLicense(CheckInLicenseRequest checkInLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks in the specified license. Check in a license when it is no longer in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckInLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link CheckInLicenseRequest#builder()}
     * </p>
     *
     * @param checkInLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckInLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CheckInLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckInLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckInLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckInLicenseResponse> checkInLicense(Consumer<CheckInLicenseRequest.Builder> checkInLicenseRequest) {
        return checkInLicense(CheckInLicenseRequest.builder().applyMutation(checkInLicenseRequest).build());
    }

    /**
     * <p>
     * Checks out the specified license for offline use.
     * </p>
     *
     * @param checkoutBorrowLicenseRequest
     * @return A Java Future containing the result of the CheckoutBorrowLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>NoEntitlementsAllowedException There are no entitlements found for this license, or the entitlement
     *         maximum count is reached.</li>
     *         <li>EntitlementNotAllowedException The entitlement is not allowed.</li>
     *         <li>UnsupportedDigitalSignatureMethodException The digital signature method is unsupported. Try your
     *         request again.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckoutBorrowLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutBorrowLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckoutBorrowLicenseResponse> checkoutBorrowLicense(
            CheckoutBorrowLicenseRequest checkoutBorrowLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks out the specified license for offline use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckoutBorrowLicenseRequest.Builder} avoiding the
     * need to create one manually via {@link CheckoutBorrowLicenseRequest#builder()}
     * </p>
     *
     * @param checkoutBorrowLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckoutBorrowLicenseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CheckoutBorrowLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>NoEntitlementsAllowedException There are no entitlements found for this license, or the entitlement
     *         maximum count is reached.</li>
     *         <li>EntitlementNotAllowedException The entitlement is not allowed.</li>
     *         <li>UnsupportedDigitalSignatureMethodException The digital signature method is unsupported. Try your
     *         request again.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckoutBorrowLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutBorrowLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckoutBorrowLicenseResponse> checkoutBorrowLicense(
            Consumer<CheckoutBorrowLicenseRequest.Builder> checkoutBorrowLicenseRequest) {
        return checkoutBorrowLicense(CheckoutBorrowLicenseRequest.builder().applyMutation(checkoutBorrowLicenseRequest).build());
    }

    /**
     * <p>
     * Checks out the specified license.
     * </p>
     *
     * @param checkoutLicenseRequest
     * @return A Java Future containing the result of the CheckoutLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>NoEntitlementsAllowedException There are no entitlements found for this license, or the entitlement
     *         maximum count is reached.</li>
     *         <li>UnsupportedDigitalSignatureMethodException The digital signature method is unsupported. Try your
     *         request again.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckoutLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckoutLicenseResponse> checkoutLicense(CheckoutLicenseRequest checkoutLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks out the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckoutLicenseRequest.Builder} avoiding the need
     * to create one manually via {@link CheckoutLicenseRequest#builder()}
     * </p>
     *
     * @param checkoutLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckoutLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CheckoutLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>NoEntitlementsAllowedException There are no entitlements found for this license, or the entitlement
     *         maximum count is reached.</li>
     *         <li>UnsupportedDigitalSignatureMethodException The digital signature method is unsupported. Try your
     *         request again.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CheckoutLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckoutLicenseResponse> checkoutLicense(
            Consumer<CheckoutLicenseRequest.Builder> checkoutLicenseRequest) {
        return checkoutLicense(CheckoutLicenseRequest.builder().applyMutation(checkoutLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific AWS
     * accounts.
     * </p>
     *
     * @param createGrantRequest
     * @return A Java Future containing the result of the CreateGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGrantResponse> createGrant(CreateGrantRequest createGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific AWS
     * accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGrantRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGrantRequest#builder()}
     * </p>
     *
     * @param createGrantRequest
     *        A {@link Consumer} that will call methods on {@link CreateGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGrantResponse> createGrant(Consumer<CreateGrantRequest.Builder> createGrantRequest) {
        return createGrant(CreateGrantRequest.builder().applyMutation(createGrantRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified grant.
     * </p>
     *
     * @param createGrantVersionRequest
     * @return A Java Future containing the result of the CreateGrantVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateGrantVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrantVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGrantVersionResponse> createGrantVersion(CreateGrantVersionRequest createGrantVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGrantVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGrantVersionRequest#builder()}
     * </p>
     *
     * @param createGrantVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGrantVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGrantVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateGrantVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrantVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGrantVersionResponse> createGrantVersion(
            Consumer<CreateGrantVersionRequest.Builder> createGrantVersionRequest) {
        return createGrantVersion(CreateGrantVersionRequest.builder().applyMutation(createGrantVersionRequest).build());
    }

    /**
     * <p>
     * Creates a license.
     * </p>
     *
     * @param createLicenseRequest
     * @return A Java Future containing the result of the CreateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLicenseResponse> createLicense(CreateLicenseRequest createLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLicenseRequest#builder()}
     * </p>
     *
     * @param createLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLicenseResponse> createLicense(Consumer<CreateLicenseRequest.Builder> createLicenseRequest) {
        return createLicense(CreateLicenseRequest.builder().applyMutation(createLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a license configuration.
     * </p>
     * <p>
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by
     * License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or
     * vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to
     * host (how long a license must be associated with a host), and the number of licenses purchased and used.
     * </p>
     *
     * @param createLicenseConfigurationRequest
     * @return A Java Future containing the result of the CreateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseConfigurationResponse> createLicenseConfiguration(
            CreateLicenseConfigurationRequest createLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license configuration.
     * </p>
     * <p>
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by
     * License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or
     * vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to
     * host (how long a license must be associated with a host), and the number of licenses purchased and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param createLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseConfigurationResponse> createLicenseConfiguration(
            Consumer<CreateLicenseConfigurationRequest.Builder> createLicenseConfigurationRequest) {
        return createLicenseConfiguration(CreateLicenseConfigurationRequest.builder()
                .applyMutation(createLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new report generator.
     * </p>
     *
     * @param createLicenseManagerReportGeneratorRequest
     * @return A Java Future containing the result of the CreateLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseManagerReportGeneratorResponse> createLicenseManagerReportGenerator(
            CreateLicenseManagerReportGeneratorRequest createLicenseManagerReportGeneratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new report generator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param createLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseManagerReportGeneratorResponse> createLicenseManagerReportGenerator(
            Consumer<CreateLicenseManagerReportGeneratorRequest.Builder> createLicenseManagerReportGeneratorRequest) {
        return createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(createLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified license.
     * </p>
     *
     * @param createLicenseVersionRequest
     * @return A Java Future containing the result of the CreateLicenseVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseVersionResponse> createLicenseVersion(
            CreateLicenseVersionRequest createLicenseVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLicenseVersionRequest#builder()}
     * </p>
     *
     * @param createLicenseVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLicenseVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseVersionResponse> createLicenseVersion(
            Consumer<CreateLicenseVersionRequest.Builder> createLicenseVersionRequest) {
        return createLicenseVersion(CreateLicenseVersionRequest.builder().applyMutation(createLicenseVersionRequest).build());
    }

    /**
     * <p>
     * Creates a long-lived token.
     * </p>
     * <p>
     * A refresh token is a JWT token used to get an access token. With an access token, you can call
     * AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the
     * specified license.
     * </p>
     *
     * @param createTokenRequest
     * @return A Java Future containing the result of the CreateToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTokenResponse> createToken(CreateTokenRequest createTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a long-lived token.
     * </p>
     * <p>
     * A refresh token is a JWT token used to get an access token. With an access token, you can call
     * AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the
     * specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTokenRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTokenRequest#builder()}
     * </p>
     *
     * @param createTokenRequest
     *        A {@link Consumer} that will call methods on {@link CreateTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTokenResponse> createToken(Consumer<CreateTokenRequest.Builder> createTokenRequest) {
        return createToken(CreateTokenRequest.builder().applyMutation(createTokenRequest).build());
    }

    /**
     * <p>
     * Deletes the specified grant.
     * </p>
     *
     * @param deleteGrantRequest
     * @return A Java Future containing the result of the DeleteGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGrantResponse> deleteGrant(DeleteGrantRequest deleteGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGrantRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGrantRequest#builder()}
     * </p>
     *
     * @param deleteGrantRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGrantResponse> deleteGrant(Consumer<DeleteGrantRequest.Builder> deleteGrantRequest) {
        return deleteGrant(DeleteGrantRequest.builder().applyMutation(deleteGrantRequest).build());
    }

    /**
     * <p>
     * Deletes the specified license.
     * </p>
     *
     * @param deleteLicenseRequest
     * @return A Java Future containing the result of the DeleteLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseResponse> deleteLicense(DeleteLicenseRequest deleteLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLicenseRequest#builder()}
     * </p>
     *
     * @param deleteLicenseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseResponse> deleteLicense(Consumer<DeleteLicenseRequest.Builder> deleteLicenseRequest) {
        return deleteLicense(DeleteLicenseRequest.builder().applyMutation(deleteLicenseRequest).build());
    }

    /**
     * <p>
     * Deletes the specified license configuration.
     * </p>
     * <p>
     * You cannot delete a license configuration that is in use.
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     * @return A Java Future containing the result of the DeleteLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseConfigurationResponse> deleteLicenseConfiguration(
            DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified license configuration.
     * </p>
     * <p>
     * You cannot delete a license configuration that is in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseConfigurationResponse> deleteLicenseConfiguration(
            Consumer<DeleteLicenseConfigurationRequest.Builder> deleteLicenseConfigurationRequest) {
        return deleteLicenseConfiguration(DeleteLicenseConfigurationRequest.builder()
                .applyMutation(deleteLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete an existing report generator.
     * </p>
     * <p>
     * This action deletes the report generator, which stops it from generating future reports and cannot be reversed.
     * However, the previous reports from this generator will remain in your S3 bucket.
     * </p>
     *
     * @param deleteLicenseManagerReportGeneratorRequest
     * @return A Java Future containing the result of the DeleteLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseManagerReportGeneratorResponse> deleteLicenseManagerReportGenerator(
            DeleteLicenseManagerReportGeneratorRequest deleteLicenseManagerReportGeneratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing report generator.
     * </p>
     * <p>
     * This action deletes the report generator, which stops it from generating future reports and cannot be reversed.
     * However, the previous reports from this generator will remain in your S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param deleteLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseManagerReportGeneratorResponse> deleteLicenseManagerReportGenerator(
            Consumer<DeleteLicenseManagerReportGeneratorRequest.Builder> deleteLicenseManagerReportGeneratorRequest) {
        return deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(deleteLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified token. Must be called in the license home Region.
     * </p>
     *
     * @param deleteTokenRequest
     * @return A Java Future containing the result of the DeleteToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTokenResponse> deleteToken(DeleteTokenRequest deleteTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified token. Must be called in the license home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTokenRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTokenRequest#builder()}
     * </p>
     *
     * @param deleteTokenRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>RedirectException This is not the correct Region for the resource. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTokenResponse> deleteToken(Consumer<DeleteTokenRequest.Builder> deleteTokenRequest) {
        return deleteToken(DeleteTokenRequest.builder().applyMutation(deleteTokenRequest).build());
    }

    /**
     * <p>
     * Extends the expiration date for license consumption.
     * </p>
     *
     * @param extendLicenseConsumptionRequest
     * @return A Java Future containing the result of the ExtendLicenseConsumption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ExtendLicenseConsumption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ExtendLicenseConsumption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExtendLicenseConsumptionResponse> extendLicenseConsumption(
            ExtendLicenseConsumptionRequest extendLicenseConsumptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Extends the expiration date for license consumption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExtendLicenseConsumptionRequest.Builder} avoiding
     * the need to create one manually via {@link ExtendLicenseConsumptionRequest#builder()}
     * </p>
     *
     * @param extendLicenseConsumptionRequest
     *        A {@link Consumer} that will call methods on {@link ExtendLicenseConsumptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExtendLicenseConsumption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ExtendLicenseConsumption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ExtendLicenseConsumption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExtendLicenseConsumptionResponse> extendLicenseConsumption(
            Consumer<ExtendLicenseConsumptionRequest.Builder> extendLicenseConsumptionRequest) {
        return extendLicenseConsumption(ExtendLicenseConsumptionRequest.builder().applyMutation(extendLicenseConsumptionRequest)
                .build());
    }

    /**
     * <p>
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     * </p>
     *
     * @param getAccessTokenRequest
     * @return A Java Future containing the result of the GetAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessTokenResponse> getAccessToken(GetAccessTokenRequest getAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccessTokenRequest#builder()}
     * </p>
     *
     * @param getAccessTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetAccessTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessTokenResponse> getAccessToken(Consumer<GetAccessTokenRequest.Builder> getAccessTokenRequest) {
        return getAccessToken(GetAccessTokenRequest.builder().applyMutation(getAccessTokenRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified grant.
     * </p>
     *
     * @param getGrantRequest
     * @return A Java Future containing the result of the GetGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGrantResponse> getGrant(GetGrantRequest getGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGrantRequest.Builder} avoiding the need to
     * create one manually via {@link GetGrantRequest#builder()}
     * </p>
     *
     * @param getGrantRequest
     *        A {@link Consumer} that will call methods on {@link GetGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGrantResponse> getGrant(Consumer<GetGrantRequest.Builder> getGrantRequest) {
        return getGrant(GetGrantRequest.builder().applyMutation(getGrantRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified license.
     * </p>
     *
     * @param getLicenseRequest
     * @return A Java Future containing the result of the GetLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLicenseResponse> getLicense(GetLicenseRequest getLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link GetLicenseRequest#builder()}
     * </p>
     *
     * @param getLicenseRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLicenseResponse> getLicense(Consumer<GetLicenseRequest.Builder> getLicenseRequest) {
        return getLicense(GetLicenseRequest.builder().applyMutation(getLicenseRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified license configuration.
     * </p>
     *
     * @param getLicenseConfigurationRequest
     * @return A Java Future containing the result of the GetLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseConfigurationResponse> getLicenseConfiguration(
            GetLicenseConfigurationRequest getLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param getLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseConfigurationResponse> getLicenseConfiguration(
            Consumer<GetLicenseConfigurationRequest.Builder> getLicenseConfigurationRequest) {
        return getLicenseConfiguration(GetLicenseConfigurationRequest.builder().applyMutation(getLicenseConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets information on the specified report generator.
     * </p>
     *
     * @param getLicenseManagerReportGeneratorRequest
     * @return A Java Future containing the result of the GetLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseManagerReportGeneratorResponse> getLicenseManagerReportGenerator(
            GetLicenseManagerReportGeneratorRequest getLicenseManagerReportGeneratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information on the specified report generator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link GetLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param getLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseManagerReportGeneratorResponse> getLicenseManagerReportGenerator(
            Consumer<GetLicenseManagerReportGeneratorRequest.Builder> getLicenseManagerReportGeneratorRequest) {
        return getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(getLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the usage of the specified license.
     * </p>
     *
     * @param getLicenseUsageRequest
     * @return A Java Future containing the result of the GetLicenseUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseUsageResponse> getLicenseUsage(GetLicenseUsageRequest getLicenseUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the usage of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseUsageRequest.Builder} avoiding the need
     * to create one manually via {@link GetLicenseUsageRequest#builder()}
     * </p>
     *
     * @param getLicenseUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseUsageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLicenseUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseUsageResponse> getLicenseUsage(
            Consumer<GetLicenseUsageRequest.Builder> getLicenseUsageRequest) {
        return getLicenseUsage(GetLicenseUsageRequest.builder().applyMutation(getLicenseUsageRequest).build());
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(
            Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest) {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     *
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings() {
        return getServiceSettings(GetServiceSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the resource associations for the specified license configuration.
     * </p>
     * <p>
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped
     * instance might not consume a license (depending on the license rules).
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     * @return A Java Future containing the result of the ListAssociationsForLicenseConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociationsForLicenseConfigurationResponse> listAssociationsForLicenseConfiguration(
            ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource associations for the specified license configuration.
     * </p>
     * <p>
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped
     * instance might not consume a license (depending on the license rules).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssociationsForLicenseConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssociationsForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssociationsForLicenseConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssociationsForLicenseConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociationsForLicenseConfigurationResponse> listAssociationsForLicenseConfiguration(
            Consumer<ListAssociationsForLicenseConfigurationRequest.Builder> listAssociationsForLicenseConfigurationRequest) {
        return listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest.builder()
                .applyMutation(listAssociationsForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists the grants distributed for the specified license.
     * </p>
     *
     * @param listDistributedGrantsRequest
     * @return A Java Future containing the result of the ListDistributedGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListDistributedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListDistributedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributedGrantsResponse> listDistributedGrants(
            ListDistributedGrantsRequest listDistributedGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the grants distributed for the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributedGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDistributedGrantsRequest#builder()}
     * </p>
     *
     * @param listDistributedGrantsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributedGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDistributedGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListDistributedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListDistributedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributedGrantsResponse> listDistributedGrants(
            Consumer<ListDistributedGrantsRequest.Builder> listDistributedGrantsRequest) {
        return listDistributedGrants(ListDistributedGrantsRequest.builder().applyMutation(listDistributedGrantsRequest).build());
    }

    /**
     * <p>
     * Lists the license configuration operations that failed.
     * </p>
     *
     * @param listFailuresForLicenseConfigurationOperationsRequest
     * @return A Java Future containing the result of the ListFailuresForLicenseConfigurationOperations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListFailuresForLicenseConfigurationOperations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFailuresForLicenseConfigurationOperationsResponse> listFailuresForLicenseConfigurationOperations(
            ListFailuresForLicenseConfigurationOperationsRequest listFailuresForLicenseConfigurationOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the license configuration operations that failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListFailuresForLicenseConfigurationOperationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListFailuresForLicenseConfigurationOperationsRequest#builder()}
     * </p>
     *
     * @param listFailuresForLicenseConfigurationOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListFailuresForLicenseConfigurationOperationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFailuresForLicenseConfigurationOperations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListFailuresForLicenseConfigurationOperations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFailuresForLicenseConfigurationOperationsResponse> listFailuresForLicenseConfigurationOperations(
            Consumer<ListFailuresForLicenseConfigurationOperationsRequest.Builder> listFailuresForLicenseConfigurationOperationsRequest) {
        return listFailuresForLicenseConfigurationOperations(ListFailuresForLicenseConfigurationOperationsRequest.builder()
                .applyMutation(listFailuresForLicenseConfigurationOperationsRequest).build());
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations(
            ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations(
            Consumer<ListLicenseConfigurationsRequest.Builder> listLicenseConfigurationsRequest) {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder()
                .applyMutation(listLicenseConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations() {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the report generators for your account.
     * </p>
     *
     * @param listLicenseManagerReportGeneratorsRequest
     * @return A Java Future containing the result of the ListLicenseManagerReportGenerators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseManagerReportGenerators
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseManagerReportGenerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseManagerReportGeneratorsResponse> listLicenseManagerReportGenerators(
            ListLicenseManagerReportGeneratorsRequest listLicenseManagerReportGeneratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the report generators for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseManagerReportGeneratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLicenseManagerReportGeneratorsRequest#builder()}
     * </p>
     *
     * @param listLicenseManagerReportGeneratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseManagerReportGeneratorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListLicenseManagerReportGenerators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseManagerReportGenerators
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseManagerReportGenerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseManagerReportGeneratorsResponse> listLicenseManagerReportGenerators(
            Consumer<ListLicenseManagerReportGeneratorsRequest.Builder> listLicenseManagerReportGeneratorsRequest) {
        return listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest.builder()
                .applyMutation(listLicenseManagerReportGeneratorsRequest).build());
    }

    /**
     * <p>
     * Describes the license configurations for the specified resource.
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     * @return A Java Future containing the result of the ListLicenseSpecificationsForResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseSpecificationsForResourceResponse> listLicenseSpecificationsForResource(
            ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the license configurations for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListLicenseSpecificationsForResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseSpecificationsForResourceResponse> listLicenseSpecificationsForResource(
            Consumer<ListLicenseSpecificationsForResourceRequest.Builder> listLicenseSpecificationsForResourceRequest) {
        return listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(listLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all versions of the specified license.
     * </p>
     *
     * @param listLicenseVersionsRequest
     * @return A Java Future containing the result of the ListLicenseVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseVersionsResponse> listLicenseVersions(
            ListLicenseVersionsRequest listLicenseVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseVersionsRequest#builder()}
     * </p>
     *
     * @param listLicenseVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLicenseVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseVersionsResponse> listLicenseVersions(
            Consumer<ListLicenseVersionsRequest.Builder> listLicenseVersionsRequest) {
        return listLicenseVersions(ListLicenseVersionsRequest.builder().applyMutation(listLicenseVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the licenses for your account.
     * </p>
     *
     * @param listLicensesRequest
     * @return A Java Future containing the result of the ListLicenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLicensesResponse> listLicenses(ListLicensesRequest listLicensesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the licenses for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLicensesRequest#builder()}
     * </p>
     *
     * @param listLicensesRequest
     *        A {@link Consumer} that will call methods on {@link ListLicensesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLicenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLicensesResponse> listLicenses(Consumer<ListLicensesRequest.Builder> listLicensesRequest) {
        return listLicenses(ListLicensesRequest.builder().applyMutation(listLicensesRequest).build());
    }

    /**
     * <p>
     * Lists grants that are received but not accepted.
     * </p>
     *
     * @param listReceivedGrantsRequest
     * @return A Java Future containing the result of the ListReceivedGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListReceivedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReceivedGrantsResponse> listReceivedGrants(ListReceivedGrantsRequest listReceivedGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists grants that are received but not accepted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceivedGrantsRequest#builder()}
     * </p>
     *
     * @param listReceivedGrantsRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedGrantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReceivedGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListReceivedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReceivedGrantsResponse> listReceivedGrants(
            Consumer<ListReceivedGrantsRequest.Builder> listReceivedGrantsRequest) {
        return listReceivedGrants(ListReceivedGrantsRequest.builder().applyMutation(listReceivedGrantsRequest).build());
    }

    /**
     * <p>
     * Lists received licenses.
     * </p>
     *
     * @param listReceivedLicensesRequest
     * @return A Java Future containing the result of the ListReceivedLicenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListReceivedLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReceivedLicensesResponse> listReceivedLicenses(
            ListReceivedLicensesRequest listReceivedLicensesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists received licenses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedLicensesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceivedLicensesRequest#builder()}
     * </p>
     *
     * @param listReceivedLicensesRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedLicensesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReceivedLicenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListReceivedLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReceivedLicensesResponse> listReceivedLicenses(
            Consumer<ListReceivedLicensesRequest.Builder> listReceivedLicensesRequest) {
        return listReceivedLicenses(ListReceivedLicensesRequest.builder().applyMutation(listReceivedLicensesRequest).build());
    }

    /**
     * <p>
     * Lists resources managed using Systems Manager inventory.
     * </p>
     *
     * @param listResourceInventoryRequest
     * @return A Java Future containing the result of the ListResourceInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>FailedDependencyException A dependency required to run the API is missing.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListResourceInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceInventoryResponse> listResourceInventory(
            ListResourceInventoryRequest listResourceInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists resources managed using Systems Manager inventory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceInventoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceInventoryRequest#builder()}
     * </p>
     *
     * @param listResourceInventoryRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceInventoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>FailedDependencyException A dependency required to run the API is missing.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListResourceInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceInventoryResponse> listResourceInventory(
            Consumer<ListResourceInventoryRequest.Builder> listResourceInventoryRequest) {
        return listResourceInventory(ListResourceInventoryRequest.builder().applyMutation(listResourceInventoryRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified license configuration.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your tokens.
     * </p>
     *
     * @param listTokensRequest
     * @return A Java Future containing the result of the ListTokens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTokens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTokensResponse> listTokens(ListTokensRequest listTokensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your tokens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTokensRequest.Builder} avoiding the need to
     * create one manually via {@link ListTokensRequest#builder()}
     * </p>
     *
     * @param listTokensRequest
     *        A {@link Consumer} that will call methods on {@link ListTokensRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTokens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTokens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTokensResponse> listTokens(Consumer<ListTokensRequest.Builder> listTokensRequest) {
        return listTokens(ListTokensRequest.builder().applyMutation(listTokensRequest).build());
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     * @return A Java Future containing the result of the ListUsageForLicenseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListUsageForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageForLicenseConfigurationResponse> listUsageForLicenseConfiguration(
            ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageForLicenseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ListUsageForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageForLicenseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListUsageForLicenseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListUsageForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageForLicenseConfigurationResponse> listUsageForLicenseConfiguration(
            Consumer<ListUsageForLicenseConfigurationRequest.Builder> listUsageForLicenseConfigurationRequest) {
        return listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest.builder()
                .applyMutation(listUsageForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Rejects the specified grant.
     * </p>
     *
     * @param rejectGrantRequest
     * @return A Java Future containing the result of the RejectGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.RejectGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/RejectGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectGrantResponse> rejectGrant(RejectGrantRequest rejectGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectGrantRequest.Builder} avoiding the need to
     * create one manually via {@link RejectGrantRequest#builder()}
     * </p>
     *
     * @param rejectGrantRequest
     *        A {@link Consumer} that will call methods on {@link RejectGrantRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RejectGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.RejectGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/RejectGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectGrantResponse> rejectGrant(Consumer<RejectGrantRequest.Builder> rejectGrantRequest) {
        return rejectGrant(RejectGrantRequest.builder().applyMutation(rejectGrantRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified license configuration.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified license configuration.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration.
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     * @return A Java Future containing the result of the UpdateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseConfigurationResponse> updateLicenseConfiguration(
            UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseConfigurationResponse> updateLicenseConfiguration(
            Consumer<UpdateLicenseConfigurationRequest.Builder> updateLicenseConfigurationRequest) {
        return updateLicenseConfiguration(UpdateLicenseConfigurationRequest.builder()
                .applyMutation(updateLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a report generator.
     * </p>
     * <p>
     * After you make changes to a report generator, it will start generating new reports within 60 minutes of being
     * updated.
     * </p>
     *
     * @param updateLicenseManagerReportGeneratorRequest
     * @return A Java Future containing the result of the UpdateLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseManagerReportGeneratorResponse> updateLicenseManagerReportGenerator(
            UpdateLicenseManagerReportGeneratorRequest updateLicenseManagerReportGeneratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a report generator.
     * </p>
     * <p>
     * After you make changes to a report generator, it will start generating new reports within 60 minutes of being
     * updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param updateLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLicenseManagerReportGenerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The provided input is not valid. Try your request again.</li>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseManagerReportGeneratorResponse> updateLicenseManagerReportGenerator(
            Consumer<UpdateLicenseManagerReportGeneratorRequest.Builder> updateLicenseManagerReportGeneratorRequest) {
        return updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(updateLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Adds or removes the specified license configurations for the specified AWS resource.
     * </p>
     * <p>
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license
     * specifications for launch templates and AWS CloudFormation templates, as they send license configurations to the
     * operation that creates the resource.
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     * @return A Java Future containing the result of the UpdateLicenseSpecificationsForResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException License Manager cannot allocate a license to a resource because of its
     *         state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.</li>
     *         <li>LicenseUsageException You do not have enough licenses available to support a new resource launch.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseSpecificationsForResourceResponse> updateLicenseSpecificationsForResource(
            UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or removes the specified license configurations for the specified AWS resource.
     * </p>
     * <p>
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license
     * specifications for launch templates and AWS CloudFormation templates, as they send license configurations to the
     * operation that creates the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateLicenseSpecificationsForResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException License Manager cannot allocate a license to a resource because of its
     *         state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.</li>
     *         <li>LicenseUsageException You do not have enough licenses available to support a new resource launch.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseSpecificationsForResourceResponse> updateLicenseSpecificationsForResource(
            Consumer<UpdateLicenseSpecificationsForResourceRequest.Builder> updateLicenseSpecificationsForResourceRequest) {
        return updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(updateLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Updates License Manager settings for the current Region.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            UpdateServiceSettingsRequest updateServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates License Manager settings for the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServiceSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }
}
