/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ArnListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.MaxSize3StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateTokenRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CreateTokenRequest.getter(CreateTokenRequest::licenseArn)).setter(CreateTokenRequest.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoleArns").getter(CreateTokenRequest.getter(CreateTokenRequest::roleArns)).setter(CreateTokenRequest.setter(Builder::roleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationInDays").getter(CreateTokenRequest.getter(CreateTokenRequest::expirationInDays)).setter(CreateTokenRequest.setter(Builder::expirationInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays").build()}).build();
    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenProperties").getter(CreateTokenRequest.getter(CreateTokenRequest::tokenProperties)).setter(CreateTokenRequest.setter(Builder::tokenProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTokenRequest.getter(CreateTokenRequest::clientToken)).setter(CreateTokenRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, ROLE_ARNS_FIELD, EXPIRATION_IN_DAYS_FIELD, TOKEN_PROPERTIES_FIELD, CLIENT_TOKEN_FIELD));
    private final String licenseArn;
    private final List<String> roleArns;
    private final Integer expirationInDays;
    private final List<String> tokenProperties;
    private final String clientToken;

    private CreateTokenRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.roleArns = builder.roleArns;
        this.expirationInDays = builder.expirationInDays;
        this.tokenProperties = builder.tokenProperties;
        this.clientToken = builder.clientToken;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final boolean hasRoleArns() {
        return this.roleArns != null && !(this.roleArns instanceof SdkAutoConstructList);
    }

    public final List<String> roleArns() {
        return this.roleArns;
    }

    public final Integer expirationInDays() {
        return this.expirationInDays;
    }

    public final boolean hasTokenProperties() {
        return this.tokenProperties != null && !(this.tokenProperties instanceof SdkAutoConstructList);
    }

    public final List<String> tokenProperties() {
        return this.tokenProperties;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleArns() ? this.roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenProperties() ? this.tokenProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenRequest)) {
            return false;
        }
        CreateTokenRequest other = (CreateTokenRequest)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && this.hasRoleArns() == other.hasRoleArns() && Objects.equals(this.roleArns(), other.roleArns()) && Objects.equals(this.expirationInDays(), other.expirationInDays()) && this.hasTokenProperties() == other.hasTokenProperties() && Objects.equals(this.tokenProperties(), other.tokenProperties()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTokenRequest").add("LicenseArn", (Object)this.licenseArn()).add("RoleArns", this.hasRoleArns() ? this.roleArns() : null).add("ExpirationInDays", (Object)this.expirationInDays()).add("TokenProperties", this.hasTokenProperties() ? this.tokenProperties() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "RoleArns": {
                return Optional.ofNullable(clazz.cast(this.roleArns()));
            }
            case "ExpirationInDays": {
                return Optional.ofNullable(clazz.cast(this.expirationInDays()));
            }
            case "TokenProperties": {
                return Optional.ofNullable(clazz.cast(this.tokenProperties()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenRequest, T> g) {
        return obj -> g.apply((CreateTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseArn;
        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();
        private Integer expirationInDays;
        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenRequest model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.roleArns(model.roleArns);
            this.expirationInDays(model.expirationInDays);
            this.tokenProperties(model.tokenProperties);
            this.clientToken(model.clientToken);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        @Transient
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (this.roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
        }

        @Override
        @Transient
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roleArns(String ... roleArns) {
            this.roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final Integer getExpirationInDays() {
            return this.expirationInDays;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        @Override
        @Transient
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final Collection<String> getTokenProperties() {
            if (this.tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenProperties;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        @Override
        @Transient
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tokenProperties(String ... tokenProperties) {
            this.tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenRequest build() {
            return new CreateTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenRequest> {
        public Builder licenseArn(String var1);

        public Builder roleArns(Collection<String> var1);

        public Builder roleArns(String ... var1);

        public Builder expirationInDays(Integer var1);

        public Builder tokenProperties(Collection<String> var1);

        public Builder tokenProperties(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

