/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the usage of a resource associated with a license configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseConfigurationUsage implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseConfigurationUsage.Builder, LicenseConfigurationUsage> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(LicenseConfigurationUsage::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(LicenseConfigurationUsage::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(LicenseConfigurationUsage::resourceStatus))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwnerId").getter(getter(LicenseConfigurationUsage::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").build()).build();

    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AssociationTime").getter(getter(LicenseConfigurationUsage::associationTime))
            .setter(setter(Builder::associationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTime").build()).build();

    private static final SdkField<Long> CONSUMED_LICENSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ConsumedLicenses").getter(getter(LicenseConfigurationUsage::consumedLicenses))
            .setter(setter(Builder::consumedLicenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenses").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_STATUS_FIELD,
                    RESOURCE_OWNER_ID_FIELD, ASSOCIATION_TIME_FIELD, CONSUMED_LICENSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceType;

    private final String resourceStatus;

    private final String resourceOwnerId;

    private final Instant associationTime;

    private final Long consumedLicenses;

    private LicenseConfigurationUsage(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.resourceStatus = builder.resourceStatus;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.associationTime = builder.associationTime;
        this.consumedLicenses = builder.consumedLicenses;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Type of resource.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Type of resource.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Status of the resource.
     * </p>
     * 
     * @return Status of the resource.
     */
    public final String resourceStatus() {
        return resourceStatus;
    }

    /**
     * <p>
     * ID of the account that owns the resource.
     * </p>
     * 
     * @return ID of the account that owns the resource.
     */
    public final String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * <p>
     * Time when the license configuration was initially associated with the resource.
     * </p>
     * 
     * @return Time when the license configuration was initially associated with the resource.
     */
    public final Instant associationTime() {
        return associationTime;
    }

    /**
     * <p>
     * Number of licenses consumed by the resource.
     * </p>
     * 
     * @return Number of licenses consumed by the resource.
     */
    public final Long consumedLicenses() {
        return consumedLicenses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(consumedLicenses());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfigurationUsage)) {
            return false;
        }
        LicenseConfigurationUsage other = (LicenseConfigurationUsage) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceStatus(), other.resourceStatus())
                && Objects.equals(resourceOwnerId(), other.resourceOwnerId())
                && Objects.equals(associationTime(), other.associationTime())
                && Objects.equals(consumedLicenses(), other.consumedLicenses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseConfigurationUsage").add("ResourceArn", resourceArn())
                .add("ResourceType", resourceTypeAsString()).add("ResourceStatus", resourceStatus())
                .add("ResourceOwnerId", resourceOwnerId()).add("AssociationTime", associationTime())
                .add("ConsumedLicenses", consumedLicenses()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatus()));
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "AssociationTime":
            return Optional.ofNullable(clazz.cast(associationTime()));
        case "ConsumedLicenses":
            return Optional.ofNullable(clazz.cast(consumedLicenses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfigurationUsage, T> g) {
        return obj -> g.apply((LicenseConfigurationUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseConfigurationUsage> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Type of resource.
         * </p>
         * 
         * @param resourceType
         *        Type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Type of resource.
         * </p>
         * 
         * @param resourceType
         *        Type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Status of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * ID of the account that owns the resource.
         * </p>
         * 
         * @param resourceOwnerId
         *        ID of the account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * Time when the license configuration was initially associated with the resource.
         * </p>
         * 
         * @param associationTime
         *        Time when the license configuration was initially associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTime(Instant associationTime);

        /**
         * <p>
         * Number of licenses consumed by the resource.
         * </p>
         * 
         * @param consumedLicenses
         *        Number of licenses consumed by the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLicenses(Long consumedLicenses);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private String resourceStatus;

        private String resourceOwnerId;

        private Instant associationTime;

        private Long consumedLicenses;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfigurationUsage model) {
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            resourceStatus(model.resourceStatus);
            resourceOwnerId(model.resourceOwnerId);
            associationTime(model.associationTime);
            consumedLicenses(model.consumedLicenses);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        @Transient
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        @Transient
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final Instant getAssociationTime() {
            return associationTime;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        @Override
        @Transient
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final Long getConsumedLicenses() {
            return consumedLicenses;
        }

        public final void setConsumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
        }

        @Override
        @Transient
        public final Builder consumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
            return this;
        }

        @Override
        public LicenseConfigurationUsage build() {
            return new LicenseConfigurationUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
