/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceSettingsResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<GetServiceSettingsResponse.Builder, GetServiceSettingsResponse> {
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketArn").getter(getter(GetServiceSettingsResponse::s3BucketArn))
            .setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(GetServiceSettingsResponse::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField
            .<OrganizationConfiguration> builder(MarshallingType.SDK_POJO).memberName("OrganizationConfiguration")
            .getter(getter(GetServiceSettingsResponse::organizationConfiguration))
            .setter(setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCrossAccountsDiscovery")
            .getter(getter(GetServiceSettingsResponse::enableCrossAccountsDiscovery))
            .setter(setter(Builder::enableCrossAccountsDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCrossAccountsDiscovery")
                    .build()).build();

    private static final SdkField<String> LICENSE_MANAGER_RESOURCE_SHARE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseManagerResourceShareArn")
            .getter(getter(GetServiceSettingsResponse::licenseManagerResourceShareArn))
            .setter(setter(Builder::licenseManagerResourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseManagerResourceShareArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_ARN_FIELD,
            SNS_TOPIC_ARN_FIELD, ORGANIZATION_CONFIGURATION_FIELD, ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD,
            LICENSE_MANAGER_RESOURCE_SHARE_ARN_FIELD));

    private final String s3BucketArn;

    private final String snsTopicArn;

    private final OrganizationConfiguration organizationConfiguration;

    private final Boolean enableCrossAccountsDiscovery;

    private final String licenseManagerResourceShareArn;

    private GetServiceSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.s3BucketArn = builder.s3BucketArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.organizationConfiguration = builder.organizationConfiguration;
        this.enableCrossAccountsDiscovery = builder.enableCrossAccountsDiscovery;
        this.licenseManagerResourceShareArn = builder.licenseManagerResourceShareArn;
    }

    /**
     * <p>
     * Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.
     * </p>
     * 
     * @return Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * SNS topic configured to receive notifications from License Manager.
     * </p>
     * 
     * @return SNS topic configured to receive notifications from License Manager.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * Indicates whether Organizations is integrated with License Manager for cross-account discovery.
     * </p>
     * 
     * @return Indicates whether Organizations is integrated with License Manager for cross-account discovery.
     */
    public final OrganizationConfiguration organizationConfiguration() {
        return organizationConfiguration;
    }

    /**
     * <p>
     * Indicates whether cross-account discovery is enabled.
     * </p>
     * 
     * @return Indicates whether cross-account discovery is enabled.
     */
    public final Boolean enableCrossAccountsDiscovery() {
        return enableCrossAccountsDiscovery;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resource share. The License Manager management account provides member accounts
     * with access to this share.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resource share. The License Manager management account provides member
     *         accounts with access to this share.
     */
    public final String licenseManagerResourceShareArn() {
        return licenseManagerResourceShareArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enableCrossAccountsDiscovery());
        hashCode = 31 * hashCode + Objects.hashCode(licenseManagerResourceShareArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceSettingsResponse)) {
            return false;
        }
        GetServiceSettingsResponse other = (GetServiceSettingsResponse) obj;
        return Objects.equals(s3BucketArn(), other.s3BucketArn()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(organizationConfiguration(), other.organizationConfiguration())
                && Objects.equals(enableCrossAccountsDiscovery(), other.enableCrossAccountsDiscovery())
                && Objects.equals(licenseManagerResourceShareArn(), other.licenseManagerResourceShareArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceSettingsResponse").add("S3BucketArn", s3BucketArn()).add("SnsTopicArn", snsTopicArn())
                .add("OrganizationConfiguration", organizationConfiguration())
                .add("EnableCrossAccountsDiscovery", enableCrossAccountsDiscovery())
                .add("LicenseManagerResourceShareArn", licenseManagerResourceShareArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "OrganizationConfiguration":
            return Optional.ofNullable(clazz.cast(organizationConfiguration()));
        case "EnableCrossAccountsDiscovery":
            return Optional.ofNullable(clazz.cast(enableCrossAccountsDiscovery()));
        case "LicenseManagerResourceShareArn":
            return Optional.ofNullable(clazz.cast(licenseManagerResourceShareArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceSettingsResponse, T> g) {
        return obj -> g.apply((GetServiceSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceSettingsResponse> {
        /**
         * <p>
         * Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.
         * </p>
         * 
         * @param s3BucketArn
         *        Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * SNS topic configured to receive notifications from License Manager.
         * </p>
         * 
         * @param snsTopicArn
         *        SNS topic configured to receive notifications from License Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * Indicates whether Organizations is integrated with License Manager for cross-account discovery.
         * </p>
         * 
         * @param organizationConfiguration
         *        Indicates whether Organizations is integrated with License Manager for cross-account discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration);

        /**
         * <p>
         * Indicates whether Organizations is integrated with License Manager for cross-account discovery.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationConfiguration.Builder} avoiding the
         * need to create one manually via {@link OrganizationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationConfiguration(OrganizationConfiguration)}.
         * 
         * @param organizationConfiguration
         *        a consumer that will call methods on {@link OrganizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConfiguration(OrganizationConfiguration)
         */
        default Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return organizationConfiguration(OrganizationConfiguration.builder().applyMutation(organizationConfiguration).build());
        }

        /**
         * <p>
         * Indicates whether cross-account discovery is enabled.
         * </p>
         * 
         * @param enableCrossAccountsDiscovery
         *        Indicates whether cross-account discovery is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the resource share. The License Manager management account provides member
         * accounts with access to this share.
         * </p>
         * 
         * @param licenseManagerResourceShareArn
         *        Amazon Resource Name (ARN) of the resource share. The License Manager management account provides
         *        member accounts with access to this share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseManagerResourceShareArn(String licenseManagerResourceShareArn);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String s3BucketArn;

        private String snsTopicArn;

        private OrganizationConfiguration organizationConfiguration;

        private Boolean enableCrossAccountsDiscovery;

        private String licenseManagerResourceShareArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceSettingsResponse model) {
            super(model);
            s3BucketArn(model.s3BucketArn);
            snsTopicArn(model.snsTopicArn);
            organizationConfiguration(model.organizationConfiguration);
            enableCrossAccountsDiscovery(model.enableCrossAccountsDiscovery);
            licenseManagerResourceShareArn(model.licenseManagerResourceShareArn);
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        @Transient
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return organizationConfiguration != null ? organizationConfiguration.toBuilder() : null;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        public final Boolean getEnableCrossAccountsDiscovery() {
            return enableCrossAccountsDiscovery;
        }

        public final void setEnableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
        }

        @Override
        @Transient
        public final Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
            return this;
        }

        public final String getLicenseManagerResourceShareArn() {
            return licenseManagerResourceShareArn;
        }

        public final void setLicenseManagerResourceShareArn(String licenseManagerResourceShareArn) {
            this.licenseManagerResourceShareArn = licenseManagerResourceShareArn;
        }

        @Override
        @Transient
        public final Builder licenseManagerResourceShareArn(String licenseManagerResourceShareArn) {
            this.licenseManagerResourceShareArn = licenseManagerResourceShareArn;
            return this;
        }

        @Override
        public GetServiceSettingsResponse build() {
            return new GetServiceSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
