/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckoutLicenseRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CheckoutLicenseRequest.Builder, CheckoutLicenseRequest> {
    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductSKU").getter(getter(CheckoutLicenseRequest::productSKU)).setter(setter(Builder::productSKU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()).build();

    private static final SdkField<String> CHECKOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckoutType").getter(getter(CheckoutLicenseRequest::checkoutTypeAsString))
            .setter(setter(Builder::checkoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutType").build()).build();

    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyFingerprint").getter(getter(CheckoutLicenseRequest::keyFingerprint))
            .setter(setter(Builder::keyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").build()).build();

    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_FIELD = SdkField
            .<List<EntitlementData>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(CheckoutLicenseRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CheckoutLicenseRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Beneficiary").getter(getter(CheckoutLicenseRequest::beneficiary)).setter(setter(Builder::beneficiary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(CheckoutLicenseRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PRODUCT_SKU_FIELD, CHECKOUT_TYPE_FIELD, KEY_FINGERPRINT_FIELD, ENTITLEMENTS_FIELD,
                    CLIENT_TOKEN_FIELD, BENEFICIARY_FIELD, NODE_ID_FIELD));

    private final String productSKU;

    private final String checkoutType;

    private final String keyFingerprint;

    private final List<EntitlementData> entitlements;

    private final String clientToken;

    private final String beneficiary;

    private final String nodeId;

    private CheckoutLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.productSKU = builder.productSKU;
        this.checkoutType = builder.checkoutType;
        this.keyFingerprint = builder.keyFingerprint;
        this.entitlements = builder.entitlements;
        this.clientToken = builder.clientToken;
        this.beneficiary = builder.beneficiary;
        this.nodeId = builder.nodeId;
    }

    /**
     * <p>
     * Product SKU.
     * </p>
     * 
     * @return Product SKU.
     */
    public final String productSKU() {
        return productSKU;
    }

    /**
     * <p>
     * Checkout type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkoutType} will
     * return {@link CheckoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #checkoutTypeAsString}.
     * </p>
     * 
     * @return Checkout type.
     * @see CheckoutType
     */
    public final CheckoutType checkoutType() {
        return CheckoutType.fromValue(checkoutType);
    }

    /**
     * <p>
     * Checkout type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkoutType} will
     * return {@link CheckoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #checkoutTypeAsString}.
     * </p>
     * 
     * @return Checkout type.
     * @see CheckoutType
     */
    public final String checkoutTypeAsString() {
        return checkoutType;
    }

    /**
     * <p>
     * Key fingerprint identifying the license.
     * </p>
     * 
     * @return Key fingerprint identifying the license.
     */
    public final String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * Returns true if the Entitlements property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return License entitlements.
     */
    public final List<EntitlementData> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * License beneficiary.
     * </p>
     * 
     * @return License beneficiary.
     */
    public final String beneficiary() {
        return beneficiary;
    }

    /**
     * <p>
     * Node ID.
     * </p>
     * 
     * @return Node ID.
     */
    public final String nodeId() {
        return nodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(checkoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutLicenseRequest)) {
            return false;
        }
        CheckoutLicenseRequest other = (CheckoutLicenseRequest) obj;
        return Objects.equals(productSKU(), other.productSKU())
                && Objects.equals(checkoutTypeAsString(), other.checkoutTypeAsString())
                && Objects.equals(keyFingerprint(), other.keyFingerprint()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(beneficiary(), other.beneficiary()) && Objects.equals(nodeId(), other.nodeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckoutLicenseRequest").add("ProductSKU", productSKU())
                .add("CheckoutType", checkoutTypeAsString()).add("KeyFingerprint", keyFingerprint())
                .add("Entitlements", hasEntitlements() ? entitlements() : null).add("ClientToken", clientToken())
                .add("Beneficiary", beneficiary()).add("NodeId", nodeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductSKU":
            return Optional.ofNullable(clazz.cast(productSKU()));
        case "CheckoutType":
            return Optional.ofNullable(clazz.cast(checkoutTypeAsString()));
        case "KeyFingerprint":
            return Optional.ofNullable(clazz.cast(keyFingerprint()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Beneficiary":
            return Optional.ofNullable(clazz.cast(beneficiary()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckoutLicenseRequest, T> g) {
        return obj -> g.apply((CheckoutLicenseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CheckoutLicenseRequest> {
        /**
         * <p>
         * Product SKU.
         * </p>
         * 
         * @param productSKU
         *        Product SKU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSKU(String productSKU);

        /**
         * <p>
         * Checkout type.
         * </p>
         * 
         * @param checkoutType
         *        Checkout type.
         * @see CheckoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckoutType
         */
        Builder checkoutType(String checkoutType);

        /**
         * <p>
         * Checkout type.
         * </p>
         * 
         * @param checkoutType
         *        Checkout type.
         * @see CheckoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckoutType
         */
        Builder checkoutType(CheckoutType checkoutType);

        /**
         * <p>
         * Key fingerprint identifying the license.
         * </p>
         * 
         * @param keyFingerprint
         *        Key fingerprint identifying the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<EntitlementData> entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * 
         * @param entitlements
         *        License entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(EntitlementData... entitlements);

        /**
         * <p>
         * License entitlements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntitlementData>.Builder} avoiding the need
         * to create one manually via {@link List<EntitlementData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitlementData>.Builder#build()} is called immediately and
         * its result is passed to {@link #entitlements(List<EntitlementData>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<EntitlementData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<EntitlementData>)
         */
        Builder entitlements(Consumer<EntitlementData.Builder>... entitlements);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * License beneficiary.
         * </p>
         * 
         * @param beneficiary
         *        License beneficiary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beneficiary(String beneficiary);

        /**
         * <p>
         * Node ID.
         * </p>
         * 
         * @param nodeId
         *        Node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String productSKU;

        private String checkoutType;

        private String keyFingerprint;

        private List<EntitlementData> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String beneficiary;

        private String nodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutLicenseRequest model) {
            super(model);
            productSKU(model.productSKU);
            checkoutType(model.checkoutType);
            keyFingerprint(model.keyFingerprint);
            entitlements(model.entitlements);
            clientToken(model.clientToken);
            beneficiary(model.beneficiary);
            nodeId(model.nodeId);
        }

        public final String getProductSKU() {
            return productSKU;
        }

        @Override
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        public final String getCheckoutType() {
            return checkoutType;
        }

        @Override
        public final Builder checkoutType(String checkoutType) {
            this.checkoutType = checkoutType;
            return this;
        }

        @Override
        public final Builder checkoutType(CheckoutType checkoutType) {
            this.checkoutType(checkoutType == null ? null : checkoutType.toString());
            return this;
        }

        public final void setCheckoutType(String checkoutType) {
            this.checkoutType = checkoutType;
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final List<EntitlementData.Builder> getEntitlements() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder entitlements(Collection<EntitlementData> entitlements) {
            this.entitlements = EntitlementDataListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(EntitlementData... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<EntitlementData.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> EntitlementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<EntitlementData.BuilderImpl> entitlements) {
            this.entitlements = EntitlementDataListCopier.copyFromBuilder(entitlements);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getBeneficiary() {
            return beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        public final String getNodeId() {
            return nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckoutLicenseRequest build() {
            return new CheckoutLicenseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
