/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseManagerReportGeneratorsResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListLicenseManagerReportGeneratorsResponse.Builder, ListLicenseManagerReportGeneratorsResponse> {
    private static final SdkField<List<ReportGenerator>> REPORT_GENERATORS_FIELD = SdkField
            .<List<ReportGenerator>> builder(MarshallingType.LIST)
            .memberName("ReportGenerators")
            .getter(getter(ListLicenseManagerReportGeneratorsResponse::reportGenerators))
            .setter(setter(Builder::reportGenerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGenerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportGenerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportGenerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseManagerReportGeneratorsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ReportGenerator> reportGenerators;

    private final String nextToken;

    private ListLicenseManagerReportGeneratorsResponse(BuilderImpl builder) {
        super(builder);
        this.reportGenerators = builder.reportGenerators;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ReportGenerators property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReportGenerators() {
        return reportGenerators != null && !(reportGenerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A report generator that creates periodic reports on your license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReportGenerators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A report generator that creates periodic reports on your license configurations.
     */
    public final List<ReportGenerator> reportGenerators() {
        return reportGenerators;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReportGenerators() ? reportGenerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseManagerReportGeneratorsResponse)) {
            return false;
        }
        ListLicenseManagerReportGeneratorsResponse other = (ListLicenseManagerReportGeneratorsResponse) obj;
        return hasReportGenerators() == other.hasReportGenerators()
                && Objects.equals(reportGenerators(), other.reportGenerators()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicenseManagerReportGeneratorsResponse")
                .add("ReportGenerators", hasReportGenerators() ? reportGenerators() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportGenerators":
            return Optional.ofNullable(clazz.cast(reportGenerators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseManagerReportGeneratorsResponse, T> g) {
        return obj -> g.apply((ListLicenseManagerReportGeneratorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseManagerReportGeneratorsResponse> {
        /**
         * <p>
         * A report generator that creates periodic reports on your license configurations.
         * </p>
         * 
         * @param reportGenerators
         *        A report generator that creates periodic reports on your license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGenerators(Collection<ReportGenerator> reportGenerators);

        /**
         * <p>
         * A report generator that creates periodic reports on your license configurations.
         * </p>
         * 
         * @param reportGenerators
         *        A report generator that creates periodic reports on your license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGenerators(ReportGenerator... reportGenerators);

        /**
         * <p>
         * A report generator that creates periodic reports on your license configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReportGenerator>.Builder} avoiding the need
         * to create one manually via {@link List<ReportGenerator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReportGenerator>.Builder#build()} is called immediately and
         * its result is passed to {@link #reportGenerators(List<ReportGenerator>)}.
         * 
         * @param reportGenerators
         *        a consumer that will call methods on {@link List<ReportGenerator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportGenerators(List<ReportGenerator>)
         */
        Builder reportGenerators(Consumer<ReportGenerator.Builder>... reportGenerators);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<ReportGenerator> reportGenerators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseManagerReportGeneratorsResponse model) {
            super(model);
            reportGenerators(model.reportGenerators);
            nextToken(model.nextToken);
        }

        public final List<ReportGenerator.Builder> getReportGenerators() {
            List<ReportGenerator.Builder> result = ReportGeneratorListCopier.copyToBuilder(this.reportGenerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder reportGenerators(Collection<ReportGenerator> reportGenerators) {
            this.reportGenerators = ReportGeneratorListCopier.copy(reportGenerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGenerators(ReportGenerator... reportGenerators) {
            reportGenerators(Arrays.asList(reportGenerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGenerators(Consumer<ReportGenerator.Builder>... reportGenerators) {
            reportGenerators(Stream.of(reportGenerators).map(c -> ReportGenerator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReportGenerators(Collection<ReportGenerator.BuilderImpl> reportGenerators) {
            this.reportGenerators = ReportGeneratorListCopier.copyFromBuilder(reportGenerators);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLicenseManagerReportGeneratorsResponse build() {
            return new ListLicenseManagerReportGeneratorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
