/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanager.model.AuthorizationException;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.ConflictException;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.EntitlementNotAllowedException;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse;
import software.amazon.awssdk.services.licensemanager.model.FailedDependencyException;
import software.amazon.awssdk.services.licensemanager.model.FilterLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.GetGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.GetGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.InvalidParameterValueException;
import software.amazon.awssdk.services.licensemanager.model.InvalidResourceStateException;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerException;
import software.amazon.awssdk.services.licensemanager.model.LicenseUsageException;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTokensRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTokensResponse;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.NoEntitlementsAllowedException;
import software.amazon.awssdk.services.licensemanager.model.RateLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.RedirectException;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanager.model.ServerInternalException;
import software.amazon.awssdk.services.licensemanager.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UnsupportedDigitalSignatureMethodException;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.ValidationException;

/**
 * Service client for accessing AWS License Manager. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * License Manager makes it easier to manage licenses from software vendors across multiple Amazon Web Services accounts
 * and on-premises servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerClient extends SdkClient {
    String SERVICE_NAME = "license-manager";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager";

    /**
     * Create a {@link LicenseManagerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerClient}.
     */
    static LicenseManagerClientBuilder builder() {
        return new DefaultLicenseManagerClientBuilder();
    }

    /**
     * <p>
     * Accepts the specified grant.
     * </p>
     *
     * @param acceptGrantRequest
     * @return Result of the AcceptGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.AcceptGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/AcceptGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptGrantResponse acceptGrant(AcceptGrantRequest acceptGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptGrantRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptGrantRequest#builder()}
     * </p>
     *
     * @param acceptGrantRequest
     *        A {@link Consumer} that will call methods on {@link AcceptGrantRequest.Builder} to create a request.
     * @return Result of the AcceptGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.AcceptGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/AcceptGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptGrantResponse acceptGrant(Consumer<AcceptGrantRequest.Builder> acceptGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return acceptGrant(AcceptGrantRequest.builder().applyMutation(acceptGrantRequest).build());
    }

    /**
     * <p>
     * Checks in the specified license. Check in a license when it is no longer in use.
     * </p>
     *
     * @param checkInLicenseRequest
     * @return Result of the CheckInLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckInLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckInLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckInLicenseResponse checkInLicense(CheckInLicenseRequest checkInLicenseRequest) throws ValidationException,
            InvalidParameterValueException, ResourceNotFoundException, ConflictException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks in the specified license. Check in a license when it is no longer in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckInLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link CheckInLicenseRequest#builder()}
     * </p>
     *
     * @param checkInLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckInLicenseRequest.Builder} to create a request.
     * @return Result of the CheckInLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckInLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckInLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckInLicenseResponse checkInLicense(Consumer<CheckInLicenseRequest.Builder> checkInLicenseRequest)
            throws ValidationException, InvalidParameterValueException, ResourceNotFoundException, ConflictException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return checkInLicense(CheckInLicenseRequest.builder().applyMutation(checkInLicenseRequest).build());
    }

    /**
     * <p>
     * Checks out the specified license for offline use.
     * </p>
     *
     * @param checkoutBorrowLicenseRequest
     * @return Result of the CheckoutBorrowLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws NoEntitlementsAllowedException
     *         There are no entitlements found for this license, or the entitlement maximum count is reached.
     * @throws EntitlementNotAllowedException
     *         The entitlement is not allowed.
     * @throws UnsupportedDigitalSignatureMethodException
     *         The digital signature method is unsupported. Try your request again.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckoutBorrowLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutBorrowLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckoutBorrowLicenseResponse checkoutBorrowLicense(CheckoutBorrowLicenseRequest checkoutBorrowLicenseRequest)
            throws ValidationException, InvalidParameterValueException, ResourceNotFoundException,
            NoEntitlementsAllowedException, EntitlementNotAllowedException, UnsupportedDigitalSignatureMethodException,
            RedirectException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks out the specified license for offline use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckoutBorrowLicenseRequest.Builder} avoiding the
     * need to create one manually via {@link CheckoutBorrowLicenseRequest#builder()}
     * </p>
     *
     * @param checkoutBorrowLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckoutBorrowLicenseRequest.Builder} to create a
     *        request.
     * @return Result of the CheckoutBorrowLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws NoEntitlementsAllowedException
     *         There are no entitlements found for this license, or the entitlement maximum count is reached.
     * @throws EntitlementNotAllowedException
     *         The entitlement is not allowed.
     * @throws UnsupportedDigitalSignatureMethodException
     *         The digital signature method is unsupported. Try your request again.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckoutBorrowLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutBorrowLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckoutBorrowLicenseResponse checkoutBorrowLicense(
            Consumer<CheckoutBorrowLicenseRequest.Builder> checkoutBorrowLicenseRequest) throws ValidationException,
            InvalidParameterValueException, ResourceNotFoundException, NoEntitlementsAllowedException,
            EntitlementNotAllowedException, UnsupportedDigitalSignatureMethodException, RedirectException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return checkoutBorrowLicense(CheckoutBorrowLicenseRequest.builder().applyMutation(checkoutBorrowLicenseRequest).build());
    }

    /**
     * <p>
     * Checks out the specified license.
     * </p>
     * <note>
     * <p>
     * If the account that created the license is the same that is performing the check out, you must specify the
     * account as the beneficiary.
     * </p>
     * </note>
     *
     * @param checkoutLicenseRequest
     * @return Result of the CheckoutLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws NoEntitlementsAllowedException
     *         There are no entitlements found for this license, or the entitlement maximum count is reached.
     * @throws UnsupportedDigitalSignatureMethodException
     *         The digital signature method is unsupported. Try your request again.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckoutLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckoutLicenseResponse checkoutLicense(CheckoutLicenseRequest checkoutLicenseRequest) throws ValidationException,
            InvalidParameterValueException, ResourceNotFoundException, NoEntitlementsAllowedException,
            UnsupportedDigitalSignatureMethodException, RedirectException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks out the specified license.
     * </p>
     * <note>
     * <p>
     * If the account that created the license is the same that is performing the check out, you must specify the
     * account as the beneficiary.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckoutLicenseRequest.Builder} avoiding the need
     * to create one manually via {@link CheckoutLicenseRequest#builder()}
     * </p>
     *
     * @param checkoutLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CheckoutLicenseRequest.Builder} to create a request.
     * @return Result of the CheckoutLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws NoEntitlementsAllowedException
     *         There are no entitlements found for this license, or the entitlement maximum count is reached.
     * @throws UnsupportedDigitalSignatureMethodException
     *         The digital signature method is unsupported. Try your request again.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CheckoutLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CheckoutLicense"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckoutLicenseResponse checkoutLicense(Consumer<CheckoutLicenseRequest.Builder> checkoutLicenseRequest)
            throws ValidationException, InvalidParameterValueException, ResourceNotFoundException,
            NoEntitlementsAllowedException, UnsupportedDigitalSignatureMethodException, RedirectException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return checkoutLicense(CheckoutLicenseRequest.builder().applyMutation(checkoutLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon
     * Web Services accounts.
     * </p>
     *
     * @param createGrantRequest
     * @return Result of the CreateGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon
     * Web Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGrantRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGrantRequest#builder()}
     * </p>
     *
     * @param createGrantRequest
     *        A {@link Consumer} that will call methods on {@link CreateGrantRequest.Builder} to create a request.
     * @return Result of the CreateGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGrantResponse createGrant(Consumer<CreateGrantRequest.Builder> createGrantRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerException {
        return createGrant(CreateGrantRequest.builder().applyMutation(createGrantRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified grant.
     * </p>
     *
     * @param createGrantVersionRequest
     * @return Result of the CreateGrantVersion operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateGrantVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrantVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGrantVersionResponse createGrantVersion(CreateGrantVersionRequest createGrantVersionRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGrantVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGrantVersionRequest#builder()}
     * </p>
     *
     * @param createGrantVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateGrantVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGrantVersion operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateGrantVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateGrantVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGrantVersionResponse createGrantVersion(Consumer<CreateGrantVersionRequest.Builder> createGrantVersionRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return createGrantVersion(CreateGrantVersionRequest.builder().applyMutation(createGrantVersionRequest).build());
    }

    /**
     * <p>
     * Creates a license.
     * </p>
     *
     * @param createLicenseRequest
     * @return Result of the CreateLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLicenseResponse createLicense(CreateLicenseRequest createLicenseRequest) throws ValidationException,
            InvalidParameterValueException, RedirectException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLicenseRequest#builder()}
     * </p>
     *
     * @param createLicenseRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseRequest.Builder} to create a request.
     * @return Result of the CreateLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLicenseResponse createLicense(Consumer<CreateLicenseRequest.Builder> createLicenseRequest)
            throws ValidationException, InvalidParameterValueException, RedirectException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return createLicense(CreateLicenseRequest.builder().applyMutation(createLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a license configuration.
     * </p>
     * <p>
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by
     * License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or
     * vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to
     * host (how long a license must be associated with a host), and the number of licenses purchased and used.
     * </p>
     *
     * @param createLicenseConfigurationRequest
     * @return Result of the CreateLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseConfigurationResponse createLicenseConfiguration(
            CreateLicenseConfigurationRequest createLicenseConfigurationRequest) throws InvalidParameterValueException,
            ServerInternalException, ResourceLimitExceededException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a license configuration.
     * </p>
     * <p>
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by
     * License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or
     * vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to
     * host (how long a license must be associated with a host), and the number of licenses purchased and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param createLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseConfigurationResponse createLicenseConfiguration(
            Consumer<CreateLicenseConfigurationRequest.Builder> createLicenseConfigurationRequest)
            throws InvalidParameterValueException, ServerInternalException, ResourceLimitExceededException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return createLicenseConfiguration(CreateLicenseConfigurationRequest.builder()
                .applyMutation(createLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new license conversion task.
     * </p>
     *
     * @param createLicenseConversionTaskForResourceRequest
     * @return Result of the CreateLicenseConversionTaskForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseConversionTaskForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConversionTaskForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseConversionTaskForResourceResponse createLicenseConversionTaskForResource(
            CreateLicenseConversionTaskForResourceRequest createLicenseConversionTaskForResourceRequest)
            throws InvalidParameterValueException, ValidationException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new license conversion task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateLicenseConversionTaskForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link CreateLicenseConversionTaskForResourceRequest#builder()}
     * </p>
     *
     * @param createLicenseConversionTaskForResourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseConversionTaskForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the CreateLicenseConversionTaskForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseConversionTaskForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConversionTaskForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseConversionTaskForResourceResponse createLicenseConversionTaskForResource(
            Consumer<CreateLicenseConversionTaskForResourceRequest.Builder> createLicenseConversionTaskForResourceRequest)
            throws InvalidParameterValueException, ValidationException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return createLicenseConversionTaskForResource(CreateLicenseConversionTaskForResourceRequest.builder()
                .applyMutation(createLicenseConversionTaskForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a report generator.
     * </p>
     *
     * @param createLicenseManagerReportGeneratorRequest
     * @return Result of the CreateLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseManagerReportGeneratorResponse createLicenseManagerReportGenerator(
            CreateLicenseManagerReportGeneratorRequest createLicenseManagerReportGeneratorRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a report generator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param createLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseManagerReportGeneratorResponse createLicenseManagerReportGenerator(
            Consumer<CreateLicenseManagerReportGeneratorRequest.Builder> createLicenseManagerReportGeneratorRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(createLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified license.
     * </p>
     *
     * @param createLicenseVersionRequest
     * @return Result of the CreateLicenseVersion operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseVersionResponse createLicenseVersion(CreateLicenseVersionRequest createLicenseVersionRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, RedirectException, ConflictException,
            ServerInternalException, AuthorizationException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLicenseVersionRequest#builder()}
     * </p>
     *
     * @param createLicenseVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLicenseVersion operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateLicenseVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseVersionResponse createLicenseVersion(
            Consumer<CreateLicenseVersionRequest.Builder> createLicenseVersionRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, RedirectException, ConflictException, ServerInternalException,
            AuthorizationException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return createLicenseVersion(CreateLicenseVersionRequest.builder().applyMutation(createLicenseVersionRequest).build());
    }

    /**
     * <p>
     * Creates a long-lived token.
     * </p>
     * <p>
     * A refresh token is a JWT token used to get an access token. With an access token, you can call
     * AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the
     * specified license.
     * </p>
     *
     * @param createTokenRequest
     * @return Result of the CreateToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException,
            ServerInternalException, ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a long-lived token.
     * </p>
     * <p>
     * A refresh token is a JWT token used to get an access token. With an access token, you can call
     * AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the
     * specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTokenRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTokenRequest#builder()}
     * </p>
     *
     * @param createTokenRequest
     *        A {@link Consumer} that will call methods on {@link CreateTokenRequest.Builder} to create a request.
     * @return Result of the CreateToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTokenResponse createToken(Consumer<CreateTokenRequest.Builder> createTokenRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException,
            ServerInternalException, ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return createToken(CreateTokenRequest.builder().applyMutation(createTokenRequest).build());
    }

    /**
     * <p>
     * Deletes the specified grant.
     * </p>
     *
     * @param deleteGrantRequest
     * @return Result of the DeleteGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGrantResponse deleteGrant(DeleteGrantRequest deleteGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGrantRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGrantRequest#builder()}
     * </p>
     *
     * @param deleteGrantRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGrantRequest.Builder} to create a request.
     * @return Result of the DeleteGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGrantResponse deleteGrant(Consumer<DeleteGrantRequest.Builder> deleteGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return deleteGrant(DeleteGrantRequest.builder().applyMutation(deleteGrantRequest).build());
    }

    /**
     * <p>
     * Deletes the specified license.
     * </p>
     *
     * @param deleteLicenseRequest
     * @return Result of the DeleteLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLicenseResponse deleteLicense(DeleteLicenseRequest deleteLicenseRequest) throws ValidationException,
            InvalidParameterValueException, RedirectException, ConflictException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLicenseRequest#builder()}
     * </p>
     *
     * @param deleteLicenseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseRequest.Builder} to create a request.
     * @return Result of the DeleteLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLicenseResponse deleteLicense(Consumer<DeleteLicenseRequest.Builder> deleteLicenseRequest)
            throws ValidationException, InvalidParameterValueException, RedirectException, ConflictException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return deleteLicense(DeleteLicenseRequest.builder().applyMutation(deleteLicenseRequest).build());
    }

    /**
     * <p>
     * Deletes the specified license configuration.
     * </p>
     * <p>
     * You cannot delete a license configuration that is in use.
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     * @return Result of the DeleteLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseConfigurationResponse deleteLicenseConfiguration(
            DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified license configuration.
     * </p>
     * <p>
     * You cannot delete a license configuration that is in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseConfigurationResponse deleteLicenseConfiguration(
            Consumer<DeleteLicenseConfigurationRequest.Builder> deleteLicenseConfigurationRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return deleteLicenseConfiguration(DeleteLicenseConfigurationRequest.builder()
                .applyMutation(deleteLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified report generator.
     * </p>
     * <p>
     * This action deletes the report generator, which stops it from generating future reports. The action cannot be
     * reversed. It has no effect on the previous reports from this generator.
     * </p>
     *
     * @param deleteLicenseManagerReportGeneratorRequest
     * @return Result of the DeleteLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseManagerReportGeneratorResponse deleteLicenseManagerReportGenerator(
            DeleteLicenseManagerReportGeneratorRequest deleteLicenseManagerReportGeneratorRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified report generator.
     * </p>
     * <p>
     * This action deletes the report generator, which stops it from generating future reports. The action cannot be
     * reversed. It has no effect on the previous reports from this generator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param deleteLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseManagerReportGeneratorResponse deleteLicenseManagerReportGenerator(
            Consumer<DeleteLicenseManagerReportGeneratorRequest.Builder> deleteLicenseManagerReportGeneratorRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(deleteLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified token. Must be called in the license home Region.
     * </p>
     *
     * @param deleteTokenRequest
     * @return Result of the DeleteToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTokenResponse deleteToken(DeleteTokenRequest deleteTokenRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified token. Must be called in the license home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTokenRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTokenRequest#builder()}
     * </p>
     *
     * @param deleteTokenRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTokenRequest.Builder} to create a request.
     * @return Result of the DeleteToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws RedirectException
     *         This is not the correct Region for the resource. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTokenResponse deleteToken(Consumer<DeleteTokenRequest.Builder> deleteTokenRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException, LicenseManagerException {
        return deleteToken(DeleteTokenRequest.builder().applyMutation(deleteTokenRequest).build());
    }

    /**
     * <p>
     * Extends the expiration date for license consumption.
     * </p>
     *
     * @param extendLicenseConsumptionRequest
     * @return Result of the ExtendLicenseConsumption operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ExtendLicenseConsumption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ExtendLicenseConsumption"
     *      target="_top">AWS API Documentation</a>
     */
    default ExtendLicenseConsumptionResponse extendLicenseConsumption(
            ExtendLicenseConsumptionRequest extendLicenseConsumptionRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Extends the expiration date for license consumption.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExtendLicenseConsumptionRequest.Builder} avoiding
     * the need to create one manually via {@link ExtendLicenseConsumptionRequest#builder()}
     * </p>
     *
     * @param extendLicenseConsumptionRequest
     *        A {@link Consumer} that will call methods on {@link ExtendLicenseConsumptionRequest.Builder} to create a
     *        request.
     * @return Result of the ExtendLicenseConsumption operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ExtendLicenseConsumption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ExtendLicenseConsumption"
     *      target="_top">AWS API Documentation</a>
     */
    default ExtendLicenseConsumptionResponse extendLicenseConsumption(
            Consumer<ExtendLicenseConsumptionRequest.Builder> extendLicenseConsumptionRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        return extendLicenseConsumption(ExtendLicenseConsumptionRequest.builder().applyMutation(extendLicenseConsumptionRequest)
                .build());
    }

    /**
     * <p>
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     * </p>
     *
     * @param getAccessTokenRequest
     * @return Result of the GetAccessToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessTokenResponse getAccessToken(GetAccessTokenRequest getAccessTokenRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccessTokenRequest#builder()}
     * </p>
     *
     * @param getAccessTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetAccessTokenRequest.Builder} to create a request.
     * @return Result of the GetAccessToken operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessTokenResponse getAccessToken(Consumer<GetAccessTokenRequest.Builder> getAccessTokenRequest)
            throws ValidationException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getAccessToken(GetAccessTokenRequest.builder().applyMutation(getAccessTokenRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified grant.
     * </p>
     *
     * @param getGrantRequest
     * @return Result of the GetGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGrantResponse getGrant(GetGrantRequest getGrantRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGrantRequest.Builder} avoiding the need to
     * create one manually via {@link GetGrantRequest#builder()}
     * </p>
     *
     * @param getGrantRequest
     *        A {@link Consumer} that will call methods on {@link GetGrantRequest.Builder} to create a request.
     * @return Result of the GetGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetGrant" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGrantResponse getGrant(Consumer<GetGrantRequest.Builder> getGrantRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getGrant(GetGrantRequest.builder().applyMutation(getGrantRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified license.
     * </p>
     *
     * @param getLicenseRequest
     * @return Result of the GetLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLicenseResponse getLicense(GetLicenseRequest getLicenseRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseRequest.Builder} avoiding the need to
     * create one manually via {@link GetLicenseRequest#builder()}
     * </p>
     *
     * @param getLicenseRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseRequest.Builder} to create a request.
     * @return Result of the GetLicense operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLicenseResponse getLicense(Consumer<GetLicenseRequest.Builder> getLicenseRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getLicense(GetLicenseRequest.builder().applyMutation(getLicenseRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the specified license configuration.
     * </p>
     *
     * @param getLicenseConfigurationRequest
     * @return Result of the GetLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseConfigurationResponse getLicenseConfiguration(GetLicenseConfigurationRequest getLicenseConfigurationRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param getLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseConfigurationResponse getLicenseConfiguration(
            Consumer<GetLicenseConfigurationRequest.Builder> getLicenseConfigurationRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getLicenseConfiguration(GetLicenseConfigurationRequest.builder().applyMutation(getLicenseConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified license type conversion task.
     * </p>
     *
     * @param getLicenseConversionTaskRequest
     * @return Result of the GetLicenseConversionTask operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConversionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseConversionTaskResponse getLicenseConversionTask(
            GetLicenseConversionTaskRequest getLicenseConversionTaskRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified license type conversion task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseConversionTaskRequest.Builder} avoiding
     * the need to create one manually via {@link GetLicenseConversionTaskRequest#builder()}
     * </p>
     *
     * @param getLicenseConversionTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseConversionTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetLicenseConversionTask operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConversionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseConversionTaskResponse getLicenseConversionTask(
            Consumer<GetLicenseConversionTaskRequest.Builder> getLicenseConversionTaskRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getLicenseConversionTask(GetLicenseConversionTaskRequest.builder().applyMutation(getLicenseConversionTaskRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified report generator.
     * </p>
     *
     * @param getLicenseManagerReportGeneratorRequest
     * @return Result of the GetLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseManagerReportGeneratorResponse getLicenseManagerReportGenerator(
            GetLicenseManagerReportGeneratorRequest getLicenseManagerReportGeneratorRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified report generator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link GetLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param getLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return Result of the GetLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseManagerReportGeneratorResponse getLicenseManagerReportGenerator(
            Consumer<GetLicenseManagerReportGeneratorRequest.Builder> getLicenseManagerReportGeneratorRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(getLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about the usage of the specified license.
     * </p>
     *
     * @param getLicenseUsageRequest
     * @return Result of the GetLicenseUsage operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseUsageResponse getLicenseUsage(GetLicenseUsageRequest getLicenseUsageRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about the usage of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseUsageRequest.Builder} avoiding the need
     * to create one manually via {@link GetLicenseUsageRequest#builder()}
     * </p>
     *
     * @param getLicenseUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseUsageRequest.Builder} to create a request.
     * @return Result of the GetLicenseUsage operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetLicenseUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLicenseUsageResponse getLicenseUsage(Consumer<GetLicenseUsageRequest.Builder> getLicenseUsageRequest)
            throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getLicenseUsage(GetLicenseUsageRequest.builder().applyMutation(getLicenseUsageRequest).build());
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     *
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetServiceSettings
     * @see #getServiceSettings(GetServiceSettingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings() throws ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return getServiceSettings(GetServiceSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest)
            throws ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the License Manager settings for the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.GetServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest)
            throws ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the resource associations for the specified license configuration.
     * </p>
     * <p>
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped
     * instance might not consume a license (depending on the license rules).
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     * @return Result of the ListAssociationsForLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociationsForLicenseConfigurationResponse listAssociationsForLicenseConfiguration(
            ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest)
            throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource associations for the specified license configuration.
     * </p>
     * <p>
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped
     * instance might not consume a license (depending on the license rules).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssociationsForLicenseConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssociationsForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssociationsForLicenseConfigurationRequest.Builder} to create a request.
     * @return Result of the ListAssociationsForLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociationsForLicenseConfigurationResponse listAssociationsForLicenseConfiguration(
            Consumer<ListAssociationsForLicenseConfigurationRequest.Builder> listAssociationsForLicenseConfigurationRequest)
            throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest.builder()
                .applyMutation(listAssociationsForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists the grants distributed for the specified license.
     * </p>
     *
     * @param listDistributedGrantsRequest
     * @return Result of the ListDistributedGrants operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListDistributedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListDistributedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributedGrantsResponse listDistributedGrants(ListDistributedGrantsRequest listDistributedGrantsRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the grants distributed for the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributedGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDistributedGrantsRequest#builder()}
     * </p>
     *
     * @param listDistributedGrantsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributedGrantsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDistributedGrants operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListDistributedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListDistributedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributedGrantsResponse listDistributedGrants(
            Consumer<ListDistributedGrantsRequest.Builder> listDistributedGrantsRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listDistributedGrants(ListDistributedGrantsRequest.builder().applyMutation(listDistributedGrantsRequest).build());
    }

    /**
     * <p>
     * Lists the license configuration operations that failed.
     * </p>
     *
     * @param listFailuresForLicenseConfigurationOperationsRequest
     * @return Result of the ListFailuresForLicenseConfigurationOperations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListFailuresForLicenseConfigurationOperations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFailuresForLicenseConfigurationOperationsResponse listFailuresForLicenseConfigurationOperations(
            ListFailuresForLicenseConfigurationOperationsRequest listFailuresForLicenseConfigurationOperationsRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the license configuration operations that failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListFailuresForLicenseConfigurationOperationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListFailuresForLicenseConfigurationOperationsRequest#builder()}
     * </p>
     *
     * @param listFailuresForLicenseConfigurationOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListFailuresForLicenseConfigurationOperationsRequest.Builder} to create a request.
     * @return Result of the ListFailuresForLicenseConfigurationOperations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListFailuresForLicenseConfigurationOperations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFailuresForLicenseConfigurationOperationsResponse listFailuresForLicenseConfigurationOperations(
            Consumer<ListFailuresForLicenseConfigurationOperationsRequest.Builder> listFailuresForLicenseConfigurationOperationsRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listFailuresForLicenseConfigurationOperations(ListFailuresForLicenseConfigurationOperationsRequest.builder()
                .applyMutation(listFailuresForLicenseConfigurationOperationsRequest).build());
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     *
     * @return Result of the ListLicenseConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseConfigurations
     * @see #listLicenseConfigurations(ListLicenseConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseConfigurationsResponse listLicenseConfigurations() throws InvalidParameterValueException,
            ServerInternalException, FilterLimitExceededException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     * @return Result of the ListLicenseConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseConfigurationsResponse listLicenseConfigurations(
            ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) throws InvalidParameterValueException,
            ServerInternalException, FilterLimitExceededException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the license configurations for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLicenseConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseConfigurationsResponse listLicenseConfigurations(
            Consumer<ListLicenseConfigurationsRequest.Builder> listLicenseConfigurationsRequest)
            throws InvalidParameterValueException, ServerInternalException, FilterLimitExceededException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder()
                .applyMutation(listLicenseConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the license type conversion tasks for your account.
     * </p>
     *
     * @param listLicenseConversionTasksRequest
     * @return Result of the ListLicenseConversionTasks operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseConversionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConversionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseConversionTasksResponse listLicenseConversionTasks(
            ListLicenseConversionTasksRequest listLicenseConversionTasksRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the license type conversion tasks for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseConversionTasksRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseConversionTasksRequest#builder()}
     * </p>
     *
     * @param listLicenseConversionTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseConversionTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListLicenseConversionTasks operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseConversionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConversionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseConversionTasksResponse listLicenseConversionTasks(
            Consumer<ListLicenseConversionTasksRequest.Builder> listLicenseConversionTasksRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseConversionTasks(ListLicenseConversionTasksRequest.builder()
                .applyMutation(listLicenseConversionTasksRequest).build());
    }

    /**
     * <p>
     * Lists the report generators for your account.
     * </p>
     *
     * @param listLicenseManagerReportGeneratorsRequest
     * @return Result of the ListLicenseManagerReportGenerators operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseManagerReportGenerators
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseManagerReportGenerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseManagerReportGeneratorsResponse listLicenseManagerReportGenerators(
            ListLicenseManagerReportGeneratorsRequest listLicenseManagerReportGeneratorsRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the report generators for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseManagerReportGeneratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListLicenseManagerReportGeneratorsRequest#builder()}
     * </p>
     *
     * @param listLicenseManagerReportGeneratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseManagerReportGeneratorsRequest.Builder} to
     *        create a request.
     * @return Result of the ListLicenseManagerReportGenerators operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseManagerReportGenerators
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseManagerReportGenerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseManagerReportGeneratorsResponse listLicenseManagerReportGenerators(
            Consumer<ListLicenseManagerReportGeneratorsRequest.Builder> listLicenseManagerReportGeneratorsRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest.builder()
                .applyMutation(listLicenseManagerReportGeneratorsRequest).build());
    }

    /**
     * <p>
     * Describes the license configurations for the specified resource.
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     * @return Result of the ListLicenseSpecificationsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseSpecificationsForResourceResponse listLicenseSpecificationsForResource(
            ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the license configurations for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the ListLicenseSpecificationsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseSpecificationsForResourceResponse listLicenseSpecificationsForResource(
            Consumer<ListLicenseSpecificationsForResourceRequest.Builder> listLicenseSpecificationsForResourceRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(listLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all versions of the specified license.
     * </p>
     *
     * @param listLicenseVersionsRequest
     * @return Result of the ListLicenseVersions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseVersionsResponse listLicenseVersions(ListLicenseVersionsRequest listLicenseVersionsRequest)
            throws InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of the specified license.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLicenseVersionsRequest#builder()}
     * </p>
     *
     * @param listLicenseVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLicenseVersions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenseVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseVersionsResponse listLicenseVersions(
            Consumer<ListLicenseVersionsRequest.Builder> listLicenseVersionsRequest) throws InvalidParameterValueException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenseVersions(ListLicenseVersionsRequest.builder().applyMutation(listLicenseVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the licenses for your account.
     * </p>
     *
     * @param listLicensesRequest
     * @return Result of the ListLicenses operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicensesResponse listLicenses(ListLicensesRequest listLicensesRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the licenses for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLicensesRequest#builder()}
     * </p>
     *
     * @param listLicensesRequest
     *        A {@link Consumer} that will call methods on {@link ListLicensesRequest.Builder} to create a request.
     * @return Result of the ListLicenses operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLicensesResponse listLicenses(Consumer<ListLicensesRequest.Builder> listLicensesRequest)
            throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listLicenses(ListLicensesRequest.builder().applyMutation(listLicensesRequest).build());
    }

    /**
     * <p>
     * Lists grants that are received but not accepted.
     * </p>
     *
     * @param listReceivedGrantsRequest
     * @return Result of the ListReceivedGrants operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedGrantsResponse listReceivedGrants(ListReceivedGrantsRequest listReceivedGrantsRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists grants that are received but not accepted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedGrantsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceivedGrantsRequest#builder()}
     * </p>
     *
     * @param listReceivedGrantsRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedGrantsRequest.Builder} to create a
     *        request.
     * @return Result of the ListReceivedGrants operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedGrantsResponse listReceivedGrants(Consumer<ListReceivedGrantsRequest.Builder> listReceivedGrantsRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return listReceivedGrants(ListReceivedGrantsRequest.builder().applyMutation(listReceivedGrantsRequest).build());
    }

    /**
     * <p>
     * Lists the grants received for all accounts in the organization.
     * </p>
     *
     * @param listReceivedGrantsForOrganizationRequest
     * @return Result of the ListReceivedGrantsForOrganization operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedGrantsForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrantsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedGrantsForOrganizationResponse listReceivedGrantsForOrganization(
            ListReceivedGrantsForOrganizationRequest listReceivedGrantsForOrganizationRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the grants received for all accounts in the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedGrantsForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link ListReceivedGrantsForOrganizationRequest#builder()}
     * </p>
     *
     * @param listReceivedGrantsForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedGrantsForOrganizationRequest.Builder} to
     *        create a request.
     * @return Result of the ListReceivedGrantsForOrganization operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedGrantsForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedGrantsForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedGrantsForOrganizationResponse listReceivedGrantsForOrganization(
            Consumer<ListReceivedGrantsForOrganizationRequest.Builder> listReceivedGrantsForOrganizationRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return listReceivedGrantsForOrganization(ListReceivedGrantsForOrganizationRequest.builder()
                .applyMutation(listReceivedGrantsForOrganizationRequest).build());
    }

    /**
     * <p>
     * Lists received licenses.
     * </p>
     *
     * @param listReceivedLicensesRequest
     * @return Result of the ListReceivedLicenses operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicenses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedLicensesResponse listReceivedLicenses(ListReceivedLicensesRequest listReceivedLicensesRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists received licenses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedLicensesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceivedLicensesRequest#builder()}
     * </p>
     *
     * @param listReceivedLicensesRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedLicensesRequest.Builder} to create a
     *        request.
     * @return Result of the ListReceivedLicenses operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedLicenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicenses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedLicensesResponse listReceivedLicenses(
            Consumer<ListReceivedLicensesRequest.Builder> listReceivedLicensesRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listReceivedLicenses(ListReceivedLicensesRequest.builder().applyMutation(listReceivedLicensesRequest).build());
    }

    /**
     * <p>
     * Lists the licenses received for all accounts in the organization.
     * </p>
     *
     * @param listReceivedLicensesForOrganizationRequest
     * @return Result of the ListReceivedLicensesForOrganization operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedLicensesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicensesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedLicensesForOrganizationResponse listReceivedLicensesForOrganization(
            ListReceivedLicensesForOrganizationRequest listReceivedLicensesForOrganizationRequest) throws ValidationException,
            InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the licenses received for all accounts in the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceivedLicensesForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link ListReceivedLicensesForOrganizationRequest#builder()}
     * </p>
     *
     * @param listReceivedLicensesForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link ListReceivedLicensesForOrganizationRequest.Builder} to
     *        create a request.
     * @return Result of the ListReceivedLicensesForOrganization operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListReceivedLicensesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListReceivedLicensesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReceivedLicensesForOrganizationResponse listReceivedLicensesForOrganization(
            Consumer<ListReceivedLicensesForOrganizationRequest.Builder> listReceivedLicensesForOrganizationRequest)
            throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return listReceivedLicensesForOrganization(ListReceivedLicensesForOrganizationRequest.builder()
                .applyMutation(listReceivedLicensesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Lists resources managed using Systems Manager inventory.
     * </p>
     *
     * @param listResourceInventoryRequest
     * @return Result of the ListResourceInventory operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws FailedDependencyException
     *         A dependency required to run the API is missing.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListResourceInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceInventoryResponse listResourceInventory(ListResourceInventoryRequest listResourceInventoryRequest)
            throws InvalidParameterValueException, ServerInternalException, FilterLimitExceededException,
            FailedDependencyException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists resources managed using Systems Manager inventory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceInventoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceInventoryRequest#builder()}
     * </p>
     *
     * @param listResourceInventoryRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceInventoryRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceInventory operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws FailedDependencyException
     *         A dependency required to run the API is missing.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListResourceInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceInventoryResponse listResourceInventory(
            Consumer<ListResourceInventoryRequest.Builder> listResourceInventoryRequest) throws InvalidParameterValueException,
            ServerInternalException, FilterLimitExceededException, FailedDependencyException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listResourceInventory(ListResourceInventoryRequest.builder().applyMutation(listResourceInventoryRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified license configuration.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your tokens.
     * </p>
     *
     * @param listTokensRequest
     * @return Result of the ListTokens operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTokens" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTokensResponse listTokens(ListTokensRequest listTokensRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your tokens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTokensRequest.Builder} avoiding the need to
     * create one manually via {@link ListTokensRequest#builder()}
     * </p>
     *
     * @param listTokensRequest
     *        A {@link Consumer} that will call methods on {@link ListTokensRequest.Builder} to create a request.
     * @return Result of the ListTokens operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTokens" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTokensResponse listTokens(Consumer<ListTokensRequest.Builder> listTokensRequest) throws ValidationException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return listTokens(ListTokensRequest.builder().applyMutation(listTokensRequest).build());
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     * @return Result of the ListUsageForLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListUsageForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageForLicenseConfigurationResponse listUsageForLicenseConfiguration(
            ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest)
            throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageForLicenseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ListUsageForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageForLicenseConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the ListUsageForLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws FilterLimitExceededException
     *         The request uses too many filters or too many filter values.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.ListUsageForLicenseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageForLicenseConfigurationResponse listUsageForLicenseConfiguration(
            Consumer<ListUsageForLicenseConfigurationRequest.Builder> listUsageForLicenseConfigurationRequest)
            throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest.builder()
                .applyMutation(listUsageForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Rejects the specified grant.
     * </p>
     *
     * @param rejectGrantRequest
     * @return Result of the RejectGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.RejectGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/RejectGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectGrantResponse rejectGrant(RejectGrantRequest rejectGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects the specified grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectGrantRequest.Builder} avoiding the need to
     * create one manually via {@link RejectGrantRequest#builder()}
     * </p>
     *
     * @param rejectGrantRequest
     *        A {@link Consumer} that will call methods on {@link RejectGrantRequest.Builder} to create a request.
     * @return Result of the RejectGrant operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.RejectGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/RejectGrant" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectGrantResponse rejectGrant(Consumer<RejectGrantRequest.Builder> rejectGrantRequest) throws ValidationException,
            InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return rejectGrant(RejectGrantRequest.builder().applyMutation(rejectGrantRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified license configuration.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified license configuration.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration.
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     * @return Result of the UpdateLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseConfigurationResponse updateLicenseConfiguration(
            UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLicenseConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseConfigurationResponse updateLicenseConfiguration(
            Consumer<UpdateLicenseConfigurationRequest.Builder> updateLicenseConfigurationRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return updateLicenseConfiguration(UpdateLicenseConfigurationRequest.builder()
                .applyMutation(updateLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a report generator.
     * </p>
     * <p>
     * After you make changes to a report generator, it starts generating new reports within 60 minutes of being
     * updated.
     * </p>
     *
     * @param updateLicenseManagerReportGeneratorRequest
     * @return Result of the UpdateLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseManagerReportGeneratorResponse updateLicenseManagerReportGenerator(
            UpdateLicenseManagerReportGeneratorRequest updateLicenseManagerReportGeneratorRequest) throws ValidationException,
            InvalidParameterValueException, RateLimitExceededException, ServerInternalException, AuthorizationException,
            AccessDeniedException, ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException,
            SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a report generator.
     * </p>
     * <p>
     * After you make changes to a report generator, it starts generating new reports within 60 minutes of being
     * updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLicenseManagerReportGeneratorRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLicenseManagerReportGeneratorRequest#builder()}
     * </p>
     *
     * @param updateLicenseManagerReportGeneratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseManagerReportGeneratorRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLicenseManagerReportGenerator operation returned by the service.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseManagerReportGenerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseManagerReportGenerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseManagerReportGeneratorResponse updateLicenseManagerReportGenerator(
            Consumer<UpdateLicenseManagerReportGeneratorRequest.Builder> updateLicenseManagerReportGeneratorRequest)
            throws ValidationException, InvalidParameterValueException, RateLimitExceededException, ServerInternalException,
            AuthorizationException, AccessDeniedException, ResourceNotFoundException, ResourceLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest.builder()
                .applyMutation(updateLicenseManagerReportGeneratorRequest).build());
    }

    /**
     * <p>
     * Adds or removes the specified license configurations for the specified Amazon Web Services resource.
     * </p>
     * <p>
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license
     * specifications for launch templates and CloudFormation templates, as they send license configurations to the
     * operation that creates the resource.
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     * @return Result of the UpdateLicenseSpecificationsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         License Manager cannot allocate a license to a resource because of its state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.
     * @throws LicenseUsageException
     *         You do not have enough licenses available to support a new resource launch.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseSpecificationsForResourceResponse updateLicenseSpecificationsForResource(
            UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest)
            throws InvalidParameterValueException, InvalidResourceStateException, LicenseUsageException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or removes the specified license configurations for the specified Amazon Web Services resource.
     * </p>
     * <p>
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license
     * specifications for launch templates and CloudFormation templates, as they send license configurations to the
     * operation that creates the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateLicenseSpecificationsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         License Manager cannot allocate a license to a resource because of its state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.
     * @throws LicenseUsageException
     *         You do not have enough licenses available to support a new resource launch.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLicenseSpecificationsForResourceResponse updateLicenseSpecificationsForResource(
            Consumer<UpdateLicenseSpecificationsForResourceRequest.Builder> updateLicenseSpecificationsForResourceRequest)
            throws InvalidParameterValueException, InvalidResourceStateException, LicenseUsageException, ServerInternalException,
            AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException,
            LicenseManagerException {
        return updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(updateLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Updates License Manager settings for the current Region.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest)
            throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException,
            RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates License Manager settings for the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServiceSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameter values are not valid.
     * @throws ServerInternalException
     *         The server experienced an internal error. Try again.
     * @throws AuthorizationException
     *         The Amazon Web Services user account does not have permission to perform the action. Check the IAM policy
     *         associated with this account.
     * @throws AccessDeniedException
     *         Access to resource denied.
     * @throws RateLimitExceededException
     *         Too many requests have been submitted. Try again after a brief wait.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerClient.UpdateServiceSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) throws InvalidParameterValueException,
            ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException,
            AwsServiceException, SdkClientException, LicenseManagerException {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
