/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a grant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Grant implements SdkPojo, Serializable, ToCopyableBuilder<Grant.Builder, Grant> {
    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantArn").getter(getter(Grant::grantArn)).setter(setter(Builder::grantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()).build();

    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantName").getter(getter(Grant::grantName)).setter(setter(Builder::grantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()).build();

    private static final SdkField<String> PARENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentArn").getter(getter(Grant::parentArn)).setter(setter(Builder::parentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentArn").build()).build();

    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(Grant::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<String> GRANTEE_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GranteePrincipalArn").getter(getter(Grant::granteePrincipalArn))
            .setter(setter(Builder::granteePrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteePrincipalArn").build())
            .build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(Grant::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<String> GRANT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantStatus").getter(getter(Grant::grantStatusAsString)).setter(setter(Builder::grantStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantStatus").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(Grant::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(Grant::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> GRANTED_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GrantedOperations")
            .getter(getter(Grant::grantedOperationsAsStrings))
            .setter(setter(Builder::grantedOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantedOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_ARN_FIELD,
            GRANT_NAME_FIELD, PARENT_ARN_FIELD, LICENSE_ARN_FIELD, GRANTEE_PRINCIPAL_ARN_FIELD, HOME_REGION_FIELD,
            GRANT_STATUS_FIELD, STATUS_REASON_FIELD, VERSION_FIELD, GRANTED_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String grantArn;

    private final String grantName;

    private final String parentArn;

    private final String licenseArn;

    private final String granteePrincipalArn;

    private final String homeRegion;

    private final String grantStatus;

    private final String statusReason;

    private final String version;

    private final List<String> grantedOperations;

    private Grant(BuilderImpl builder) {
        this.grantArn = builder.grantArn;
        this.grantName = builder.grantName;
        this.parentArn = builder.parentArn;
        this.licenseArn = builder.licenseArn;
        this.granteePrincipalArn = builder.granteePrincipalArn;
        this.homeRegion = builder.homeRegion;
        this.grantStatus = builder.grantStatus;
        this.statusReason = builder.statusReason;
        this.version = builder.version;
        this.grantedOperations = builder.grantedOperations;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the grant.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the grant.
     */
    public final String grantArn() {
        return grantArn;
    }

    /**
     * <p>
     * Grant name.
     * </p>
     * 
     * @return Grant name.
     */
    public final String grantName() {
        return grantName;
    }

    /**
     * <p>
     * Parent ARN.
     * </p>
     * 
     * @return Parent ARN.
     */
    public final String parentArn() {
        return parentArn;
    }

    /**
     * <p>
     * License ARN.
     * </p>
     * 
     * @return License ARN.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * <p>
     * The grantee principal ARN.
     * </p>
     * 
     * @return The grantee principal ARN.
     */
    public final String granteePrincipalArn() {
        return granteePrincipalArn;
    }

    /**
     * <p>
     * Home Region of the grant.
     * </p>
     * 
     * @return Home Region of the grant.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantStatus} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantStatusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final GrantStatus grantStatus() {
        return GrantStatus.fromValue(grantStatus);
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantStatus} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantStatusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final String grantStatusAsString() {
        return grantStatus;
    }

    /**
     * <p>
     * Grant status reason.
     * </p>
     * 
     * @return Grant status reason.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Grant version.
     * </p>
     * 
     * @return Grant version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * Granted operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantedOperations} method.
     * </p>
     * 
     * @return Granted operations.
     */
    public final List<AllowedOperation> grantedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(grantedOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantedOperations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrantedOperations() {
        return grantedOperations != null && !(grantedOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Granted operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantedOperations} method.
     * </p>
     * 
     * @return Granted operations.
     */
    public final List<String> grantedOperationsAsStrings() {
        return grantedOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(grantName());
        hashCode = 31 * hashCode + Objects.hashCode(parentArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(granteePrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(grantStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantedOperations() ? grantedOperationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant) obj;
        return Objects.equals(grantArn(), other.grantArn()) && Objects.equals(grantName(), other.grantName())
                && Objects.equals(parentArn(), other.parentArn()) && Objects.equals(licenseArn(), other.licenseArn())
                && Objects.equals(granteePrincipalArn(), other.granteePrincipalArn())
                && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(grantStatusAsString(), other.grantStatusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(version(), other.version())
                && hasGrantedOperations() == other.hasGrantedOperations()
                && Objects.equals(grantedOperationsAsStrings(), other.grantedOperationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Grant").add("GrantArn", grantArn()).add("GrantName", grantName()).add("ParentArn", parentArn())
                .add("LicenseArn", licenseArn()).add("GranteePrincipalArn", granteePrincipalArn())
                .add("HomeRegion", homeRegion()).add("GrantStatus", grantStatusAsString()).add("StatusReason", statusReason())
                .add("Version", version()).add("GrantedOperations", hasGrantedOperations() ? grantedOperationsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrantArn":
            return Optional.ofNullable(clazz.cast(grantArn()));
        case "GrantName":
            return Optional.ofNullable(clazz.cast(grantName()));
        case "ParentArn":
            return Optional.ofNullable(clazz.cast(parentArn()));
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "GranteePrincipalArn":
            return Optional.ofNullable(clazz.cast(granteePrincipalArn()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "GrantStatus":
            return Optional.ofNullable(clazz.cast(grantStatusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "GrantedOperations":
            return Optional.ofNullable(clazz.cast(grantedOperationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Grant, T> g) {
        return obj -> g.apply((Grant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Grant> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the grant.
         * </p>
         * 
         * @param grantArn
         *        Amazon Resource Name (ARN) of the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantArn(String grantArn);

        /**
         * <p>
         * Grant name.
         * </p>
         * 
         * @param grantName
         *        Grant name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantName(String grantName);

        /**
         * <p>
         * Parent ARN.
         * </p>
         * 
         * @param parentArn
         *        Parent ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentArn(String parentArn);

        /**
         * <p>
         * License ARN.
         * </p>
         * 
         * @param licenseArn
         *        License ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * The grantee principal ARN.
         * </p>
         * 
         * @param granteePrincipalArn
         *        The grantee principal ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteePrincipalArn(String granteePrincipalArn);

        /**
         * <p>
         * Home Region of the grant.
         * </p>
         * 
         * @param homeRegion
         *        Home Region of the grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param grantStatus
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder grantStatus(String grantStatus);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param grantStatus
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder grantStatus(GrantStatus grantStatus);

        /**
         * <p>
         * Grant status reason.
         * </p>
         * 
         * @param statusReason
         *        Grant status reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Grant version.
         * </p>
         * 
         * @param version
         *        Grant version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Granted operations.
         * </p>
         * 
         * @param grantedOperations
         *        Granted operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedOperationsWithStrings(Collection<String> grantedOperations);

        /**
         * <p>
         * Granted operations.
         * </p>
         * 
         * @param grantedOperations
         *        Granted operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedOperationsWithStrings(String... grantedOperations);

        /**
         * <p>
         * Granted operations.
         * </p>
         * 
         * @param grantedOperations
         *        Granted operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedOperations(Collection<AllowedOperation> grantedOperations);

        /**
         * <p>
         * Granted operations.
         * </p>
         * 
         * @param grantedOperations
         *        Granted operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedOperations(AllowedOperation... grantedOperations);
    }

    static final class BuilderImpl implements Builder {
        private String grantArn;

        private String grantName;

        private String parentArn;

        private String licenseArn;

        private String granteePrincipalArn;

        private String homeRegion;

        private String grantStatus;

        private String statusReason;

        private String version;

        private List<String> grantedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            grantArn(model.grantArn);
            grantName(model.grantName);
            parentArn(model.parentArn);
            licenseArn(model.licenseArn);
            granteePrincipalArn(model.granteePrincipalArn);
            homeRegion(model.homeRegion);
            grantStatus(model.grantStatus);
            statusReason(model.statusReason);
            version(model.version);
            grantedOperationsWithStrings(model.grantedOperations);
        }

        public final String getGrantArn() {
            return grantArn;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final String getGrantName() {
            return grantName;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        @Override
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final String getParentArn() {
            return parentArn;
        }

        public final void setParentArn(String parentArn) {
            this.parentArn = parentArn;
        }

        @Override
        public final Builder parentArn(String parentArn) {
            this.parentArn = parentArn;
            return this;
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getGranteePrincipalArn() {
            return granteePrincipalArn;
        }

        public final void setGranteePrincipalArn(String granteePrincipalArn) {
            this.granteePrincipalArn = granteePrincipalArn;
        }

        @Override
        public final Builder granteePrincipalArn(String granteePrincipalArn) {
            this.granteePrincipalArn = granteePrincipalArn;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getGrantStatus() {
            return grantStatus;
        }

        public final void setGrantStatus(String grantStatus) {
            this.grantStatus = grantStatus;
        }

        @Override
        public final Builder grantStatus(String grantStatus) {
            this.grantStatus = grantStatus;
            return this;
        }

        @Override
        public final Builder grantStatus(GrantStatus grantStatus) {
            this.grantStatus(grantStatus == null ? null : grantStatus.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getGrantedOperations() {
            if (grantedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return grantedOperations;
        }

        public final void setGrantedOperations(Collection<String> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copy(grantedOperations);
        }

        @Override
        public final Builder grantedOperationsWithStrings(Collection<String> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copy(grantedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantedOperationsWithStrings(String... grantedOperations) {
            grantedOperationsWithStrings(Arrays.asList(grantedOperations));
            return this;
        }

        @Override
        public final Builder grantedOperations(Collection<AllowedOperation> grantedOperations) {
            this.grantedOperations = AllowedOperationListCopier.copyEnumToString(grantedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantedOperations(AllowedOperation... grantedOperations) {
            grantedOperations(Arrays.asList(grantedOperations));
            return this;
        }

        @Override
        public Grant build() {
            return new Grant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
