/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperation;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperationListCopier;
import software.amazon.awssdk.services.licensemanager.model.GrantStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.Options;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantVersionRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateGrantVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::clientToken)).setter(CreateGrantVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantArn").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::grantArn)).setter(CreateGrantVersionRequest.setter(Builder::grantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()}).build();
    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantName").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::grantName)).setter(CreateGrantVersionRequest.setter(Builder::grantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()}).build();
    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOperations").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::allowedOperationsAsStrings)).setter(CreateGrantVersionRequest.setter(Builder::allowedOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::statusAsString)).setter(CreateGrantVersionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::statusReason)).setter(CreateGrantVersionRequest.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVersion").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::sourceVersion)).setter(CreateGrantVersionRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVersion").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(CreateGrantVersionRequest.getter(CreateGrantVersionRequest::options)).setter(CreateGrantVersionRequest.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, GRANT_ARN_FIELD, GRANT_NAME_FIELD, ALLOWED_OPERATIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SOURCE_VERSION_FIELD, OPTIONS_FIELD));
    private final String clientToken;
    private final String grantArn;
    private final String grantName;
    private final List<String> allowedOperations;
    private final String status;
    private final String statusReason;
    private final String sourceVersion;
    private final Options options;

    private CreateGrantVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.grantArn = builder.grantArn;
        this.grantName = builder.grantName;
        this.allowedOperations = builder.allowedOperations;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.sourceVersion = builder.sourceVersion;
        this.options = builder.options;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String grantArn() {
        return this.grantArn;
    }

    public final String grantName() {
        return this.grantName;
    }

    public final List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(this.allowedOperations);
    }

    public final boolean hasAllowedOperations() {
        return this.allowedOperations != null && !(this.allowedOperations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOperationsAsStrings() {
        return this.allowedOperations;
    }

    public final GrantStatus status() {
        return GrantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final Options options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantVersionRequest)) {
            return false;
        }
        CreateGrantVersionRequest other = (CreateGrantVersionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.grantArn(), other.grantArn()) && Objects.equals(this.grantName(), other.grantName()) && this.hasAllowedOperations() == other.hasAllowedOperations() && Objects.equals(this.allowedOperationsAsStrings(), other.allowedOperationsAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGrantVersionRequest").add("ClientToken", (Object)this.clientToken()).add("GrantArn", (Object)this.grantArn()).add("GrantName", (Object)this.grantName()).add("AllowedOperations", this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("SourceVersion", (Object)this.sourceVersion()).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GrantArn": {
                return Optional.ofNullable(clazz.cast(this.grantArn()));
            }
            case "GrantName": {
                return Optional.ofNullable(clazz.cast(this.grantName()));
            }
            case "AllowedOperations": {
                return Optional.ofNullable(clazz.cast(this.allowedOperationsAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantVersionRequest, T> g) {
        return obj -> g.apply((CreateGrantVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String grantArn;
        private String grantName;
        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;
        private String sourceVersion;
        private Options options;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantVersionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.grantArn(model.grantArn);
            this.grantName(model.grantName);
            this.allowedOperationsWithStrings(model.allowedOperations);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.sourceVersion(model.sourceVersion);
            this.options(model.options);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGrantArn() {
            return this.grantArn;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final String getGrantName() {
            return this.grantName;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        @Override
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final Collection<String> getAllowedOperations() {
            if (this.allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOperations;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        @Override
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String ... allowedOperations) {
            this.allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation ... allowedOperations) {
            this.allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantVersionRequest build() {
            return new CreateGrantVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantVersionRequest> {
        public Builder clientToken(String var1);

        public Builder grantArn(String var1);

        public Builder grantName(String var1);

        public Builder allowedOperationsWithStrings(Collection<String> var1);

        public Builder allowedOperationsWithStrings(String ... var1);

        public Builder allowedOperations(Collection<AllowedOperation> var1);

        public Builder allowedOperations(AllowedOperation ... var1);

        public Builder status(String var1);

        public Builder status(GrantStatus var1);

        public Builder statusReason(String var1);

        public Builder sourceVersion(String var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

