/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod;
import software.amazon.awssdk.services.licensemanager.model.EntitlementData;
import software.amazon.awssdk.services.licensemanager.model.EntitlementDataListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckoutBorrowLicenseRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CheckoutBorrowLicenseRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::licenseArn)).setter(CheckoutBorrowLicenseRequest.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::entitlements)).setter(CheckoutBorrowLicenseRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIGITAL_SIGNATURE_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DigitalSignatureMethod").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::digitalSignatureMethodAsString)).setter(CheckoutBorrowLicenseRequest.setter(Builder::digitalSignatureMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignatureMethod").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::nodeId)).setter(CheckoutBorrowLicenseRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<List<Metadata>> CHECKOUT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckoutMetadata").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::checkoutMetadata)).setter(CheckoutBorrowLicenseRequest.setter(Builder::checkoutMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CheckoutBorrowLicenseRequest.getter(CheckoutBorrowLicenseRequest::clientToken)).setter(CheckoutBorrowLicenseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, ENTITLEMENTS_FIELD, DIGITAL_SIGNATURE_METHOD_FIELD, NODE_ID_FIELD, CHECKOUT_METADATA_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LicenseArn", LICENSE_ARN_FIELD);
            this.put("Entitlements", ENTITLEMENTS_FIELD);
            this.put("DigitalSignatureMethod", DIGITAL_SIGNATURE_METHOD_FIELD);
            this.put("NodeId", NODE_ID_FIELD);
            this.put("CheckoutMetadata", CHECKOUT_METADATA_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String licenseArn;
    private final List<EntitlementData> entitlements;
    private final String digitalSignatureMethod;
    private final String nodeId;
    private final List<Metadata> checkoutMetadata;
    private final String clientToken;

    private CheckoutBorrowLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.entitlements = builder.entitlements;
        this.digitalSignatureMethod = builder.digitalSignatureMethod;
        this.nodeId = builder.nodeId;
        this.checkoutMetadata = builder.checkoutMetadata;
        this.clientToken = builder.clientToken;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<EntitlementData> entitlements() {
        return this.entitlements;
    }

    public final DigitalSignatureMethod digitalSignatureMethod() {
        return DigitalSignatureMethod.fromValue(this.digitalSignatureMethod);
    }

    public final String digitalSignatureMethodAsString() {
        return this.digitalSignatureMethod;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final boolean hasCheckoutMetadata() {
        return this.checkoutMetadata != null && !(this.checkoutMetadata instanceof SdkAutoConstructList);
    }

    public final List<Metadata> checkoutMetadata() {
        return this.checkoutMetadata;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.digitalSignatureMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckoutMetadata() ? this.checkoutMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutBorrowLicenseRequest)) {
            return false;
        }
        CheckoutBorrowLicenseRequest other = (CheckoutBorrowLicenseRequest)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.digitalSignatureMethodAsString(), other.digitalSignatureMethodAsString()) && Objects.equals(this.nodeId(), other.nodeId()) && this.hasCheckoutMetadata() == other.hasCheckoutMetadata() && Objects.equals(this.checkoutMetadata(), other.checkoutMetadata()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CheckoutBorrowLicenseRequest").add("LicenseArn", (Object)this.licenseArn()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("DigitalSignatureMethod", (Object)this.digitalSignatureMethodAsString()).add("NodeId", (Object)this.nodeId()).add("CheckoutMetadata", this.hasCheckoutMetadata() ? this.checkoutMetadata() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "DigitalSignatureMethod": {
                return Optional.ofNullable(clazz.cast(this.digitalSignatureMethodAsString()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "CheckoutMetadata": {
                return Optional.ofNullable(clazz.cast(this.checkoutMetadata()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CheckoutBorrowLicenseRequest, T> g) {
        return obj -> g.apply((CheckoutBorrowLicenseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseArn;
        private List<EntitlementData> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String digitalSignatureMethod;
        private String nodeId;
        private List<Metadata> checkoutMetadata = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutBorrowLicenseRequest model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.entitlements(model.entitlements);
            this.digitalSignatureMethod(model.digitalSignatureMethod);
            this.nodeId(model.nodeId);
            this.checkoutMetadata(model.checkoutMetadata);
            this.clientToken(model.clientToken);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlements() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<EntitlementData.BuilderImpl> entitlements) {
            this.entitlements = EntitlementDataListCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<EntitlementData> entitlements) {
            this.entitlements = EntitlementDataListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(EntitlementData ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<EntitlementData.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (EntitlementData)((EntitlementData.Builder)EntitlementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDigitalSignatureMethod() {
            return this.digitalSignatureMethod;
        }

        public final void setDigitalSignatureMethod(String digitalSignatureMethod) {
            this.digitalSignatureMethod = digitalSignatureMethod;
        }

        @Override
        public final Builder digitalSignatureMethod(String digitalSignatureMethod) {
            this.digitalSignatureMethod = digitalSignatureMethod;
            return this;
        }

        @Override
        public final Builder digitalSignatureMethod(DigitalSignatureMethod digitalSignatureMethod) {
            this.digitalSignatureMethod(digitalSignatureMethod == null ? null : digitalSignatureMethod.toString());
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final List<Metadata.Builder> getCheckoutMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.checkoutMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckoutMetadata(Collection<Metadata.BuilderImpl> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copyFromBuilder(checkoutMetadata);
        }

        @Override
        public final Builder checkoutMetadata(Collection<Metadata> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copy(checkoutMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Metadata ... checkoutMetadata) {
            this.checkoutMetadata(Arrays.asList(checkoutMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Consumer<Metadata.Builder> ... checkoutMetadata) {
            this.checkoutMetadata(Stream.of(checkoutMetadata).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckoutBorrowLicenseRequest build() {
            return new CheckoutBorrowLicenseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckoutBorrowLicenseRequest> {
        public Builder licenseArn(String var1);

        public Builder entitlements(Collection<EntitlementData> var1);

        public Builder entitlements(EntitlementData ... var1);

        public Builder entitlements(Consumer<EntitlementData.Builder> ... var1);

        public Builder digitalSignatureMethod(String var1);

        public Builder digitalSignatureMethod(DigitalSignatureMethod var1);

        public Builder nodeId(String var1);

        public Builder checkoutMetadata(Collection<Metadata> var1);

        public Builder checkoutMetadata(Metadata ... var1);

        public Builder checkoutMetadata(Consumer<Metadata.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

