/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseConversionTask;
import software.amazon.awssdk.services.licensemanager.model.LicenseConversionTasksCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseConversionTasksResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseConversionTasksResponse> {
    private static final SdkField<List<LicenseConversionTask>> LICENSE_CONVERSION_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseConversionTasks").getter(ListLicenseConversionTasksResponse.getter(ListLicenseConversionTasksResponse::licenseConversionTasks)).setter(ListLicenseConversionTasksResponse.setter(Builder::licenseConversionTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConversionTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConversionTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseConversionTasksResponse.getter(ListLicenseConversionTasksResponse::nextToken)).setter(ListLicenseConversionTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONVERSION_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LicenseConversionTasks", LICENSE_CONVERSION_TASKS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LicenseConversionTask> licenseConversionTasks;
    private final String nextToken;

    private ListLicenseConversionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConversionTasks = builder.licenseConversionTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseConversionTasks() {
        return this.licenseConversionTasks != null && !(this.licenseConversionTasks instanceof SdkAutoConstructList);
    }

    public final List<LicenseConversionTask> licenseConversionTasks() {
        return this.licenseConversionTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConversionTasks() ? this.licenseConversionTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseConversionTasksResponse)) {
            return false;
        }
        ListLicenseConversionTasksResponse other = (ListLicenseConversionTasksResponse)((Object)obj);
        return this.hasLicenseConversionTasks() == other.hasLicenseConversionTasks() && Objects.equals(this.licenseConversionTasks(), other.licenseConversionTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLicenseConversionTasksResponse").add("LicenseConversionTasks", this.hasLicenseConversionTasks() ? this.licenseConversionTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConversionTasks": {
                return Optional.ofNullable(clazz.cast(this.licenseConversionTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseConversionTasksResponse, T> g) {
        return obj -> g.apply((ListLicenseConversionTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseConversionTask> licenseConversionTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseConversionTasksResponse model) {
            super(model);
            this.licenseConversionTasks(model.licenseConversionTasks);
            this.nextToken(model.nextToken);
        }

        public final List<LicenseConversionTask.Builder> getLicenseConversionTasks() {
            List<LicenseConversionTask.Builder> result = LicenseConversionTasksCopier.copyToBuilder(this.licenseConversionTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseConversionTasks(Collection<LicenseConversionTask.BuilderImpl> licenseConversionTasks) {
            this.licenseConversionTasks = LicenseConversionTasksCopier.copyFromBuilder(licenseConversionTasks);
        }

        @Override
        public final Builder licenseConversionTasks(Collection<LicenseConversionTask> licenseConversionTasks) {
            this.licenseConversionTasks = LicenseConversionTasksCopier.copy(licenseConversionTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConversionTasks(LicenseConversionTask ... licenseConversionTasks) {
            this.licenseConversionTasks(Arrays.asList(licenseConversionTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConversionTasks(Consumer<LicenseConversionTask.Builder> ... licenseConversionTasks) {
            this.licenseConversionTasks(Stream.of(licenseConversionTasks).map(c -> (LicenseConversionTask)((LicenseConversionTask.Builder)LicenseConversionTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseConversionTasksResponse build() {
            return new ListLicenseConversionTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseConversionTasksResponse> {
        public Builder licenseConversionTasks(Collection<LicenseConversionTask> var1);

        public Builder licenseConversionTasks(LicenseConversionTask ... var1);

        public Builder licenseConversionTasks(Consumer<LicenseConversionTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

