/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a borrow configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BorrowConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BorrowConfiguration.Builder, BorrowConfiguration> {
    private static final SdkField<Boolean> ALLOW_EARLY_CHECK_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowEarlyCheckIn").getter(getter(BorrowConfiguration::allowEarlyCheckIn))
            .setter(setter(Builder::allowEarlyCheckIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEarlyCheckIn").build()).build();

    private static final SdkField<Integer> MAX_TIME_TO_LIVE_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxTimeToLiveInMinutes")
            .getter(getter(BorrowConfiguration::maxTimeToLiveInMinutes)).setter(setter(Builder::maxTimeToLiveInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTimeToLiveInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_EARLY_CHECK_IN_FIELD,
            MAX_TIME_TO_LIVE_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allowEarlyCheckIn;

    private final Integer maxTimeToLiveInMinutes;

    private BorrowConfiguration(BuilderImpl builder) {
        this.allowEarlyCheckIn = builder.allowEarlyCheckIn;
        this.maxTimeToLiveInMinutes = builder.maxTimeToLiveInMinutes;
    }

    /**
     * <p>
     * Indicates whether early check-ins are allowed.
     * </p>
     * 
     * @return Indicates whether early check-ins are allowed.
     */
    public final Boolean allowEarlyCheckIn() {
        return allowEarlyCheckIn;
    }

    /**
     * <p>
     * Maximum time for the borrow configuration, in minutes.
     * </p>
     * 
     * @return Maximum time for the borrow configuration, in minutes.
     */
    public final Integer maxTimeToLiveInMinutes() {
        return maxTimeToLiveInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowEarlyCheckIn());
        hashCode = 31 * hashCode + Objects.hashCode(maxTimeToLiveInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BorrowConfiguration)) {
            return false;
        }
        BorrowConfiguration other = (BorrowConfiguration) obj;
        return Objects.equals(allowEarlyCheckIn(), other.allowEarlyCheckIn())
                && Objects.equals(maxTimeToLiveInMinutes(), other.maxTimeToLiveInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BorrowConfiguration").add("AllowEarlyCheckIn", allowEarlyCheckIn())
                .add("MaxTimeToLiveInMinutes", maxTimeToLiveInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowEarlyCheckIn":
            return Optional.ofNullable(clazz.cast(allowEarlyCheckIn()));
        case "MaxTimeToLiveInMinutes":
            return Optional.ofNullable(clazz.cast(maxTimeToLiveInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowEarlyCheckIn", ALLOW_EARLY_CHECK_IN_FIELD);
        map.put("MaxTimeToLiveInMinutes", MAX_TIME_TO_LIVE_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BorrowConfiguration, T> g) {
        return obj -> g.apply((BorrowConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BorrowConfiguration> {
        /**
         * <p>
         * Indicates whether early check-ins are allowed.
         * </p>
         * 
         * @param allowEarlyCheckIn
         *        Indicates whether early check-ins are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEarlyCheckIn(Boolean allowEarlyCheckIn);

        /**
         * <p>
         * Maximum time for the borrow configuration, in minutes.
         * </p>
         * 
         * @param maxTimeToLiveInMinutes
         *        Maximum time for the borrow configuration, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTimeToLiveInMinutes(Integer maxTimeToLiveInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowEarlyCheckIn;

        private Integer maxTimeToLiveInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BorrowConfiguration model) {
            allowEarlyCheckIn(model.allowEarlyCheckIn);
            maxTimeToLiveInMinutes(model.maxTimeToLiveInMinutes);
        }

        public final Boolean getAllowEarlyCheckIn() {
            return allowEarlyCheckIn;
        }

        public final void setAllowEarlyCheckIn(Boolean allowEarlyCheckIn) {
            this.allowEarlyCheckIn = allowEarlyCheckIn;
        }

        @Override
        public final Builder allowEarlyCheckIn(Boolean allowEarlyCheckIn) {
            this.allowEarlyCheckIn = allowEarlyCheckIn;
            return this;
        }

        public final Integer getMaxTimeToLiveInMinutes() {
            return maxTimeToLiveInMinutes;
        }

        public final void setMaxTimeToLiveInMinutes(Integer maxTimeToLiveInMinutes) {
            this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
        }

        @Override
        public final Builder maxTimeToLiveInMinutes(Integer maxTimeToLiveInMinutes) {
            this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
            return this;
        }

        @Override
        public BorrowConfiguration build() {
            return new BorrowConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
