/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a consumption configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsumptionConfiguration.Builder, ConsumptionConfiguration> {
    private static final SdkField<String> RENEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenewType").getter(getter(ConsumptionConfiguration::renewTypeAsString))
            .setter(setter(Builder::renewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewType").build()).build();

    private static final SdkField<ProvisionalConfiguration> PROVISIONAL_CONFIGURATION_FIELD = SdkField
            .<ProvisionalConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProvisionalConfiguration")
            .getter(getter(ConsumptionConfiguration::provisionalConfiguration)).setter(setter(Builder::provisionalConfiguration))
            .constructor(ProvisionalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionalConfiguration").build())
            .build();

    private static final SdkField<BorrowConfiguration> BORROW_CONFIGURATION_FIELD = SdkField
            .<BorrowConfiguration> builder(MarshallingType.SDK_POJO).memberName("BorrowConfiguration")
            .getter(getter(ConsumptionConfiguration::borrowConfiguration)).setter(setter(Builder::borrowConfiguration))
            .constructor(BorrowConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEW_TYPE_FIELD,
            PROVISIONAL_CONFIGURATION_FIELD, BORROW_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String renewType;

    private final ProvisionalConfiguration provisionalConfiguration;

    private final BorrowConfiguration borrowConfiguration;

    private ConsumptionConfiguration(BuilderImpl builder) {
        this.renewType = builder.renewType;
        this.provisionalConfiguration = builder.provisionalConfiguration;
        this.borrowConfiguration = builder.borrowConfiguration;
    }

    /**
     * <p>
     * Renewal frequency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewType} will
     * return {@link RenewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewTypeAsString}.
     * </p>
     * 
     * @return Renewal frequency.
     * @see RenewType
     */
    public final RenewType renewType() {
        return RenewType.fromValue(renewType);
    }

    /**
     * <p>
     * Renewal frequency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewType} will
     * return {@link RenewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewTypeAsString}.
     * </p>
     * 
     * @return Renewal frequency.
     * @see RenewType
     */
    public final String renewTypeAsString() {
        return renewType;
    }

    /**
     * <p>
     * Details about a provisional configuration.
     * </p>
     * 
     * @return Details about a provisional configuration.
     */
    public final ProvisionalConfiguration provisionalConfiguration() {
        return provisionalConfiguration;
    }

    /**
     * <p>
     * Details about a borrow configuration.
     * </p>
     * 
     * @return Details about a borrow configuration.
     */
    public final BorrowConfiguration borrowConfiguration() {
        return borrowConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(borrowConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumptionConfiguration)) {
            return false;
        }
        ConsumptionConfiguration other = (ConsumptionConfiguration) obj;
        return Objects.equals(renewTypeAsString(), other.renewTypeAsString())
                && Objects.equals(provisionalConfiguration(), other.provisionalConfiguration())
                && Objects.equals(borrowConfiguration(), other.borrowConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumptionConfiguration").add("RenewType", renewTypeAsString())
                .add("ProvisionalConfiguration", provisionalConfiguration()).add("BorrowConfiguration", borrowConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenewType":
            return Optional.ofNullable(clazz.cast(renewTypeAsString()));
        case "ProvisionalConfiguration":
            return Optional.ofNullable(clazz.cast(provisionalConfiguration()));
        case "BorrowConfiguration":
            return Optional.ofNullable(clazz.cast(borrowConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RenewType", RENEW_TYPE_FIELD);
        map.put("ProvisionalConfiguration", PROVISIONAL_CONFIGURATION_FIELD);
        map.put("BorrowConfiguration", BORROW_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumptionConfiguration, T> g) {
        return obj -> g.apply((ConsumptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumptionConfiguration> {
        /**
         * <p>
         * Renewal frequency.
         * </p>
         * 
         * @param renewType
         *        Renewal frequency.
         * @see RenewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewType
         */
        Builder renewType(String renewType);

        /**
         * <p>
         * Renewal frequency.
         * </p>
         * 
         * @param renewType
         *        Renewal frequency.
         * @see RenewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewType
         */
        Builder renewType(RenewType renewType);

        /**
         * <p>
         * Details about a provisional configuration.
         * </p>
         * 
         * @param provisionalConfiguration
         *        Details about a provisional configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionalConfiguration(ProvisionalConfiguration provisionalConfiguration);

        /**
         * <p>
         * Details about a provisional configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionalConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProvisionalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionalConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionalConfiguration(ProvisionalConfiguration)}.
         * 
         * @param provisionalConfiguration
         *        a consumer that will call methods on {@link ProvisionalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionalConfiguration(ProvisionalConfiguration)
         */
        default Builder provisionalConfiguration(Consumer<ProvisionalConfiguration.Builder> provisionalConfiguration) {
            return provisionalConfiguration(ProvisionalConfiguration.builder().applyMutation(provisionalConfiguration).build());
        }

        /**
         * <p>
         * Details about a borrow configuration.
         * </p>
         * 
         * @param borrowConfiguration
         *        Details about a borrow configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borrowConfiguration(BorrowConfiguration borrowConfiguration);

        /**
         * <p>
         * Details about a borrow configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link BorrowConfiguration.Builder} avoiding the
         * need to create one manually via {@link BorrowConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BorrowConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #borrowConfiguration(BorrowConfiguration)}.
         * 
         * @param borrowConfiguration
         *        a consumer that will call methods on {@link BorrowConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #borrowConfiguration(BorrowConfiguration)
         */
        default Builder borrowConfiguration(Consumer<BorrowConfiguration.Builder> borrowConfiguration) {
            return borrowConfiguration(BorrowConfiguration.builder().applyMutation(borrowConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String renewType;

        private ProvisionalConfiguration provisionalConfiguration;

        private BorrowConfiguration borrowConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumptionConfiguration model) {
            renewType(model.renewType);
            provisionalConfiguration(model.provisionalConfiguration);
            borrowConfiguration(model.borrowConfiguration);
        }

        public final String getRenewType() {
            return renewType;
        }

        public final void setRenewType(String renewType) {
            this.renewType = renewType;
        }

        @Override
        public final Builder renewType(String renewType) {
            this.renewType = renewType;
            return this;
        }

        @Override
        public final Builder renewType(RenewType renewType) {
            this.renewType(renewType == null ? null : renewType.toString());
            return this;
        }

        public final ProvisionalConfiguration.Builder getProvisionalConfiguration() {
            return provisionalConfiguration != null ? provisionalConfiguration.toBuilder() : null;
        }

        public final void setProvisionalConfiguration(ProvisionalConfiguration.BuilderImpl provisionalConfiguration) {
            this.provisionalConfiguration = provisionalConfiguration != null ? provisionalConfiguration.build() : null;
        }

        @Override
        public final Builder provisionalConfiguration(ProvisionalConfiguration provisionalConfiguration) {
            this.provisionalConfiguration = provisionalConfiguration;
            return this;
        }

        public final BorrowConfiguration.Builder getBorrowConfiguration() {
            return borrowConfiguration != null ? borrowConfiguration.toBuilder() : null;
        }

        public final void setBorrowConfiguration(BorrowConfiguration.BuilderImpl borrowConfiguration) {
            this.borrowConfiguration = borrowConfiguration != null ? borrowConfiguration.build() : null;
        }

        @Override
        public final Builder borrowConfiguration(BorrowConfiguration borrowConfiguration) {
            this.borrowConfiguration = borrowConfiguration;
            return this;
        }

        @Override
        public ConsumptionConfiguration build() {
            return new ConsumptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
