/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLicenseResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<DeleteLicenseResponse.Builder, DeleteLicenseResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeleteLicenseResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DELETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionDate").getter(getter(DeleteLicenseResponse::deletionDate)).setter(setter(Builder::deletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            DELETION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String deletionDate;

    private DeleteLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.deletionDate = builder.deletionDate;
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseDeletionStatus
     */
    public final LicenseDeletionStatus status() {
        return LicenseDeletionStatus.fromValue(status);
    }

    /**
     * <p>
     * License status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return License status.
     * @see LicenseDeletionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Date when the license is deleted.
     * </p>
     * 
     * @return Date when the license is deleted.
     */
    public final String deletionDate() {
        return deletionDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLicenseResponse)) {
            return false;
        }
        DeleteLicenseResponse other = (DeleteLicenseResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(deletionDate(), other.deletionDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLicenseResponse").add("Status", statusAsString()).add("DeletionDate", deletionDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DeletionDate":
            return Optional.ofNullable(clazz.cast(deletionDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("DeletionDate", DELETION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLicenseResponse, T> g) {
        return obj -> g.apply((DeleteLicenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLicenseResponse> {
        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseDeletionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * License status.
         * </p>
         * 
         * @param status
         *        License status.
         * @see LicenseDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseDeletionStatus
         */
        Builder status(LicenseDeletionStatus status);

        /**
         * <p>
         * Date when the license is deleted.
         * </p>
         * 
         * @param deletionDate
         *        Date when the license is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionDate(String deletionDate);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String status;

        private String deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLicenseResponse model) {
            super(model);
            status(model.status);
            deletionDate(model.deletionDate);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseDeletionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeletionDate() {
            return deletionDate;
        }

        public final void setDeletionDate(String deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public final Builder deletionDate(String deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        @Override
        public DeleteLicenseResponse build() {
            return new DeleteLicenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
