/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details associated with the issuer of a license.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IssuerDetails implements SdkPojo, Serializable, ToCopyableBuilder<IssuerDetails.Builder, IssuerDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IssuerDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SIGN_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignKey").getter(getter(IssuerDetails::signKey)).setter(setter(Builder::signKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignKey").build()).build();

    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyFingerprint").getter(getter(IssuerDetails::keyFingerprint)).setter(setter(Builder::keyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIGN_KEY_FIELD,
            KEY_FINGERPRINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String signKey;

    private final String keyFingerprint;

    private IssuerDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.signKey = builder.signKey;
        this.keyFingerprint = builder.keyFingerprint;
    }

    /**
     * <p>
     * Issuer name.
     * </p>
     * 
     * @return Issuer name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify, and support
     * the RSASSA-PSS SHA-256 signing algorithm.
     * </p>
     * 
     * @return Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify, and
     *         support the RSASSA-PSS SHA-256 signing algorithm.
     */
    public final String signKey() {
        return signKey;
    }

    /**
     * <p>
     * Issuer key fingerprint.
     * </p>
     * 
     * @return Issuer key fingerprint.
     */
    public final String keyFingerprint() {
        return keyFingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(signKey());
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssuerDetails)) {
            return false;
        }
        IssuerDetails other = (IssuerDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(signKey(), other.signKey())
                && Objects.equals(keyFingerprint(), other.keyFingerprint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IssuerDetails").add("Name", name()).add("SignKey", signKey())
                .add("KeyFingerprint", keyFingerprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SignKey":
            return Optional.ofNullable(clazz.cast(signKey()));
        case "KeyFingerprint":
            return Optional.ofNullable(clazz.cast(keyFingerprint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("SignKey", SIGN_KEY_FIELD);
        map.put("KeyFingerprint", KEY_FINGERPRINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IssuerDetails, T> g) {
        return obj -> g.apply((IssuerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IssuerDetails> {
        /**
         * <p>
         * Issuer name.
         * </p>
         * 
         * @param name
         *        Issuer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify, and
         * support the RSASSA-PSS SHA-256 signing algorithm.
         * </p>
         * 
         * @param signKey
         *        Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
         *        and support the RSASSA-PSS SHA-256 signing algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signKey(String signKey);

        /**
         * <p>
         * Issuer key fingerprint.
         * </p>
         * 
         * @param keyFingerprint
         *        Issuer key fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String signKey;

        private String keyFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(IssuerDetails model) {
            name(model.name);
            signKey(model.signKey);
            keyFingerprint(model.keyFingerprint);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSignKey() {
            return signKey;
        }

        public final void setSignKey(String signKey) {
            this.signKey = signKey;
        }

        @Override
        public final Builder signKey(String signKey) {
            this.signKey = signKey;
            return this;
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        @Override
        public IssuerDetails build() {
            return new IssuerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
