/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LicenseConfigurationAssociationsCopier {
    static List<LicenseConfigurationAssociation> copy(
            Collection<? extends LicenseConfigurationAssociation> licenseConfigurationAssociationsParam) {
        List<LicenseConfigurationAssociation> list;
        if (licenseConfigurationAssociationsParam == null
                || licenseConfigurationAssociationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseConfigurationAssociation> modifiableList = new ArrayList<>(licenseConfigurationAssociationsParam.size());
            licenseConfigurationAssociationsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LicenseConfigurationAssociation> copyFromBuilder(
            Collection<? extends LicenseConfigurationAssociation.Builder> licenseConfigurationAssociationsParam) {
        List<LicenseConfigurationAssociation> list;
        if (licenseConfigurationAssociationsParam == null
                || licenseConfigurationAssociationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseConfigurationAssociation> modifiableList = new ArrayList<>(licenseConfigurationAssociationsParam.size());
            licenseConfigurationAssociationsParam.forEach(entry -> {
                LicenseConfigurationAssociation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LicenseConfigurationAssociation.Builder> copyToBuilder(
            Collection<? extends LicenseConfigurationAssociation> licenseConfigurationAssociationsParam) {
        List<LicenseConfigurationAssociation.Builder> list;
        if (licenseConfigurationAssociationsParam == null
                || licenseConfigurationAssociationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LicenseConfigurationAssociation.Builder> modifiableList = new ArrayList<>(
                    licenseConfigurationAssociationsParam.size());
            licenseConfigurationAssociationsParam.forEach(entry -> {
                LicenseConfigurationAssociation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
