/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseConversionContext;
import software.amazon.awssdk.services.licensemanager.model.LicenseConversionTaskStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLicenseConversionTaskResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, GetLicenseConversionTaskResponse> {
    private static final SdkField<String> LICENSE_CONVERSION_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConversionTaskId").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::licenseConversionTaskId)).setter(GetLicenseConversionTaskResponse.setter(Builder::licenseConversionTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConversionTaskId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::resourceArn)).setter(GetLicenseConversionTaskResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<LicenseConversionContext> SOURCE_LICENSE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceLicenseContext").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::sourceLicenseContext)).setter(GetLicenseConversionTaskResponse.setter(Builder::sourceLicenseContext)).constructor(LicenseConversionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLicenseContext").build()}).build();
    private static final SdkField<LicenseConversionContext> DESTINATION_LICENSE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationLicenseContext").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::destinationLicenseContext)).setter(GetLicenseConversionTaskResponse.setter(Builder::destinationLicenseContext)).constructor(LicenseConversionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationLicenseContext").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::statusMessage)).setter(GetLicenseConversionTaskResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::statusAsString)).setter(GetLicenseConversionTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::startTime)).setter(GetLicenseConversionTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LICENSE_CONVERSION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LicenseConversionTime").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::licenseConversionTime)).setter(GetLicenseConversionTaskResponse.setter(Builder::licenseConversionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConversionTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetLicenseConversionTaskResponse.getter(GetLicenseConversionTaskResponse::endTime)).setter(GetLicenseConversionTaskResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONVERSION_TASK_ID_FIELD, RESOURCE_ARN_FIELD, SOURCE_LICENSE_CONTEXT_FIELD, DESTINATION_LICENSE_CONTEXT_FIELD, STATUS_MESSAGE_FIELD, STATUS_FIELD, START_TIME_FIELD, LICENSE_CONVERSION_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLicenseConversionTaskResponse.memberNameToFieldInitializer();
    private final String licenseConversionTaskId;
    private final String resourceArn;
    private final LicenseConversionContext sourceLicenseContext;
    private final LicenseConversionContext destinationLicenseContext;
    private final String statusMessage;
    private final String status;
    private final Instant startTime;
    private final Instant licenseConversionTime;
    private final Instant endTime;

    private GetLicenseConversionTaskResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConversionTaskId = builder.licenseConversionTaskId;
        this.resourceArn = builder.resourceArn;
        this.sourceLicenseContext = builder.sourceLicenseContext;
        this.destinationLicenseContext = builder.destinationLicenseContext;
        this.statusMessage = builder.statusMessage;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.licenseConversionTime = builder.licenseConversionTime;
        this.endTime = builder.endTime;
    }

    public final String licenseConversionTaskId() {
        return this.licenseConversionTaskId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final LicenseConversionContext sourceLicenseContext() {
        return this.sourceLicenseContext;
    }

    public final LicenseConversionContext destinationLicenseContext() {
        return this.destinationLicenseContext;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final LicenseConversionTaskStatus status() {
        return LicenseConversionTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant licenseConversionTime() {
        return this.licenseConversionTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConversionTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationLicenseContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConversionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseConversionTaskResponse)) {
            return false;
        }
        GetLicenseConversionTaskResponse other = (GetLicenseConversionTaskResponse)((Object)obj);
        return Objects.equals(this.licenseConversionTaskId(), other.licenseConversionTaskId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.sourceLicenseContext(), other.sourceLicenseContext()) && Objects.equals(this.destinationLicenseContext(), other.destinationLicenseContext()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.licenseConversionTime(), other.licenseConversionTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetLicenseConversionTaskResponse").add("LicenseConversionTaskId", (Object)this.licenseConversionTaskId()).add("ResourceArn", (Object)this.resourceArn()).add("SourceLicenseContext", (Object)this.sourceLicenseContext()).add("DestinationLicenseContext", (Object)this.destinationLicenseContext()).add("StatusMessage", (Object)this.statusMessage()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("LicenseConversionTime", (Object)this.licenseConversionTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConversionTaskId": {
                return Optional.ofNullable(clazz.cast(this.licenseConversionTaskId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "SourceLicenseContext": {
                return Optional.ofNullable(clazz.cast(this.sourceLicenseContext()));
            }
            case "DestinationLicenseContext": {
                return Optional.ofNullable(clazz.cast(this.destinationLicenseContext()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LicenseConversionTime": {
                return Optional.ofNullable(clazz.cast(this.licenseConversionTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseConversionTaskId", LICENSE_CONVERSION_TASK_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("SourceLicenseContext", SOURCE_LICENSE_CONTEXT_FIELD);
        map.put("DestinationLicenseContext", DESTINATION_LICENSE_CONTEXT_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LicenseConversionTime", LICENSE_CONVERSION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseConversionTaskResponse, T> g) {
        return obj -> g.apply((GetLicenseConversionTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String licenseConversionTaskId;
        private String resourceArn;
        private LicenseConversionContext sourceLicenseContext;
        private LicenseConversionContext destinationLicenseContext;
        private String statusMessage;
        private String status;
        private Instant startTime;
        private Instant licenseConversionTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseConversionTaskResponse model) {
            super(model);
            this.licenseConversionTaskId(model.licenseConversionTaskId);
            this.resourceArn(model.resourceArn);
            this.sourceLicenseContext(model.sourceLicenseContext);
            this.destinationLicenseContext(model.destinationLicenseContext);
            this.statusMessage(model.statusMessage);
            this.status(model.status);
            this.startTime(model.startTime);
            this.licenseConversionTime(model.licenseConversionTime);
            this.endTime(model.endTime);
        }

        public final String getLicenseConversionTaskId() {
            return this.licenseConversionTaskId;
        }

        public final void setLicenseConversionTaskId(String licenseConversionTaskId) {
            this.licenseConversionTaskId = licenseConversionTaskId;
        }

        @Override
        public final Builder licenseConversionTaskId(String licenseConversionTaskId) {
            this.licenseConversionTaskId = licenseConversionTaskId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final LicenseConversionContext.Builder getSourceLicenseContext() {
            return this.sourceLicenseContext != null ? this.sourceLicenseContext.toBuilder() : null;
        }

        public final void setSourceLicenseContext(LicenseConversionContext.BuilderImpl sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext != null ? sourceLicenseContext.build() : null;
        }

        @Override
        public final Builder sourceLicenseContext(LicenseConversionContext sourceLicenseContext) {
            this.sourceLicenseContext = sourceLicenseContext;
            return this;
        }

        public final LicenseConversionContext.Builder getDestinationLicenseContext() {
            return this.destinationLicenseContext != null ? this.destinationLicenseContext.toBuilder() : null;
        }

        public final void setDestinationLicenseContext(LicenseConversionContext.BuilderImpl destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext != null ? destinationLicenseContext.build() : null;
        }

        @Override
        public final Builder destinationLicenseContext(LicenseConversionContext destinationLicenseContext) {
            this.destinationLicenseContext = destinationLicenseContext;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseConversionTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLicenseConversionTime() {
            return this.licenseConversionTime;
        }

        public final void setLicenseConversionTime(Instant licenseConversionTime) {
            this.licenseConversionTime = licenseConversionTime;
        }

        @Override
        public final Builder licenseConversionTime(Instant licenseConversionTime) {
            this.licenseConversionTime = licenseConversionTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public GetLicenseConversionTaskResponse build() {
            return new GetLicenseConversionTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLicenseConversionTaskResponse> {
        public Builder licenseConversionTaskId(String var1);

        public Builder resourceArn(String var1);

        public Builder sourceLicenseContext(LicenseConversionContext var1);

        default public Builder sourceLicenseContext(Consumer<LicenseConversionContext.Builder> sourceLicenseContext) {
            return this.sourceLicenseContext((LicenseConversionContext)((LicenseConversionContext.Builder)LicenseConversionContext.builder().applyMutation(sourceLicenseContext)).build());
        }

        public Builder destinationLicenseContext(LicenseConversionContext var1);

        default public Builder destinationLicenseContext(Consumer<LicenseConversionContext.Builder> destinationLicenseContext) {
            return this.destinationLicenseContext((LicenseConversionContext)((LicenseConversionContext.Builder)LicenseConversionContext.builder().applyMutation(destinationLicenseContext)).build());
        }

        public Builder statusMessage(String var1);

        public Builder status(String var1);

        public Builder status(LicenseConversionTaskStatus var1);

        public Builder startTime(Instant var1);

        public Builder licenseConversionTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

