/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckoutLicenseResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<CheckoutLicenseResponse.Builder, CheckoutLicenseResponse> {
    private static final SdkField<String> CHECKOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckoutType").getter(getter(CheckoutLicenseResponse::checkoutTypeAsString))
            .setter(setter(Builder::checkoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutType").build()).build();

    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseConsumptionToken").getter(getter(CheckoutLicenseResponse::licenseConsumptionToken))
            .setter(setter(Builder::licenseConsumptionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build())
            .build();

    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_ALLOWED_FIELD = SdkField
            .<List<EntitlementData>> builder(MarshallingType.LIST)
            .memberName("EntitlementsAllowed")
            .getter(getter(CheckoutLicenseResponse::entitlementsAllowed))
            .setter(setter(Builder::entitlementsAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementsAllowed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SIGNED_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignedToken").getter(getter(CheckoutLicenseResponse::signedToken)).setter(setter(Builder::signedToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedToken").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(CheckoutLicenseResponse::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssuedAt").getter(getter(CheckoutLicenseResponse::issuedAt)).setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()).build();

    private static final SdkField<String> EXPIRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expiration").getter(getter(CheckoutLicenseResponse::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CheckoutLicenseResponse::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKOUT_TYPE_FIELD,
            LICENSE_CONSUMPTION_TOKEN_FIELD, ENTITLEMENTS_ALLOWED_FIELD, SIGNED_TOKEN_FIELD, NODE_ID_FIELD, ISSUED_AT_FIELD,
            EXPIRATION_FIELD, LICENSE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String checkoutType;

    private final String licenseConsumptionToken;

    private final List<EntitlementData> entitlementsAllowed;

    private final String signedToken;

    private final String nodeId;

    private final String issuedAt;

    private final String expiration;

    private final String licenseArn;

    private CheckoutLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.checkoutType = builder.checkoutType;
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.entitlementsAllowed = builder.entitlementsAllowed;
        this.signedToken = builder.signedToken;
        this.nodeId = builder.nodeId;
        this.issuedAt = builder.issuedAt;
        this.expiration = builder.expiration;
        this.licenseArn = builder.licenseArn;
    }

    /**
     * <p>
     * Checkout type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkoutType} will
     * return {@link CheckoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #checkoutTypeAsString}.
     * </p>
     * 
     * @return Checkout type.
     * @see CheckoutType
     */
    public final CheckoutType checkoutType() {
        return CheckoutType.fromValue(checkoutType);
    }

    /**
     * <p>
     * Checkout type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkoutType} will
     * return {@link CheckoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #checkoutTypeAsString}.
     * </p>
     * 
     * @return Checkout type.
     * @see CheckoutType
     */
    public final String checkoutTypeAsString() {
        return checkoutType;
    }

    /**
     * <p>
     * License consumption token.
     * </p>
     * 
     * @return License consumption token.
     */
    public final String licenseConsumptionToken() {
        return licenseConsumptionToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntitlementsAllowed property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlementsAllowed() {
        return entitlementsAllowed != null && !(entitlementsAllowed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allowed license entitlements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlementsAllowed} method.
     * </p>
     * 
     * @return Allowed license entitlements.
     */
    public final List<EntitlementData> entitlementsAllowed() {
        return entitlementsAllowed;
    }

    /**
     * <p>
     * Signed token.
     * </p>
     * 
     * @return Signed token.
     */
    public final String signedToken() {
        return signedToken;
    }

    /**
     * <p>
     * Node ID.
     * </p>
     * 
     * @return Node ID.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * Date and time at which the license checkout is issued.
     * </p>
     * 
     * @return Date and time at which the license checkout is issued.
     */
    public final String issuedAt() {
        return issuedAt;
    }

    /**
     * <p>
     * Date and time at which the license checkout expires.
     * </p>
     * 
     * @return Date and time at which the license checkout expires.
     */
    public final String expiration() {
        return expiration;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the checkout license.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the checkout license.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checkoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlementsAllowed() ? entitlementsAllowed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(signedToken());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutLicenseResponse)) {
            return false;
        }
        CheckoutLicenseResponse other = (CheckoutLicenseResponse) obj;
        return Objects.equals(checkoutTypeAsString(), other.checkoutTypeAsString())
                && Objects.equals(licenseConsumptionToken(), other.licenseConsumptionToken())
                && hasEntitlementsAllowed() == other.hasEntitlementsAllowed()
                && Objects.equals(entitlementsAllowed(), other.entitlementsAllowed())
                && Objects.equals(signedToken(), other.signedToken()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(issuedAt(), other.issuedAt()) && Objects.equals(expiration(), other.expiration())
                && Objects.equals(licenseArn(), other.licenseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckoutLicenseResponse").add("CheckoutType", checkoutTypeAsString())
                .add("LicenseConsumptionToken", licenseConsumptionToken())
                .add("EntitlementsAllowed", hasEntitlementsAllowed() ? entitlementsAllowed() : null)
                .add("SignedToken", signedToken()).add("NodeId", nodeId()).add("IssuedAt", issuedAt())
                .add("Expiration", expiration()).add("LicenseArn", licenseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckoutType":
            return Optional.ofNullable(clazz.cast(checkoutTypeAsString()));
        case "LicenseConsumptionToken":
            return Optional.ofNullable(clazz.cast(licenseConsumptionToken()));
        case "EntitlementsAllowed":
            return Optional.ofNullable(clazz.cast(entitlementsAllowed()));
        case "SignedToken":
            return Optional.ofNullable(clazz.cast(signedToken()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "IssuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CheckoutType", CHECKOUT_TYPE_FIELD);
        map.put("LicenseConsumptionToken", LICENSE_CONSUMPTION_TOKEN_FIELD);
        map.put("EntitlementsAllowed", ENTITLEMENTS_ALLOWED_FIELD);
        map.put("SignedToken", SIGNED_TOKEN_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckoutLicenseResponse, T> g) {
        return obj -> g.apply((CheckoutLicenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CheckoutLicenseResponse> {
        /**
         * <p>
         * Checkout type.
         * </p>
         * 
         * @param checkoutType
         *        Checkout type.
         * @see CheckoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckoutType
         */
        Builder checkoutType(String checkoutType);

        /**
         * <p>
         * Checkout type.
         * </p>
         * 
         * @param checkoutType
         *        Checkout type.
         * @see CheckoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckoutType
         */
        Builder checkoutType(CheckoutType checkoutType);

        /**
         * <p>
         * License consumption token.
         * </p>
         * 
         * @param licenseConsumptionToken
         *        License consumption token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConsumptionToken(String licenseConsumptionToken);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * 
         * @param entitlementsAllowed
         *        Allowed license entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * 
         * @param entitlementsAllowed
         *        Allowed license entitlements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementsAllowed(EntitlementData... entitlementsAllowed);

        /**
         * <p>
         * Allowed license entitlements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanager.model.EntitlementData.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.licensemanager.model.EntitlementData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanager.model.EntitlementData.Builder#build()} is called
         * immediately and its result is passed to {@link #entitlementsAllowed(List<EntitlementData>)}.
         * 
         * @param entitlementsAllowed
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanager.model.EntitlementData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlementsAllowed(java.util.Collection<EntitlementData>)
         */
        Builder entitlementsAllowed(Consumer<EntitlementData.Builder>... entitlementsAllowed);

        /**
         * <p>
         * Signed token.
         * </p>
         * 
         * @param signedToken
         *        Signed token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedToken(String signedToken);

        /**
         * <p>
         * Node ID.
         * </p>
         * 
         * @param nodeId
         *        Node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * Date and time at which the license checkout is issued.
         * </p>
         * 
         * @param issuedAt
         *        Date and time at which the license checkout is issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(String issuedAt);

        /**
         * <p>
         * Date and time at which the license checkout expires.
         * </p>
         * 
         * @param expiration
         *        Date and time at which the license checkout expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(String expiration);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the checkout license.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the checkout license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String checkoutType;

        private String licenseConsumptionToken;

        private List<EntitlementData> entitlementsAllowed = DefaultSdkAutoConstructList.getInstance();

        private String signedToken;

        private String nodeId;

        private String issuedAt;

        private String expiration;

        private String licenseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutLicenseResponse model) {
            super(model);
            checkoutType(model.checkoutType);
            licenseConsumptionToken(model.licenseConsumptionToken);
            entitlementsAllowed(model.entitlementsAllowed);
            signedToken(model.signedToken);
            nodeId(model.nodeId);
            issuedAt(model.issuedAt);
            expiration(model.expiration);
            licenseArn(model.licenseArn);
        }

        public final String getCheckoutType() {
            return checkoutType;
        }

        public final void setCheckoutType(String checkoutType) {
            this.checkoutType = checkoutType;
        }

        @Override
        public final Builder checkoutType(String checkoutType) {
            this.checkoutType = checkoutType;
            return this;
        }

        @Override
        public final Builder checkoutType(CheckoutType checkoutType) {
            this.checkoutType(checkoutType == null ? null : checkoutType.toString());
            return this;
        }

        public final String getLicenseConsumptionToken() {
            return licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlementsAllowed() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlementsAllowed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlementsAllowed(Collection<EntitlementData.BuilderImpl> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copyFromBuilder(entitlementsAllowed);
        }

        @Override
        public final Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copy(entitlementsAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(EntitlementData... entitlementsAllowed) {
            entitlementsAllowed(Arrays.asList(entitlementsAllowed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(Consumer<EntitlementData.Builder>... entitlementsAllowed) {
            entitlementsAllowed(Stream.of(entitlementsAllowed).map(c -> EntitlementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSignedToken() {
            return signedToken;
        }

        public final void setSignedToken(String signedToken) {
            this.signedToken = signedToken;
        }

        @Override
        public final Builder signedToken(String signedToken) {
            this.signedToken = signedToken;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getIssuedAt() {
            return issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getExpiration() {
            return expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        @Override
        public CheckoutLicenseResponse build() {
            return new CheckoutLicenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
