/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGrantResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<CreateGrantResponse.Builder, CreateGrantResponse> {
    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantArn").getter(getter(CreateGrantResponse::grantArn)).setter(setter(Builder::grantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateGrantResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(CreateGrantResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_ARN_FIELD, STATUS_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String grantArn;

    private final String status;

    private final String version;

    private CreateGrantResponse(BuilderImpl builder) {
        super(builder);
        this.grantArn = builder.grantArn;
        this.status = builder.status;
        this.version = builder.version;
    }

    /**
     * <p>
     * Grant ARN.
     * </p>
     * 
     * @return Grant ARN.
     */
    public final String grantArn() {
        return grantArn;
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final GrantStatus status() {
        return GrantStatus.fromValue(status);
    }

    /**
     * <p>
     * Grant status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Grant status.
     * @see GrantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Grant version.
     * </p>
     * 
     * @return Grant version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantResponse)) {
            return false;
        }
        CreateGrantResponse other = (CreateGrantResponse) obj;
        return Objects.equals(grantArn(), other.grantArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGrantResponse").add("GrantArn", grantArn()).add("Status", statusAsString())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrantArn":
            return Optional.ofNullable(clazz.cast(grantArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GrantArn", GRANT_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantResponse, T> g) {
        return obj -> g.apply((CreateGrantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGrantResponse> {
        /**
         * <p>
         * Grant ARN.
         * </p>
         * 
         * @param grantArn
         *        Grant ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantArn(String grantArn);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param status
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Grant status.
         * </p>
         * 
         * @param status
         *        Grant status.
         * @see GrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantStatus
         */
        Builder status(GrantStatus status);

        /**
         * <p>
         * Grant version.
         * </p>
         * 
         * @param version
         *        Grant version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String grantArn;

        private String status;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantResponse model) {
            super(model);
            grantArn(model.grantArn);
            status(model.status);
            version(model.version);
        }

        public final String getGrantArn() {
            return grantArn;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public CreateGrantResponse build() {
            return new CreateGrantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
