/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateTokenRequest.Builder, CreateTokenRequest> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseArn").getter(getter(CreateTokenRequest::licenseArn)).setter(setter(Builder::licenseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()).build();

    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoleArns")
            .getter(getter(CreateTokenRequest::roleArns))
            .setter(setter(Builder::roleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpirationInDays").getter(getter(CreateTokenRequest::expirationInDays))
            .setter(setter(Builder::expirationInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays").build()).build();

    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TokenProperties")
            .getter(getter(CreateTokenRequest::tokenProperties))
            .setter(setter(Builder::tokenProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateTokenRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD,
            ROLE_ARNS_FIELD, EXPIRATION_IN_DAYS_FIELD, TOKEN_PROPERTIES_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String licenseArn;

    private final List<String> roleArns;

    private final Integer expirationInDays;

    private final List<String> tokenProperties;

    private final String clientToken;

    private CreateTokenRequest(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.roleArns = builder.roleArns;
        this.expirationInDays = builder.expirationInDays;
        this.tokenProperties = builder.tokenProperties;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.
     */
    public final String licenseArn() {
        return licenseArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoleArns() {
        return roleArns != null && !(roleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the
     * roles are in use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleArns} method.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether
     *         the roles are in use.
     */
    public final List<String> roleArns() {
        return roleArns;
    }

    /**
     * <p>
     * Token expiration, in days, counted from token creation. The default is 365 days.
     * </p>
     * 
     * @return Token expiration, in days, counted from token creation. The default is 365 days.
     */
    public final Integer expirationInDays() {
        return expirationInDays;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTokenProperties() {
        return tokenProperties != null && !(tokenProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT
     * token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenProperties} method.
     * </p>
     * 
     * @return Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the
     *         JWT token.
     */
    public final List<String> tokenProperties() {
        return tokenProperties;
    }

    /**
     * <p>
     * Idempotency token, valid for 10 minutes.
     * </p>
     * 
     * @return Idempotency token, valid for 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleArns() ? roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenProperties() ? tokenProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenRequest)) {
            return false;
        }
        CreateTokenRequest other = (CreateTokenRequest) obj;
        return Objects.equals(licenseArn(), other.licenseArn()) && hasRoleArns() == other.hasRoleArns()
                && Objects.equals(roleArns(), other.roleArns()) && Objects.equals(expirationInDays(), other.expirationInDays())
                && hasTokenProperties() == other.hasTokenProperties()
                && Objects.equals(tokenProperties(), other.tokenProperties())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenRequest").add("LicenseArn", licenseArn())
                .add("RoleArns", hasRoleArns() ? roleArns() : null).add("ExpirationInDays", expirationInDays())
                .add("TokenProperties", hasTokenProperties() ? tokenProperties() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseArn":
            return Optional.ofNullable(clazz.cast(licenseArn()));
        case "RoleArns":
            return Optional.ofNullable(clazz.cast(roleArns()));
        case "ExpirationInDays":
            return Optional.ofNullable(clazz.cast(expirationInDays()));
        case "TokenProperties":
            return Optional.ofNullable(clazz.cast(tokenProperties()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        map.put("RoleArns", ROLE_ARNS_FIELD);
        map.put("ExpirationInDays", EXPIRATION_IN_DAYS_FIELD);
        map.put("TokenProperties", TOKEN_PROPERTIES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenRequest, T> g) {
        return obj -> g.apply((CreateTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.
         * </p>
         * 
         * @param licenseArn
         *        Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseArn(String licenseArn);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the
         * roles are in use.
         * </p>
         * 
         * @param roleArns
         *        Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check
         *        whether the roles are in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(Collection<String> roleArns);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the
         * roles are in use.
         * </p>
         * 
         * @param roleArns
         *        Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check
         *        whether the roles are in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArns(String... roleArns);

        /**
         * <p>
         * Token expiration, in days, counted from token creation. The default is 365 days.
         * </p>
         * 
         * @param expirationInDays
         *        Token expiration, in days, counted from token creation. The default is 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationInDays(Integer expirationInDays);

        /**
         * <p>
         * Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT
         * token.
         * </p>
         * 
         * @param tokenProperties
         *        Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of
         *        the JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(Collection<String> tokenProperties);

        /**
         * <p>
         * Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT
         * token.
         * </p>
         * 
         * @param tokenProperties
         *        Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of
         *        the JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenProperties(String... tokenProperties);

        /**
         * <p>
         * Idempotency token, valid for 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        Idempotency token, valid for 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseArn;

        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();

        private Integer expirationInDays;

        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenRequest model) {
            super(model);
            licenseArn(model.licenseArn);
            roleArns(model.roleArns);
            expirationInDays(model.expirationInDays);
            tokenProperties(model.tokenProperties);
            clientToken(model.clientToken);
        }

        public final String getLicenseArn() {
            return licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String... roleArns) {
            roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final Integer getExpirationInDays() {
            return expirationInDays;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        @Override
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final Collection<String> getTokenProperties() {
            if (tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return tokenProperties;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        @Override
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenProperties(String... tokenProperties) {
            tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenRequest build() {
            return new CreateTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
