/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a license type conversion task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseConversionContext implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseConversionContext.Builder, LicenseConversionContext> {
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation").getter(getter(LicenseConversionContext::usageOperation))
            .setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usageOperation;

    private LicenseConversionContext(BuilderImpl builder) {
        this.usageOperation = builder.usageOperation;
    }

    /**
     * <p>
     * The Usage operation value that corresponds to the license type you are converting your resource from. For more
     * information about which platforms correspond to which usage operation values see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data:
     * usage operation by platform </a>
     * </p>
     * 
     * @return The Usage operation value that corresponds to the license type you are converting your resource from. For
     *         more information about which platforms correspond to which usage operation values see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample
     *         data: usage operation by platform </a>
     */
    public final String usageOperation() {
        return usageOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConversionContext)) {
            return false;
        }
        LicenseConversionContext other = (LicenseConversionContext) obj;
        return Objects.equals(usageOperation(), other.usageOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseConversionContext").add("UsageOperation", usageOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseConversionContext, T> g) {
        return obj -> g.apply((LicenseConversionContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseConversionContext> {
        /**
         * <p>
         * The Usage operation value that corresponds to the license type you are converting your resource from. For
         * more information about which platforms correspond to which usage operation values see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data:
         * usage operation by platform </a>
         * </p>
         * 
         * @param usageOperation
         *        The Usage operation value that corresponds to the license type you are converting your resource from.
         *        For more information about which platforms correspond to which usage operation values see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info"
         *        >Sample data: usage operation by platform </a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);
    }

    static final class BuilderImpl implements Builder {
        private String usageOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConversionContext model) {
            usageOperation(model.usageOperation);
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        @Override
        public LicenseConversionContext build() {
            return new LicenseConversionContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
