/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLicenseSpecificationsForResourceResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<ListLicenseSpecificationsForResourceResponse.Builder, ListLicenseSpecificationsForResourceResponse> {
    private static final SdkField<List<LicenseSpecification>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseSpecification>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ListLicenseSpecificationsForResourceResponse::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLicenseSpecificationsForResourceResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_SPECIFICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LicenseSpecification> licenseSpecifications;

    private final String nextToken;

    private ListLicenseSpecificationsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.licenseSpecifications = builder.licenseSpecifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * License configurations associated with a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return License configurations associated with a resource.
     */
    public final List<LicenseSpecification> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseSpecificationsForResourceResponse)) {
            return false;
        }
        ListLicenseSpecificationsForResourceResponse other = (ListLicenseSpecificationsForResourceResponse) obj;
        return hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLicenseSpecificationsForResourceResponse")
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicenseSpecifications", LICENSE_SPECIFICATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseSpecificationsForResourceResponse, T> g) {
        return obj -> g.apply((ListLicenseSpecificationsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLicenseSpecificationsForResourceResponse> {
        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * 
         * @param licenseSpecifications
         *        License configurations associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LicenseSpecification> licenseSpecifications);

        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * 
         * @param licenseSpecifications
         *        License configurations associated with a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LicenseSpecification... licenseSpecifications);

        /**
         * <p>
         * License configurations associated with a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanager.model.LicenseSpecification.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.licensemanager.model.LicenseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanager.model.LicenseSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #licenseSpecifications(List<LicenseSpecification>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanager.model.LicenseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(java.util.Collection<LicenseSpecification>)
         */
        Builder licenseSpecifications(Consumer<LicenseSpecification.Builder>... licenseSpecifications);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private List<LicenseSpecification> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseSpecificationsForResourceResponse model) {
            super(model);
            licenseSpecifications(model.licenseSpecifications);
            nextToken(model.nextToken);
        }

        public final List<LicenseSpecification.Builder> getLicenseSpecifications() {
            List<LicenseSpecification.Builder> result = LicenseSpecificationsCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LicenseSpecification.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LicenseSpecification> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationsCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseSpecification... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseSpecification.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LicenseSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseSpecificationsForResourceResponse build() {
            return new ListLicenseSpecificationsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
