/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSettingsRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<UpdateServiceSettingsRequest.Builder, UpdateServiceSettingsRequest> {
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketArn").getter(getter(UpdateServiceSettingsRequest::s3BucketArn))
            .setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(UpdateServiceSettingsRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField
            .<OrganizationConfiguration> builder(MarshallingType.SDK_POJO).memberName("OrganizationConfiguration")
            .getter(getter(UpdateServiceSettingsRequest::organizationConfiguration))
            .setter(setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCrossAccountsDiscovery")
            .getter(getter(UpdateServiceSettingsRequest::enableCrossAccountsDiscovery))
            .setter(setter(Builder::enableCrossAccountsDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCrossAccountsDiscovery")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_ARN_FIELD,
            SNS_TOPIC_ARN_FIELD, ORGANIZATION_CONFIGURATION_FIELD, ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3BucketArn;

    private final String snsTopicArn;

    private final OrganizationConfiguration organizationConfiguration;

    private final Boolean enableCrossAccountsDiscovery;

    private UpdateServiceSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.s3BucketArn = builder.s3BucketArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.organizationConfiguration = builder.organizationConfiguration;
        this.enableCrossAccountsDiscovery = builder.enableCrossAccountsDiscovery;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * Enables integration with Organizations for cross-account discovery.
     * </p>
     * 
     * @return Enables integration with Organizations for cross-account discovery.
     */
    public final OrganizationConfiguration organizationConfiguration() {
        return organizationConfiguration;
    }

    /**
     * <p>
     * Activates cross-account discovery.
     * </p>
     * 
     * @return Activates cross-account discovery.
     */
    public final Boolean enableCrossAccountsDiscovery() {
        return enableCrossAccountsDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enableCrossAccountsDiscovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsRequest)) {
            return false;
        }
        UpdateServiceSettingsRequest other = (UpdateServiceSettingsRequest) obj;
        return Objects.equals(s3BucketArn(), other.s3BucketArn()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(organizationConfiguration(), other.organizationConfiguration())
                && Objects.equals(enableCrossAccountsDiscovery(), other.enableCrossAccountsDiscovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSettingsRequest").add("S3BucketArn", s3BucketArn())
                .add("SnsTopicArn", snsTopicArn()).add("OrganizationConfiguration", organizationConfiguration())
                .add("EnableCrossAccountsDiscovery", enableCrossAccountsDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "OrganizationConfiguration":
            return Optional.ofNullable(clazz.cast(organizationConfiguration()));
        case "EnableCrossAccountsDiscovery":
            return Optional.ofNullable(clazz.cast(enableCrossAccountsDiscovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3BucketArn", S3_BUCKET_ARN_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("OrganizationConfiguration", ORGANIZATION_CONFIGURATION_FIELD);
        map.put("EnableCrossAccountsDiscovery", ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsRequest, T> g) {
        return obj -> g.apply((UpdateServiceSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceSettingsRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.
         * </p>
         * 
         * @param s3BucketArn
         *        Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.
         * </p>
         * 
         * @param snsTopicArn
         *        Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * Enables integration with Organizations for cross-account discovery.
         * </p>
         * 
         * @param organizationConfiguration
         *        Enables integration with Organizations for cross-account discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration);

        /**
         * <p>
         * Enables integration with Organizations for cross-account discovery.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link OrganizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationConfiguration(OrganizationConfiguration)}.
         * 
         * @param organizationConfiguration
         *        a consumer that will call methods on {@link OrganizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConfiguration(OrganizationConfiguration)
         */
        default Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return organizationConfiguration(OrganizationConfiguration.builder().applyMutation(organizationConfiguration).build());
        }

        /**
         * <p>
         * Activates cross-account discovery.
         * </p>
         * 
         * @param enableCrossAccountsDiscovery
         *        Activates cross-account discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String s3BucketArn;

        private String snsTopicArn;

        private OrganizationConfiguration organizationConfiguration;

        private Boolean enableCrossAccountsDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsRequest model) {
            super(model);
            s3BucketArn(model.s3BucketArn);
            snsTopicArn(model.snsTopicArn);
            organizationConfiguration(model.organizationConfiguration);
            enableCrossAccountsDiscovery(model.enableCrossAccountsDiscovery);
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return organizationConfiguration != null ? organizationConfiguration.toBuilder() : null;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        @Override
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        public final Boolean getEnableCrossAccountsDiscovery() {
            return enableCrossAccountsDiscovery;
        }

        public final void setEnableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
        }

        @Override
        public final Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSettingsRequest build() {
            return new UpdateServiceSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
