/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.licensemanager.LicenseManagerAsyncClient;
import software.amazon.awssdk.services.licensemanager.LicenseManagerServiceClientConfiguration;
import software.amazon.awssdk.services.licensemanager.internal.LicenseManagerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanager.model.AuthorizationException;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.ConflictException;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.EntitlementNotAllowedException;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse;
import software.amazon.awssdk.services.licensemanager.model.FailedDependencyException;
import software.amazon.awssdk.services.licensemanager.model.FilterLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.GetGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.GetGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.InvalidParameterValueException;
import software.amazon.awssdk.services.licensemanager.model.InvalidResourceStateException;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerException;
import software.amazon.awssdk.services.licensemanager.model.LicenseUsageException;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTokensRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTokensResponse;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.NoEntitlementsAllowedException;
import software.amazon.awssdk.services.licensemanager.model.RateLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.RedirectException;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanager.model.ServerInternalException;
import software.amazon.awssdk.services.licensemanager.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UnsupportedDigitalSignatureMethodException;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.ValidationException;
import software.amazon.awssdk.services.licensemanager.transform.AcceptGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckInLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckoutBorrowLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckoutLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateGrantVersionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseConversionTaskForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseVersionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ExtendLicenseConsumptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseUsageRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetServiceSettingsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListAssociationsForLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListDistributedGrantsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListFailuresForLicenseConfigurationOperationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseManagerReportGeneratorsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseSpecificationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseVersionsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicensesRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedGrantsForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedGrantsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedLicensesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedLicensesRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListResourceInventoryRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListTokensRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListUsageForLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.RejectGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseSpecificationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateServiceSettingsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultLicenseManagerAsyncClient
implements LicenseManagerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseManagerAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLicenseManagerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"License_Manager#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AcceptGrantResponse> acceptGrant(AcceptGrantRequest acceptGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, acceptGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcceptGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acceptGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$acceptGrant$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$acceptGrant$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CheckInLicenseResponse> checkInLicense(CheckInLicenseRequest checkInLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkInLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, checkInLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckInLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckInLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckInLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CheckInLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)checkInLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$checkInLicense$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$checkInLicense$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CheckoutBorrowLicenseResponse> checkoutBorrowLicense(CheckoutBorrowLicenseRequest checkoutBorrowLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkoutBorrowLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, checkoutBorrowLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckoutBorrowLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckoutBorrowLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckoutBorrowLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CheckoutBorrowLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)checkoutBorrowLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$checkoutBorrowLicense$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$checkoutBorrowLicense$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CheckoutLicenseResponse> checkoutLicense(CheckoutLicenseRequest checkoutLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkoutLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, checkoutLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckoutLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckoutLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckoutLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CheckoutLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)checkoutLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$checkoutLicense$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$checkoutLicense$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGrantResponse> createGrant(CreateGrantRequest createGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createGrant$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createGrant$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGrantVersionResponse> createGrantVersion(CreateGrantVersionRequest createGrantVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGrantVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createGrantVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrantVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrantVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGrantVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGrantVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createGrantVersion$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createGrantVersion$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLicenseResponse> createLicense(CreateLicenseRequest createLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createLicense$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createLicense$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLicenseConfigurationResponse> createLicenseConfiguration(CreateLicenseConfigurationRequest createLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createLicenseConfiguration$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createLicenseConfiguration$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLicenseConversionTaskForResourceResponse> createLicenseConversionTaskForResource(CreateLicenseConversionTaskForResourceRequest createLicenseConversionTaskForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLicenseConversionTaskForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createLicenseConversionTaskForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseConversionTaskForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseConversionTaskForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseConversionTaskForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLicenseConversionTaskForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLicenseConversionTaskForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createLicenseConversionTaskForResource$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createLicenseConversionTaskForResource$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLicenseManagerReportGeneratorResponse> createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest createLicenseManagerReportGeneratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLicenseManagerReportGeneratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseManagerReportGenerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseManagerReportGeneratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseManagerReportGenerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLicenseManagerReportGeneratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createLicenseManagerReportGenerator$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createLicenseManagerReportGenerator$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLicenseVersionResponse> createLicenseVersion(CreateLicenseVersionRequest createLicenseVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLicenseVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createLicenseVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLicenseVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLicenseVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createLicenseVersion$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createLicenseVersion$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTokenResponse> createToken(CreateTokenRequest createTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, createTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$createToken$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$createToken$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGrantResponse> deleteGrant(DeleteGrantRequest deleteGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$deleteGrant$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$deleteGrant$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLicenseResponse> deleteLicense(DeleteLicenseRequest deleteLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$deleteLicense$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$deleteLicense$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLicenseConfigurationResponse> deleteLicenseConfiguration(DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$deleteLicenseConfiguration$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$deleteLicenseConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLicenseManagerReportGeneratorResponse> deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest deleteLicenseManagerReportGeneratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLicenseManagerReportGeneratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicenseManagerReportGenerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseManagerReportGeneratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicenseManagerReportGenerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLicenseManagerReportGeneratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$deleteLicenseManagerReportGenerator$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$deleteLicenseManagerReportGenerator$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTokenResponse> deleteToken(DeleteTokenRequest deleteTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$deleteToken$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$deleteToken$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExtendLicenseConsumptionResponse> extendLicenseConsumption(ExtendLicenseConsumptionRequest extendLicenseConsumptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)extendLicenseConsumptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, extendLicenseConsumptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExtendLicenseConsumption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendLicenseConsumptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendLicenseConsumption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExtendLicenseConsumptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)extendLicenseConsumptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$extendLicenseConsumption$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$extendLicenseConsumption$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessTokenResponse> getAccessToken(GetAccessTokenRequest getAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccessTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getAccessToken$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getAccessToken$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGrantResponse> getGrant(GetGrantRequest getGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getGrant$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getGrant$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLicenseResponse> getLicense(GetLicenseRequest getLicenseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLicenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicense");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicense").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLicenseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getLicense$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getLicense$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLicenseConfigurationResponse> getLicenseConfiguration(GetLicenseConfigurationRequest getLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getLicenseConfiguration$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getLicenseConfiguration$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLicenseConversionTaskResponse> getLicenseConversionTask(GetLicenseConversionTaskRequest getLicenseConversionTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLicenseConversionTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getLicenseConversionTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseConversionTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseConversionTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseConversionTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLicenseConversionTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLicenseConversionTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getLicenseConversionTask$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getLicenseConversionTask$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLicenseManagerReportGeneratorResponse> getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest getLicenseManagerReportGeneratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLicenseManagerReportGeneratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseManagerReportGenerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseManagerReportGeneratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseManagerReportGenerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLicenseManagerReportGeneratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getLicenseManagerReportGenerator$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getLicenseManagerReportGenerator$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLicenseUsageResponse> getLicenseUsage(GetLicenseUsageRequest getLicenseUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLicenseUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getLicenseUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLicenseUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLicenseUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getLicenseUsage$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getLicenseUsage$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceSettingsResponse> getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, getServiceSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServiceSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServiceSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$getServiceSettings$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$getServiceSettings$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAssociationsForLicenseConfigurationResponse> listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssociationsForLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listAssociationsForLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociationsForLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociationsForLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociationsForLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAssociationsForLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssociationsForLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listAssociationsForLicenseConfiguration$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listAssociationsForLicenseConfiguration$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributedGrantsResponse> listDistributedGrants(ListDistributedGrantsRequest listDistributedGrantsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDistributedGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listDistributedGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributedGrants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDistributedGrantsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributedGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDistributedGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributedGrantsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listDistributedGrants$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listDistributedGrants$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFailuresForLicenseConfigurationOperationsResponse> listFailuresForLicenseConfigurationOperations(ListFailuresForLicenseConfigurationOperationsRequest listFailuresForLicenseConfigurationOperationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFailuresForLicenseConfigurationOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listFailuresForLicenseConfigurationOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFailuresForLicenseConfigurationOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFailuresForLicenseConfigurationOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFailuresForLicenseConfigurationOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFailuresForLicenseConfigurationOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFailuresForLicenseConfigurationOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listFailuresForLicenseConfigurationOperations$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listFailuresForLicenseConfigurationOperations$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations(ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicenseConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicenseConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicenseConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicenseConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenseConfigurations$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenseConfigurations$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicenseConversionTasksResponse> listLicenseConversionTasks(ListLicenseConversionTasksRequest listLicenseConversionTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicenseConversionTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicenseConversionTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseConversionTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseConversionTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseConversionTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicenseConversionTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicenseConversionTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenseConversionTasks$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenseConversionTasks$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicenseManagerReportGeneratorsResponse> listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest listLicenseManagerReportGeneratorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicenseManagerReportGeneratorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicenseManagerReportGeneratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseManagerReportGenerators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseManagerReportGeneratorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseManagerReportGenerators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicenseManagerReportGeneratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicenseManagerReportGeneratorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenseManagerReportGenerators$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenseManagerReportGenerators$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicenseSpecificationsForResourceResponse> listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicenseSpecificationsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicenseSpecificationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseSpecificationsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseSpecificationsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseSpecificationsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicenseSpecificationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicenseSpecificationsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenseSpecificationsForResource$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenseSpecificationsForResource$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicenseVersionsResponse> listLicenseVersions(ListLicenseVersionsRequest listLicenseVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicenseVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicenseVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicenseVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicenseVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenseVersions$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenseVersions$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLicensesResponse> listLicenses(ListLicensesRequest listLicensesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLicensesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listLicensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicensesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLicensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLicensesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listLicenses$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listLicenses$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReceivedGrantsResponse> listReceivedGrants(ListReceivedGrantsRequest listReceivedGrantsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReceivedGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listReceivedGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedGrants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedGrantsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReceivedGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReceivedGrantsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listReceivedGrants$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listReceivedGrants$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReceivedGrantsForOrganizationResponse> listReceivedGrantsForOrganization(ListReceivedGrantsForOrganizationRequest listReceivedGrantsForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReceivedGrantsForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listReceivedGrantsForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedGrantsForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedGrantsForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedGrantsForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReceivedGrantsForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReceivedGrantsForOrganizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listReceivedGrantsForOrganization$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listReceivedGrantsForOrganization$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReceivedLicensesResponse> listReceivedLicenses(ListReceivedLicensesRequest listReceivedLicensesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReceivedLicensesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listReceivedLicensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedLicenses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedLicensesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedLicenses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReceivedLicensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReceivedLicensesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listReceivedLicenses$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listReceivedLicenses$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReceivedLicensesForOrganizationResponse> listReceivedLicensesForOrganization(ListReceivedLicensesForOrganizationRequest listReceivedLicensesForOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReceivedLicensesForOrganizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listReceivedLicensesForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedLicensesForOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedLicensesForOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedLicensesForOrganization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReceivedLicensesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReceivedLicensesForOrganizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listReceivedLicensesForOrganization$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listReceivedLicensesForOrganization$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourceInventoryResponse> listResourceInventory(ListResourceInventoryRequest listResourceInventoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceInventoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listResourceInventoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceInventory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceInventoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceInventory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourceInventoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourceInventoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listResourceInventory$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listResourceInventory$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listTagsForResource$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listTagsForResource$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTokensResponse> listTokens(ListTokensRequest listTokensRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTokensRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listTokensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTokens");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTokensResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTokens").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTokensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTokensRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listTokens$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listTokens$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListUsageForLicenseConfigurationResponse> listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listUsageForLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, listUsageForLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsageForLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsageForLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsageForLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListUsageForLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listUsageForLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$listUsageForLicenseConfiguration$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$listUsageForLicenseConfiguration$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RejectGrantResponse> rejectGrant(RejectGrantRequest rejectGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, rejectGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RejectGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rejectGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$rejectGrant$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$rejectGrant$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$tagResource$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$tagResource$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$untagResource$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$untagResource$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLicenseConfigurationResponse> updateLicenseConfiguration(UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLicenseConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, updateLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLicenseConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseConfiguration$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseConfiguration$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLicenseManagerReportGeneratorResponse> updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest updateLicenseManagerReportGeneratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLicenseManagerReportGeneratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, updateLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseManagerReportGenerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseManagerReportGeneratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseManagerReportGenerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLicenseManagerReportGeneratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseManagerReportGenerator$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseManagerReportGenerator$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLicenseSpecificationsForResourceResponse> updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLicenseSpecificationsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, updateLicenseSpecificationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseSpecificationsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseSpecificationsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseSpecificationsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLicenseSpecificationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLicenseSpecificationsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseSpecificationsForResource$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$updateLicenseSpecificationsForResource$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerAsyncClient.resolveMetricPublishers(clientConfiguration, updateServiceSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "InvalidParameterValueException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                    }
                    case "RateLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RateLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RateLimitExceededException::builder).build());
                    }
                    case "FilterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FilterLimitExceededException::builder).build());
                    }
                    case "ServerInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalException::builder).build());
                    }
                    case "RedirectException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RedirectException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RedirectException::builder).build());
                    }
                    case "UnsupportedDigitalSignatureMethodException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AuthorizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "EntitlementNotAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EntitlementNotAllowedException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NoEntitlementsAllowedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).build());
                    }
                    case "LicenseUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LicenseUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LicenseUsageException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateServiceSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateServiceSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerAsyncClient.lambda$updateServiceSettings$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerAsyncClient.lambda$updateServiceSettings$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final LicenseManagerServiceClientConfiguration serviceClientConfiguration() {
        return new LicenseManagerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "license-manager";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LicenseManagerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        LicenseManagerServiceClientConfigurationBuilder serviceConfigBuilder = new LicenseManagerServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceSettings$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServiceSettings$198(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateServiceSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLicenseSpecificationsForResource$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseSpecificationsForResource$194(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLicenseSpecificationsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLicenseManagerReportGenerator$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseManagerReportGenerator$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLicenseManagerReportGeneratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLicenseConfiguration$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseConfiguration$186(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$182(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$178(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rejectGrant$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectGrant$174(List metricPublishers, MetricCollector apiCallMetricCollector, RejectGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listUsageForLicenseConfiguration$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsageForLicenseConfiguration$170(List metricPublishers, MetricCollector apiCallMetricCollector, ListUsageForLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTokens$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTokens$166(List metricPublishers, MetricCollector apiCallMetricCollector, ListTokensResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$162(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourceInventory$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceInventory$158(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourceInventoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReceivedLicensesForOrganization$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedLicensesForOrganization$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListReceivedLicensesForOrganizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReceivedLicenses$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedLicenses$150(List metricPublishers, MetricCollector apiCallMetricCollector, ListReceivedLicensesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReceivedGrantsForOrganization$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedGrantsForOrganization$146(List metricPublishers, MetricCollector apiCallMetricCollector, ListReceivedGrantsForOrganizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReceivedGrants$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedGrants$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListReceivedGrantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenses$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenses$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicensesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenseVersions$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseVersions$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicenseVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenseSpecificationsForResource$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseSpecificationsForResource$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicenseSpecificationsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenseManagerReportGenerators$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseManagerReportGenerators$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicenseManagerReportGeneratorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenseConversionTasks$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseConversionTasks$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicenseConversionTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLicenseConfigurations$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseConfigurations$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListLicenseConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFailuresForLicenseConfigurationOperations$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFailuresForLicenseConfigurationOperations$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListFailuresForLicenseConfigurationOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributedGrants$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributedGrants$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributedGrantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssociationsForLicenseConfiguration$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociationsForLicenseConfiguration$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssociationsForLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getServiceSettings$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceSettings$102(List metricPublishers, MetricCollector apiCallMetricCollector, GetServiceSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLicenseUsage$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseUsage$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetLicenseUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLicenseManagerReportGenerator$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseManagerReportGenerator$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetLicenseManagerReportGeneratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLicenseConversionTask$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseConversionTask$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetLicenseConversionTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLicenseConfiguration$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseConfiguration$86(List metricPublishers, MetricCollector apiCallMetricCollector, GetLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLicense$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicense$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getGrant$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGrant$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessToken$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessToken$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$extendLicenseConsumption$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$extendLicenseConsumption$70(List metricPublishers, MetricCollector apiCallMetricCollector, ExtendLicenseConsumptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteToken$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteToken$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLicenseManagerReportGenerator$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicenseManagerReportGenerator$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLicenseManagerReportGeneratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLicenseConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicenseConfiguration$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLicense$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicense$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteGrant$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGrant$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createToken$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createToken$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLicenseVersion$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseVersion$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLicenseVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLicenseManagerReportGenerator$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseManagerReportGenerator$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLicenseManagerReportGeneratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLicenseConversionTaskForResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseConversionTaskForResource$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLicenseConversionTaskForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLicenseConfiguration$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseConfiguration$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLicenseConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLicense$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicense$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGrantVersion$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrantVersion$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGrantVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGrant$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrant$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$checkoutLicense$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkoutLicense$14(List metricPublishers, MetricCollector apiCallMetricCollector, CheckoutLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$checkoutBorrowLicense$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkoutBorrowLicense$10(List metricPublishers, MetricCollector apiCallMetricCollector, CheckoutBorrowLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$checkInLicense$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkInLicense$6(List metricPublishers, MetricCollector apiCallMetricCollector, CheckInLicenseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$acceptGrant$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptGrant$2(List metricPublishers, MetricCollector apiCallMetricCollector, AcceptGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

