/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse;

/**
 * Service client for accessing AWS License Manager asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname> AWS License Manager </fullname>
 * <p>
 * <i>This is the AWS License Manager API Reference.</i> It provides descriptions, syntax, and usage examples for each
 * of the actions and data types for License Manager. The topic for each action shows the Query API request parameters
 * and the XML response. You can also view the XML request elements in the WSDL.
 * </p>
 * <p>
 * Alternatively, you can use one of the AWS SDKs to access an API that's tailored to the programming language or
 * platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LicenseManagerAsyncClient extends SdkClient {
    String SERVICE_NAME = "license-manager";

    /**
     * Create a {@link LicenseManagerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerAsyncClient}.
     */
    static LicenseManagerAsyncClientBuilder builder() {
        return new DefaultLicenseManagerAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a new license configuration object. A license configuration is an abstraction of a customer license
     * agreement that can be consumed and enforced by License Manager. Components include specifications for the license
     * type (licensing by instance, socket, CPU, or VCPU), tenancy (shared tenancy, Amazon EC2 Dedicated Instance,
     * Amazon EC2 Dedicated Host, or any of these), host affinity (how long a VM must be associated with a host), the
     * number of licenses purchased and used.
     * </p>
     *
     * @param createLicenseConfigurationRequest
     * @return A Java Future containing the result of the CreateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseConfigurationResponse> createLicenseConfiguration(
            CreateLicenseConfigurationRequest createLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new license configuration object. A license configuration is an abstraction of a customer license
     * agreement that can be consumed and enforced by License Manager. Components include specifications for the license
     * type (licensing by instance, socket, CPU, or VCPU), tenancy (shared tenancy, Amazon EC2 Dedicated Instance,
     * Amazon EC2 Dedicated Host, or any of these), host affinity (how long a VM must be associated with a host), the
     * number of licenses purchased and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param createLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>ResourceLimitExceededException Your resource limits have been exceeded.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.CreateLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLicenseConfigurationResponse> createLicenseConfiguration(
            Consumer<CreateLicenseConfigurationRequest.Builder> createLicenseConfigurationRequest) {
        return createLicenseConfiguration(CreateLicenseConfigurationRequest.builder()
                .applyMutation(createLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing license configuration. This action fails if the configuration is in use.
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     * @return A Java Future containing the result of the DeleteLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseConfigurationResponse> deleteLicenseConfiguration(
            DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing license configuration. This action fails if the configuration is in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.DeleteLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLicenseConfigurationResponse> deleteLicenseConfiguration(
            Consumer<DeleteLicenseConfigurationRequest.Builder> deleteLicenseConfigurationRequest) {
        return deleteLicenseConfiguration(DeleteLicenseConfigurationRequest.builder()
                .applyMutation(deleteLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a detailed description of a license configuration.
     * </p>
     *
     * @param getLicenseConfigurationRequest
     * @return A Java Future containing the result of the GetLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseConfigurationResponse> getLicenseConfiguration(
            GetLicenseConfigurationRequest getLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a detailed description of a license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param getLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLicenseConfigurationResponse> getLicenseConfiguration(
            Consumer<GetLicenseConfigurationRequest.Builder> getLicenseConfigurationRequest) {
        return getLicenseConfiguration(GetLicenseConfigurationRequest.builder().applyMutation(getLicenseConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets License Manager settings for a region. Exposes the configured S3 bucket, SNS topic, etc., for inspection.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets License Manager settings for a region. Exposes the configured S3 bucket, SNS topic, etc., for inspection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings(
            Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest) {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Gets License Manager settings for a region. Exposes the configured S3 bucket, SNS topic, etc., for inspection.
     * </p>
     *
     * @return A Java Future containing the result of the GetServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.GetServiceSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceSettingsResponse> getServiceSettings() {
        return getServiceSettings(GetServiceSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the resource associations for a license configuration. Resource associations need not consume licenses from
     * a license configuration. For example, an AMI or a stopped instance may not consume a license (depending on the
     * license rules). Use this operation to find all resources associated with a license configuration.
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     * @return A Java Future containing the result of the ListAssociationsForLicenseConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociationsForLicenseConfigurationResponse> listAssociationsForLicenseConfiguration(
            ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource associations for a license configuration. Resource associations need not consume licenses from
     * a license configuration. For example, an AMI or a stopped instance may not consume a license (depending on the
     * license rules). Use this operation to find all resources associated with a license configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssociationsForLicenseConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ListAssociationsForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listAssociationsForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssociationsForLicenseConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssociationsForLicenseConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListAssociationsForLicenseConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociationsForLicenseConfigurationResponse> listAssociationsForLicenseConfiguration(
            Consumer<ListAssociationsForLicenseConfigurationRequest.Builder> listAssociationsForLicenseConfigurationRequest) {
        return listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest.builder()
                .applyMutation(listAssociationsForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists license configuration objects for an account, each containing the name, description, license type, and
     * other license terms modeled from a license agreement.
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations(
            ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists license configuration objects for an account, each containing the name, description, license type, and
     * other license terms modeled from a license agreement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLicenseConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations(
            Consumer<ListLicenseConfigurationsRequest.Builder> listLicenseConfigurationsRequest) {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder()
                .applyMutation(listLicenseConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists license configuration objects for an account, each containing the name, description, license type, and
     * other license terms modeled from a license agreement.
     * </p>
     *
     * @return A Java Future containing the result of the ListLicenseConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseConfigurationsResponse> listLicenseConfigurations() {
        return listLicenseConfigurations(ListLicenseConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the license configuration for a resource.
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     * @return A Java Future containing the result of the ListLicenseSpecificationsForResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseSpecificationsForResourceResponse> listLicenseSpecificationsForResource(
            ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the license configuration for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link ListLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param listLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListLicenseSpecificationsForResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListLicenseSpecificationsForResource
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLicenseSpecificationsForResourceResponse> listLicenseSpecificationsForResource(
            Consumer<ListLicenseSpecificationsForResourceRequest.Builder> listLicenseSpecificationsForResourceRequest) {
        return listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(listLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a detailed list of resources.
     * </p>
     *
     * @param listResourceInventoryRequest
     * @return A Java Future containing the result of the ListResourceInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>FailedDependencyException A dependency required to run the API is missing.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListResourceInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceInventoryResponse> listResourceInventory(
            ListResourceInventoryRequest listResourceInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a detailed list of resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceInventoryRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceInventoryRequest#builder()}
     * </p>
     *
     * @param listResourceInventoryRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceInventoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>FailedDependencyException A dependency required to run the API is missing.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListResourceInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceInventoryResponse> listResourceInventory(
            Consumer<ListResourceInventoryRequest.Builder> listResourceInventoryRequest) {
        return listResourceInventory(ListResourceInventoryRequest.builder().applyMutation(listResourceInventoryRequest).build());
    }

    /**
     * <p>
     * Lists tags attached to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags attached to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     * @return A Java Future containing the result of the ListUsageForLicenseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListUsageForLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageForLicenseConfigurationResponse> listUsageForLicenseConfiguration(
            ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all license usage records for a license configuration, displaying license consumption details by resource
     * at a selected point in time. Use this action to audit the current license consumption for any license inventory
     * and configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageForLicenseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ListUsageForLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param listUsageForLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageForLicenseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListUsageForLicenseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>FilterLimitExceededException The request uses too many filters or too many filter values.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.ListUsageForLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageForLicenseConfigurationResponse> listUsageForLicenseConfiguration(
            Consumer<ListUsageForLicenseConfigurationRequest.Builder> listUsageForLicenseConfigurationRequest) {
        return listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest.builder()
                .applyMutation(listUsageForLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Attach one of more tags to any resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attach one of more tags to any resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration object. A license configuration is an abstraction of
     * a customer license agreement that can be consumed and enforced by License Manager. Components include
     * specifications for the license type (Instances, cores, sockets, VCPUs), tenancy (shared or Dedicated Host), host
     * affinity (how long a VM is associated with a host), the number of licenses purchased and used.
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     * @return A Java Future containing the result of the UpdateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseConfigurationResponse> updateLicenseConfiguration(
            UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the attributes of an existing license configuration object. A license configuration is an abstraction of
     * a customer license agreement that can be consumed and enforced by License Manager. Components include
     * specifications for the license type (Instances, cores, sockets, VCPUs), tenancy (shared or Dedicated Host), host
     * affinity (how long a VM is associated with a host), the number of licenses purchased and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLicenseConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLicenseConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLicenseConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLicenseConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseConfigurationResponse> updateLicenseConfiguration(
            Consumer<UpdateLicenseConfigurationRequest.Builder> updateLicenseConfigurationRequest) {
        return updateLicenseConfiguration(UpdateLicenseConfigurationRequest.builder()
                .applyMutation(updateLicenseConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds or removes license configurations for a specified AWS resource. This operation currently supports updating
     * the license specifications of AMIs, instances, and hosts. Launch templates and AWS CloudFormation templates are
     * not managed from this operation as those resources send the license configurations directly to a resource
     * creation operation, such as <code>RunInstances</code>.
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     * @return A Java Future containing the result of the UpdateLicenseSpecificationsForResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException License Manager cannot allocate a license to a resource because of its
     *         state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.</li>
     *         <li>LicenseUsageException You do not have enough licenses available to support a new resource launch.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseSpecificationsForResourceResponse> updateLicenseSpecificationsForResource(
            UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or removes license configurations for a specified AWS resource. This operation currently supports updating
     * the license specifications of AMIs, instances, and hosts. Launch templates and AWS CloudFormation templates are
     * not managed from this operation as those resources send the license configurations directly to a resource
     * creation operation, such as <code>RunInstances</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateLicenseSpecificationsForResourceRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateLicenseSpecificationsForResourceRequest#builder()}
     * </p>
     *
     * @param updateLicenseSpecificationsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLicenseSpecificationsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateLicenseSpecificationsForResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>InvalidResourceStateException License Manager cannot allocate a license to a resource because of its
     *         state. </p>
     *         <p>
     *         For example, you cannot allocate a license to an instance in the process of shutting down.</li>
     *         <li>LicenseUsageException You do not have enough licenses available to support a new resource launch.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateLicenseSpecificationsForResource
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLicenseSpecificationsForResourceResponse> updateLicenseSpecificationsForResource(
            Consumer<UpdateLicenseSpecificationsForResourceRequest.Builder> updateLicenseSpecificationsForResourceRequest) {
        return updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest.builder()
                .applyMutation(updateLicenseSpecificationsForResourceRequest).build());
    }

    /**
     * <p>
     * Updates License Manager service settings.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateServiceSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            UpdateServiceSettingsRequest updateServiceSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates License Manager service settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServiceSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameter values are not valid.</li>
     *         <li>ServerInternalException The server experienced an internal error. Try again.</li>
     *         <li>AuthorizationException The AWS user account does not have permission to perform the action. Check the
     *         IAM policy associated with this account.</li>
     *         <li>AccessDeniedException Access to resource denied.</li>
     *         <li>RateLimitExceededException Too many requests have been submitted. Try again after a brief wait.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerAsyncClient.UpdateServiceSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceSettingsResponse> updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }
}
