/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLicenseConfigurationRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<UpdateLicenseConfigurationRequest.Builder, UpdateLicenseConfigurationRequest> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLicenseConfigurationRequest::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build())
            .build();

    private static final SdkField<String> LICENSE_CONFIGURATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLicenseConfigurationRequest::licenseConfigurationStatusAsString))
            .setter(setter(Builder::licenseConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationStatus").build())
            .build();

    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLicenseConfigurationRequest::licenseRules))
            .setter(setter(Builder::licenseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateLicenseConfigurationRequest::licenseCount)).setter(setter(Builder::licenseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()).build();

    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateLicenseConfigurationRequest::licenseCountHardLimit))
            .setter(setter(Builder::licenseCountHardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLicenseConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLicenseConfigurationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LICENSE_CONFIGURATION_ARN_FIELD, LICENSE_CONFIGURATION_STATUS_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD,
            LICENSE_COUNT_HARD_LIMIT_FIELD, NAME_FIELD, DESCRIPTION_FIELD));

    private final String licenseConfigurationArn;

    private final String licenseConfigurationStatus;

    private final List<String> licenseRules;

    private final Long licenseCount;

    private final Boolean licenseCountHardLimit;

    private final String name;

    private final String description;

    private UpdateLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.licenseConfigurationStatus = builder.licenseConfigurationStatus;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * ARN for a license configuration.
     * </p>
     * 
     * @return ARN for a license configuration.
     */
    public String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    /**
     * <p>
     * New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseConfigurationStatus} will return {@link LicenseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #licenseConfigurationStatusAsString}.
     * </p>
     * 
     * @return New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
     * @see LicenseConfigurationStatus
     */
    public LicenseConfigurationStatus licenseConfigurationStatus() {
        return LicenseConfigurationStatus.fromValue(licenseConfigurationStatus);
    }

    /**
     * <p>
     * New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseConfigurationStatus} will return {@link LicenseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #licenseConfigurationStatusAsString}.
     * </p>
     * 
     * @return New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
     * @see LicenseConfigurationStatus
     */
    public String licenseConfigurationStatusAsString() {
        return licenseConfigurationStatus;
    }

    /**
     * <p>
     * List of flexible text strings designating license rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of flexible text strings designating license rules.
     */
    public List<String> licenseRules() {
        return licenseRules;
    }

    /**
     * <p>
     * New number of licenses managed by the license configuration.
     * </p>
     * 
     * @return New number of licenses managed by the license configuration.
     */
    public Long licenseCount() {
        return licenseCount;
    }

    /**
     * <p>
     * Sets the number of available licenses as a hard limit.
     * </p>
     * 
     * @return Sets the number of available licenses as a hard limit.
     */
    public Boolean licenseCountHardLimit() {
        return licenseCountHardLimit;
    }

    /**
     * <p>
     * New name of the license configuration.
     * </p>
     * 
     * @return New name of the license configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * New human-friendly description of the license configuration.
     * </p>
     * 
     * @return New human-friendly description of the license configuration.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseRules());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseConfigurationRequest)) {
            return false;
        }
        UpdateLicenseConfigurationRequest other = (UpdateLicenseConfigurationRequest) obj;
        return Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn())
                && Objects.equals(licenseConfigurationStatusAsString(), other.licenseConfigurationStatusAsString())
                && Objects.equals(licenseRules(), other.licenseRules()) && Objects.equals(licenseCount(), other.licenseCount())
                && Objects.equals(licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateLicenseConfigurationRequest").add("LicenseConfigurationArn", licenseConfigurationArn())
                .add("LicenseConfigurationStatus", licenseConfigurationStatusAsString()).add("LicenseRules", licenseRules())
                .add("LicenseCount", licenseCount()).add("LicenseCountHardLimit", licenseCountHardLimit()).add("Name", name())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        case "LicenseConfigurationStatus":
            return Optional.ofNullable(clazz.cast(licenseConfigurationStatusAsString()));
        case "LicenseRules":
            return Optional.ofNullable(clazz.cast(licenseRules()));
        case "LicenseCount":
            return Optional.ofNullable(clazz.cast(licenseCount()));
        case "LicenseCountHardLimit":
            return Optional.ofNullable(clazz.cast(licenseCountHardLimit()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLicenseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLicenseConfigurationRequest> {
        /**
         * <p>
         * ARN for a license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        ARN for a license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);

        /**
         * <p>
         * New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
         * </p>
         * 
         * @param licenseConfigurationStatus
         *        New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
         * @see LicenseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConfigurationStatus
         */
        Builder licenseConfigurationStatus(String licenseConfigurationStatus);

        /**
         * <p>
         * New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
         * </p>
         * 
         * @param licenseConfigurationStatus
         *        New status of the license configuration (<code>ACTIVE</code> or <code>INACTIVE</code>).
         * @see LicenseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseConfigurationStatus
         */
        Builder licenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus);

        /**
         * <p>
         * List of flexible text strings designating license rules.
         * </p>
         * 
         * @param licenseRules
         *        List of flexible text strings designating license rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(Collection<String> licenseRules);

        /**
         * <p>
         * List of flexible text strings designating license rules.
         * </p>
         * 
         * @param licenseRules
         *        List of flexible text strings designating license rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseRules(String... licenseRules);

        /**
         * <p>
         * New number of licenses managed by the license configuration.
         * </p>
         * 
         * @param licenseCount
         *        New number of licenses managed by the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCount(Long licenseCount);

        /**
         * <p>
         * Sets the number of available licenses as a hard limit.
         * </p>
         * 
         * @param licenseCountHardLimit
         *        Sets the number of available licenses as a hard limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseCountHardLimit(Boolean licenseCountHardLimit);

        /**
         * <p>
         * New name of the license configuration.
         * </p>
         * 
         * @param name
         *        New name of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * New human-friendly description of the license configuration.
         * </p>
         * 
         * @param description
         *        New human-friendly description of the license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseConfigurationArn;

        private String licenseConfigurationStatus;

        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();

        private Long licenseCount;

        private Boolean licenseCountHardLimit;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLicenseConfigurationRequest model) {
            super(model);
            licenseConfigurationArn(model.licenseConfigurationArn);
            licenseConfigurationStatus(model.licenseConfigurationStatus);
            licenseRules(model.licenseRules);
            licenseCount(model.licenseCount);
            licenseCountHardLimit(model.licenseCountHardLimit);
            name(model.name);
            description(model.description);
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final String getLicenseConfigurationStatusAsString() {
            return licenseConfigurationStatus;
        }

        @Override
        public final Builder licenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
            return this;
        }

        @Override
        public final Builder licenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus) {
            this.licenseConfigurationStatus(licenseConfigurationStatus.toString());
            return this;
        }

        public final void setLicenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
        }

        public final Collection<String> getLicenseRules() {
            return licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String... licenseRules) {
            licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Long getLicenseCount() {
            return licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLicenseConfigurationRequest build() {
            return new UpdateLicenseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
