/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedResourceSummary.Builder, ManagedResourceSummary> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedResourceSummary::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Long> ASSOCIATION_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ManagedResourceSummary::associationCount)).setter(setter(Builder::associationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            ASSOCIATION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final Long associationCount;

    private ManagedResourceSummary(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.associationCount = builder.associationCount;
    }

    /**
     * <p>
     * Type of resource associated with a license (instance, host, or AMI).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Type of resource associated with a license (instance, host, or AMI).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Type of resource associated with a license (instance, host, or AMI).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Type of resource associated with a license (instance, host, or AMI).
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Number of resources associated with licenses.
     * </p>
     * 
     * @return Number of resources associated with licenses.
     */
    public Long associationCount() {
        return associationCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedResourceSummary)) {
            return false;
        }
        ManagedResourceSummary other = (ManagedResourceSummary) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(associationCount(), other.associationCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ManagedResourceSummary").add("ResourceType", resourceTypeAsString())
                .add("AssociationCount", associationCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "AssociationCount":
            return Optional.ofNullable(clazz.cast(associationCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedResourceSummary, T> g) {
        return obj -> g.apply((ManagedResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedResourceSummary> {
        /**
         * <p>
         * Type of resource associated with a license (instance, host, or AMI).
         * </p>
         * 
         * @param resourceType
         *        Type of resource associated with a license (instance, host, or AMI).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Type of resource associated with a license (instance, host, or AMI).
         * </p>
         * 
         * @param resourceType
         *        Type of resource associated with a license (instance, host, or AMI).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Number of resources associated with licenses.
         * </p>
         * 
         * @param associationCount
         *        Number of resources associated with licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationCount(Long associationCount);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private Long associationCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedResourceSummary model) {
            resourceType(model.resourceType);
            associationCount(model.associationCount);
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Long getAssociationCount() {
            return associationCount;
        }

        @Override
        public final Builder associationCount(Long associationCount) {
            this.associationCount = associationCount;
            return this;
        }

        public final void setAssociationCount(Long associationCount) {
            this.associationCount = associationCount;
        }

        @Override
        public ManagedResourceSummary build() {
            return new ManagedResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
