/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegisteredSubscriptionProvidersResponse extends LicenseManagerLinuxSubscriptionsResponse implements
        ToCopyableBuilder<ListRegisteredSubscriptionProvidersResponse.Builder, ListRegisteredSubscriptionProvidersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegisteredSubscriptionProvidersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RegisteredSubscriptionProvider>> REGISTERED_SUBSCRIPTION_PROVIDERS_FIELD = SdkField
            .<List<RegisteredSubscriptionProvider>> builder(MarshallingType.LIST)
            .memberName("RegisteredSubscriptionProviders")
            .getter(getter(ListRegisteredSubscriptionProvidersResponse::registeredSubscriptionProviders))
            .setter(setter(Builder::registeredSubscriptionProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredSubscriptionProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegisteredSubscriptionProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegisteredSubscriptionProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REGISTERED_SUBSCRIPTION_PROVIDERS_FIELD));

    private final String nextToken;

    private final List<RegisteredSubscriptionProvider> registeredSubscriptionProviders;

    private ListRegisteredSubscriptionProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.registeredSubscriptionProviders = builder.registeredSubscriptionProviders;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegisteredSubscriptionProviders
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRegisteredSubscriptionProviders() {
        return registeredSubscriptionProviders != null && !(registeredSubscriptionProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of BYOL registration resources that fit the criteria you specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegisteredSubscriptionProviders}
     * method.
     * </p>
     * 
     * @return The list of BYOL registration resources that fit the criteria you specified in the request.
     */
    public final List<RegisteredSubscriptionProvider> registeredSubscriptionProviders() {
        return registeredSubscriptionProviders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRegisteredSubscriptionProviders() ? registeredSubscriptionProviders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegisteredSubscriptionProvidersResponse)) {
            return false;
        }
        ListRegisteredSubscriptionProvidersResponse other = (ListRegisteredSubscriptionProvidersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRegisteredSubscriptionProviders() == other.hasRegisteredSubscriptionProviders()
                && Objects.equals(registeredSubscriptionProviders(), other.registeredSubscriptionProviders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRegisteredSubscriptionProvidersResponse")
                .add("NextToken", nextToken())
                .add("RegisteredSubscriptionProviders",
                        hasRegisteredSubscriptionProviders() ? registeredSubscriptionProviders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RegisteredSubscriptionProviders":
            return Optional.ofNullable(clazz.cast(registeredSubscriptionProviders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegisteredSubscriptionProvidersResponse, T> g) {
        return obj -> g.apply((ListRegisteredSubscriptionProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerLinuxSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRegisteredSubscriptionProvidersResponse> {
        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of BYOL registration resources that fit the criteria you specified in the request.
         * </p>
         * 
         * @param registeredSubscriptionProviders
         *        The list of BYOL registration resources that fit the criteria you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredSubscriptionProviders(Collection<RegisteredSubscriptionProvider> registeredSubscriptionProviders);

        /**
         * <p>
         * The list of BYOL registration resources that fit the criteria you specified in the request.
         * </p>
         * 
         * @param registeredSubscriptionProviders
         *        The list of BYOL registration resources that fit the criteria you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredSubscriptionProviders(RegisteredSubscriptionProvider... registeredSubscriptionProviders);

        /**
         * <p>
         * The list of BYOL registration resources that fit the criteria you specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #registeredSubscriptionProviders(List<RegisteredSubscriptionProvider>)}.
         * 
         * @param registeredSubscriptionProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registeredSubscriptionProviders(java.util.Collection<RegisteredSubscriptionProvider>)
         */
        Builder registeredSubscriptionProviders(
                Consumer<RegisteredSubscriptionProvider.Builder>... registeredSubscriptionProviders);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RegisteredSubscriptionProvider> registeredSubscriptionProviders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegisteredSubscriptionProvidersResponse model) {
            super(model);
            nextToken(model.nextToken);
            registeredSubscriptionProviders(model.registeredSubscriptionProviders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RegisteredSubscriptionProvider.Builder> getRegisteredSubscriptionProviders() {
            List<RegisteredSubscriptionProvider.Builder> result = RegisteredSubscriptionProviderListCopier
                    .copyToBuilder(this.registeredSubscriptionProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegisteredSubscriptionProviders(
                Collection<RegisteredSubscriptionProvider.BuilderImpl> registeredSubscriptionProviders) {
            this.registeredSubscriptionProviders = RegisteredSubscriptionProviderListCopier
                    .copyFromBuilder(registeredSubscriptionProviders);
        }

        @Override
        public final Builder registeredSubscriptionProviders(
                Collection<RegisteredSubscriptionProvider> registeredSubscriptionProviders) {
            this.registeredSubscriptionProviders = RegisteredSubscriptionProviderListCopier.copy(registeredSubscriptionProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredSubscriptionProviders(RegisteredSubscriptionProvider... registeredSubscriptionProviders) {
            registeredSubscriptionProviders(Arrays.asList(registeredSubscriptionProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredSubscriptionProviders(
                Consumer<RegisteredSubscriptionProvider.Builder>... registeredSubscriptionProviders) {
            registeredSubscriptionProviders(Stream.of(registeredSubscriptionProviders)
                    .map(c -> RegisteredSubscriptionProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegisteredSubscriptionProvidersResponse build() {
            return new ListRegisteredSubscriptionProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
