/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterSubscriptionProviderResponse extends LicenseManagerLinuxSubscriptionsResponse implements
        ToCopyableBuilder<RegisterSubscriptionProviderResponse.Builder, RegisterSubscriptionProviderResponse> {
    private static final SdkField<String> SUBSCRIPTION_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderArn").getter(getter(RegisterSubscriptionProviderResponse::subscriptionProviderArn))
            .setter(setter(Builder::subscriptionProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderArn").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderSource")
            .getter(getter(RegisterSubscriptionProviderResponse::subscriptionProviderSourceAsString))
            .setter(setter(Builder::subscriptionProviderSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderSource").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderStatus")
            .getter(getter(RegisterSubscriptionProviderResponse::subscriptionProviderStatusAsString))
            .setter(setter(Builder::subscriptionProviderStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUBSCRIPTION_PROVIDER_ARN_FIELD, SUBSCRIPTION_PROVIDER_SOURCE_FIELD, SUBSCRIPTION_PROVIDER_STATUS_FIELD));

    private final String subscriptionProviderArn;

    private final String subscriptionProviderSource;

    private final String subscriptionProviderStatus;

    private RegisterSubscriptionProviderResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionProviderArn = builder.subscriptionProviderArn;
        this.subscriptionProviderSource = builder.subscriptionProviderSource;
        this.subscriptionProviderStatus = builder.subscriptionProviderStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
     */
    public final String subscriptionProviderArn() {
        return subscriptionProviderArn;
    }

    /**
     * <p>
     * The Linux subscription provider that you registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderSource} will return {@link SubscriptionProviderSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderSourceAsString}.
     * </p>
     * 
     * @return The Linux subscription provider that you registered.
     * @see SubscriptionProviderSource
     */
    public final SubscriptionProviderSource subscriptionProviderSource() {
        return SubscriptionProviderSource.fromValue(subscriptionProviderSource);
    }

    /**
     * <p>
     * The Linux subscription provider that you registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderSource} will return {@link SubscriptionProviderSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderSourceAsString}.
     * </p>
     * 
     * @return The Linux subscription provider that you registered.
     * @see SubscriptionProviderSource
     */
    public final String subscriptionProviderSourceAsString() {
        return subscriptionProviderSource;
    }

    /**
     * <p>
     * Indicates the status of the registration action for the Linux subscription provider that you requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderStatus} will return {@link SubscriptionProviderStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the registration action for the Linux subscription provider that you requested.
     * @see SubscriptionProviderStatus
     */
    public final SubscriptionProviderStatus subscriptionProviderStatus() {
        return SubscriptionProviderStatus.fromValue(subscriptionProviderStatus);
    }

    /**
     * <p>
     * Indicates the status of the registration action for the Linux subscription provider that you requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderStatus} will return {@link SubscriptionProviderStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the registration action for the Linux subscription provider that you requested.
     * @see SubscriptionProviderStatus
     */
    public final String subscriptionProviderStatusAsString() {
        return subscriptionProviderStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSubscriptionProviderResponse)) {
            return false;
        }
        RegisterSubscriptionProviderResponse other = (RegisterSubscriptionProviderResponse) obj;
        return Objects.equals(subscriptionProviderArn(), other.subscriptionProviderArn())
                && Objects.equals(subscriptionProviderSourceAsString(), other.subscriptionProviderSourceAsString())
                && Objects.equals(subscriptionProviderStatusAsString(), other.subscriptionProviderStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterSubscriptionProviderResponse").add("SubscriptionProviderArn", subscriptionProviderArn())
                .add("SubscriptionProviderSource", subscriptionProviderSourceAsString())
                .add("SubscriptionProviderStatus", subscriptionProviderStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionProviderArn":
            return Optional.ofNullable(clazz.cast(subscriptionProviderArn()));
        case "SubscriptionProviderSource":
            return Optional.ofNullable(clazz.cast(subscriptionProviderSourceAsString()));
        case "SubscriptionProviderStatus":
            return Optional.ofNullable(clazz.cast(subscriptionProviderStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterSubscriptionProviderResponse, T> g) {
        return obj -> g.apply((RegisterSubscriptionProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerLinuxSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterSubscriptionProviderResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
         * </p>
         * 
         * @param subscriptionProviderArn
         *        The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderArn(String subscriptionProviderArn);

        /**
         * <p>
         * The Linux subscription provider that you registered.
         * </p>
         * 
         * @param subscriptionProviderSource
         *        The Linux subscription provider that you registered.
         * @see SubscriptionProviderSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderSource
         */
        Builder subscriptionProviderSource(String subscriptionProviderSource);

        /**
         * <p>
         * The Linux subscription provider that you registered.
         * </p>
         * 
         * @param subscriptionProviderSource
         *        The Linux subscription provider that you registered.
         * @see SubscriptionProviderSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderSource
         */
        Builder subscriptionProviderSource(SubscriptionProviderSource subscriptionProviderSource);

        /**
         * <p>
         * Indicates the status of the registration action for the Linux subscription provider that you requested.
         * </p>
         * 
         * @param subscriptionProviderStatus
         *        Indicates the status of the registration action for the Linux subscription provider that you
         *        requested.
         * @see SubscriptionProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderStatus
         */
        Builder subscriptionProviderStatus(String subscriptionProviderStatus);

        /**
         * <p>
         * Indicates the status of the registration action for the Linux subscription provider that you requested.
         * </p>
         * 
         * @param subscriptionProviderStatus
         *        Indicates the status of the registration action for the Linux subscription provider that you
         *        requested.
         * @see SubscriptionProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderStatus
         */
        Builder subscriptionProviderStatus(SubscriptionProviderStatus subscriptionProviderStatus);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsResponse.BuilderImpl implements Builder {
        private String subscriptionProviderArn;

        private String subscriptionProviderSource;

        private String subscriptionProviderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSubscriptionProviderResponse model) {
            super(model);
            subscriptionProviderArn(model.subscriptionProviderArn);
            subscriptionProviderSource(model.subscriptionProviderSource);
            subscriptionProviderStatus(model.subscriptionProviderStatus);
        }

        public final String getSubscriptionProviderArn() {
            return subscriptionProviderArn;
        }

        public final void setSubscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
        }

        @Override
        public final Builder subscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
            return this;
        }

        public final String getSubscriptionProviderSource() {
            return subscriptionProviderSource;
        }

        public final void setSubscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
        }

        @Override
        public final Builder subscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
            return this;
        }

        @Override
        public final Builder subscriptionProviderSource(SubscriptionProviderSource subscriptionProviderSource) {
            this.subscriptionProviderSource(subscriptionProviderSource == null ? null : subscriptionProviderSource.toString());
            return this;
        }

        public final String getSubscriptionProviderStatus() {
            return subscriptionProviderStatus;
        }

        public final void setSubscriptionProviderStatus(String subscriptionProviderStatus) {
            this.subscriptionProviderStatus = subscriptionProviderStatus;
        }

        @Override
        public final Builder subscriptionProviderStatus(String subscriptionProviderStatus) {
            this.subscriptionProviderStatus = subscriptionProviderStatus;
            return this;
        }

        @Override
        public final Builder subscriptionProviderStatus(SubscriptionProviderStatus subscriptionProviderStatus) {
            this.subscriptionProviderStatus(subscriptionProviderStatus == null ? null : subscriptionProviderStatus.toString());
            return this;
        }

        @Override
        public RegisterSubscriptionProviderResponse build() {
            return new RegisterSubscriptionProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
