/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterSubscriptionProviderRequest extends LicenseManagerLinuxSubscriptionsRequest implements
        ToCopyableBuilder<DeregisterSubscriptionProviderRequest.Builder, DeregisterSubscriptionProviderRequest> {
    private static final SdkField<String> SUBSCRIPTION_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderArn").getter(getter(DeregisterSubscriptionProviderRequest::subscriptionProviderArn))
            .setter(setter(Builder::subscriptionProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUBSCRIPTION_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subscriptionProviderArn;

    private DeregisterSubscriptionProviderRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionProviderArn = builder.subscriptionProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the subscription provider resource to deregister.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the subscription provider resource to deregister.
     */
    public final String subscriptionProviderArn() {
        return subscriptionProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterSubscriptionProviderRequest)) {
            return false;
        }
        DeregisterSubscriptionProviderRequest other = (DeregisterSubscriptionProviderRequest) obj;
        return Objects.equals(subscriptionProviderArn(), other.subscriptionProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterSubscriptionProviderRequest")
                .add("SubscriptionProviderArn", subscriptionProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionProviderArn":
            return Optional.ofNullable(clazz.cast(subscriptionProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubscriptionProviderArn", SUBSCRIPTION_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterSubscriptionProviderRequest, T> g) {
        return obj -> g.apply((DeregisterSubscriptionProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerLinuxSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterSubscriptionProviderRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the subscription provider resource to deregister.
         * </p>
         * 
         * @param subscriptionProviderArn
         *        The Amazon Resource Name (ARN) of the subscription provider resource to deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderArn(String subscriptionProviderArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl implements Builder {
        private String subscriptionProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterSubscriptionProviderRequest model) {
            super(model);
            subscriptionProviderArn(model.subscriptionProviderArn);
        }

        public final String getSubscriptionProviderArn() {
            return subscriptionProviderArn;
        }

        public final void setSubscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
        }

        @Override
        public final Builder subscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterSubscriptionProviderRequest build() {
            return new DeregisterSubscriptionProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
