/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A third-party provider for operating system (OS) platform software and license subscriptions, such as Red Hat. When
 * you register a third-party Linux subscription provider, License Manager can get subscription data from the registered
 * provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredSubscriptionProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredSubscriptionProvider.Builder, RegisteredSubscriptionProvider> {
    private static final SdkField<String> LAST_SUCCESSFUL_DATA_RETRIEVAL_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastSuccessfulDataRetrievalTime")
            .getter(getter(RegisteredSubscriptionProvider::lastSuccessfulDataRetrievalTime))
            .setter(setter(Builder::lastSuccessfulDataRetrievalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDataRetrievalTime")
                    .build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(RegisteredSubscriptionProvider::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderArn").getter(getter(RegisteredSubscriptionProvider::subscriptionProviderArn))
            .setter(setter(Builder::subscriptionProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderArn").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderSource")
            .getter(getter(RegisteredSubscriptionProvider::subscriptionProviderSourceAsString))
            .setter(setter(Builder::subscriptionProviderSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderSource").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderStatus")
            .getter(getter(RegisteredSubscriptionProvider::subscriptionProviderStatusAsString))
            .setter(setter(Builder::subscriptionProviderStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderStatus").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_PROVIDER_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionProviderStatusMessage")
            .getter(getter(RegisteredSubscriptionProvider::subscriptionProviderStatusMessage))
            .setter(setter(Builder::subscriptionProviderStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionProviderStatusMessage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAST_SUCCESSFUL_DATA_RETRIEVAL_TIME_FIELD, SECRET_ARN_FIELD, SUBSCRIPTION_PROVIDER_ARN_FIELD,
            SUBSCRIPTION_PROVIDER_SOURCE_FIELD, SUBSCRIPTION_PROVIDER_STATUS_FIELD, SUBSCRIPTION_PROVIDER_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lastSuccessfulDataRetrievalTime;

    private final String secretArn;

    private final String subscriptionProviderArn;

    private final String subscriptionProviderSource;

    private final String subscriptionProviderStatus;

    private final String subscriptionProviderStatusMessage;

    private RegisteredSubscriptionProvider(BuilderImpl builder) {
        this.lastSuccessfulDataRetrievalTime = builder.lastSuccessfulDataRetrievalTime;
        this.secretArn = builder.secretArn;
        this.subscriptionProviderArn = builder.subscriptionProviderArn;
        this.subscriptionProviderSource = builder.subscriptionProviderSource;
        this.subscriptionProviderStatus = builder.subscriptionProviderStatus;
        this.subscriptionProviderStatusMessage = builder.subscriptionProviderStatusMessage;
    }

    /**
     * <p>
     * The timestamp from the last time that License Manager accessed third-party subscription data for your account
     * from your registered Linux subscription provider.
     * </p>
     * 
     * @return The timestamp from the last time that License Manager accessed third-party subscription data for your
     *         account from your registered Linux subscription provider.
     */
    public final String lastSuccessfulDataRetrievalTime() {
        return lastSuccessfulDataRetrievalTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux subscription
     * provider access token. For RHEL account subscriptions, this is the offline token.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux
     *         subscription provider access token. For RHEL account subscriptions, this is the offline token.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
     */
    public final String subscriptionProviderArn() {
        return subscriptionProviderArn;
    }

    /**
     * <p>
     * A supported third-party Linux subscription provider. License Manager currently supports Red Hat subscriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderSource} will return {@link SubscriptionProviderSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderSourceAsString}.
     * </p>
     * 
     * @return A supported third-party Linux subscription provider. License Manager currently supports Red Hat
     *         subscriptions.
     * @see SubscriptionProviderSource
     */
    public final SubscriptionProviderSource subscriptionProviderSource() {
        return SubscriptionProviderSource.fromValue(subscriptionProviderSource);
    }

    /**
     * <p>
     * A supported third-party Linux subscription provider. License Manager currently supports Red Hat subscriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderSource} will return {@link SubscriptionProviderSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderSourceAsString}.
     * </p>
     * 
     * @return A supported third-party Linux subscription provider. License Manager currently supports Red Hat
     *         subscriptions.
     * @see SubscriptionProviderSource
     */
    public final String subscriptionProviderSourceAsString() {
        return subscriptionProviderSource;
    }

    /**
     * <p>
     * Indicates the status of your registered Linux subscription provider access token from the last time License
     * Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderStatus} will return {@link SubscriptionProviderStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of your registered Linux subscription provider access token from the last time
     *         License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the
     *         offline token.
     * @see SubscriptionProviderStatus
     */
    public final SubscriptionProviderStatus subscriptionProviderStatus() {
        return SubscriptionProviderStatus.fromValue(subscriptionProviderStatus);
    }

    /**
     * <p>
     * Indicates the status of your registered Linux subscription provider access token from the last time License
     * Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscriptionProviderStatus} will return {@link SubscriptionProviderStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #subscriptionProviderStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of your registered Linux subscription provider access token from the last time
     *         License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the
     *         offline token.
     * @see SubscriptionProviderStatus
     */
    public final String subscriptionProviderStatusAsString() {
        return subscriptionProviderStatus;
    }

    /**
     * <p>
     * A detailed message that's associated with your BYOL subscription provider token status.
     * </p>
     * 
     * @return A detailed message that's associated with your BYOL subscription provider token status.
     */
    public final String subscriptionProviderStatusMessage() {
        return subscriptionProviderStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDataRetrievalTime());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionProviderStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredSubscriptionProvider)) {
            return false;
        }
        RegisteredSubscriptionProvider other = (RegisteredSubscriptionProvider) obj;
        return Objects.equals(lastSuccessfulDataRetrievalTime(), other.lastSuccessfulDataRetrievalTime())
                && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(subscriptionProviderArn(), other.subscriptionProviderArn())
                && Objects.equals(subscriptionProviderSourceAsString(), other.subscriptionProviderSourceAsString())
                && Objects.equals(subscriptionProviderStatusAsString(), other.subscriptionProviderStatusAsString())
                && Objects.equals(subscriptionProviderStatusMessage(), other.subscriptionProviderStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredSubscriptionProvider")
                .add("LastSuccessfulDataRetrievalTime", lastSuccessfulDataRetrievalTime()).add("SecretArn", secretArn())
                .add("SubscriptionProviderArn", subscriptionProviderArn())
                .add("SubscriptionProviderSource", subscriptionProviderSourceAsString())
                .add("SubscriptionProviderStatus", subscriptionProviderStatusAsString())
                .add("SubscriptionProviderStatusMessage", subscriptionProviderStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastSuccessfulDataRetrievalTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDataRetrievalTime()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SubscriptionProviderArn":
            return Optional.ofNullable(clazz.cast(subscriptionProviderArn()));
        case "SubscriptionProviderSource":
            return Optional.ofNullable(clazz.cast(subscriptionProviderSourceAsString()));
        case "SubscriptionProviderStatus":
            return Optional.ofNullable(clazz.cast(subscriptionProviderStatusAsString()));
        case "SubscriptionProviderStatusMessage":
            return Optional.ofNullable(clazz.cast(subscriptionProviderStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastSuccessfulDataRetrievalTime", LAST_SUCCESSFUL_DATA_RETRIEVAL_TIME_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SubscriptionProviderArn", SUBSCRIPTION_PROVIDER_ARN_FIELD);
        map.put("SubscriptionProviderSource", SUBSCRIPTION_PROVIDER_SOURCE_FIELD);
        map.put("SubscriptionProviderStatus", SUBSCRIPTION_PROVIDER_STATUS_FIELD);
        map.put("SubscriptionProviderStatusMessage", SUBSCRIPTION_PROVIDER_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisteredSubscriptionProvider, T> g) {
        return obj -> g.apply((RegisteredSubscriptionProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredSubscriptionProvider> {
        /**
         * <p>
         * The timestamp from the last time that License Manager accessed third-party subscription data for your account
         * from your registered Linux subscription provider.
         * </p>
         * 
         * @param lastSuccessfulDataRetrievalTime
         *        The timestamp from the last time that License Manager accessed third-party subscription data for your
         *        account from your registered Linux subscription provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDataRetrievalTime(String lastSuccessfulDataRetrievalTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux subscription
         * provider access token. For RHEL account subscriptions, this is the offline token.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux
         *        subscription provider access token. For RHEL account subscriptions, this is the offline token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
         * </p>
         * 
         * @param subscriptionProviderArn
         *        The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderArn(String subscriptionProviderArn);

        /**
         * <p>
         * A supported third-party Linux subscription provider. License Manager currently supports Red Hat
         * subscriptions.
         * </p>
         * 
         * @param subscriptionProviderSource
         *        A supported third-party Linux subscription provider. License Manager currently supports Red Hat
         *        subscriptions.
         * @see SubscriptionProviderSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderSource
         */
        Builder subscriptionProviderSource(String subscriptionProviderSource);

        /**
         * <p>
         * A supported third-party Linux subscription provider. License Manager currently supports Red Hat
         * subscriptions.
         * </p>
         * 
         * @param subscriptionProviderSource
         *        A supported third-party Linux subscription provider. License Manager currently supports Red Hat
         *        subscriptions.
         * @see SubscriptionProviderSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderSource
         */
        Builder subscriptionProviderSource(SubscriptionProviderSource subscriptionProviderSource);

        /**
         * <p>
         * Indicates the status of your registered Linux subscription provider access token from the last time License
         * Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
         * </p>
         * 
         * @param subscriptionProviderStatus
         *        Indicates the status of your registered Linux subscription provider access token from the last time
         *        License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the
         *        offline token.
         * @see SubscriptionProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderStatus
         */
        Builder subscriptionProviderStatus(String subscriptionProviderStatus);

        /**
         * <p>
         * Indicates the status of your registered Linux subscription provider access token from the last time License
         * Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
         * </p>
         * 
         * @param subscriptionProviderStatus
         *        Indicates the status of your registered Linux subscription provider access token from the last time
         *        License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the
         *        offline token.
         * @see SubscriptionProviderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProviderStatus
         */
        Builder subscriptionProviderStatus(SubscriptionProviderStatus subscriptionProviderStatus);

        /**
         * <p>
         * A detailed message that's associated with your BYOL subscription provider token status.
         * </p>
         * 
         * @param subscriptionProviderStatusMessage
         *        A detailed message that's associated with your BYOL subscription provider token status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionProviderStatusMessage(String subscriptionProviderStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String lastSuccessfulDataRetrievalTime;

        private String secretArn;

        private String subscriptionProviderArn;

        private String subscriptionProviderSource;

        private String subscriptionProviderStatus;

        private String subscriptionProviderStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredSubscriptionProvider model) {
            lastSuccessfulDataRetrievalTime(model.lastSuccessfulDataRetrievalTime);
            secretArn(model.secretArn);
            subscriptionProviderArn(model.subscriptionProviderArn);
            subscriptionProviderSource(model.subscriptionProviderSource);
            subscriptionProviderStatus(model.subscriptionProviderStatus);
            subscriptionProviderStatusMessage(model.subscriptionProviderStatusMessage);
        }

        public final String getLastSuccessfulDataRetrievalTime() {
            return lastSuccessfulDataRetrievalTime;
        }

        public final void setLastSuccessfulDataRetrievalTime(String lastSuccessfulDataRetrievalTime) {
            this.lastSuccessfulDataRetrievalTime = lastSuccessfulDataRetrievalTime;
        }

        @Override
        public final Builder lastSuccessfulDataRetrievalTime(String lastSuccessfulDataRetrievalTime) {
            this.lastSuccessfulDataRetrievalTime = lastSuccessfulDataRetrievalTime;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSubscriptionProviderArn() {
            return subscriptionProviderArn;
        }

        public final void setSubscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
        }

        @Override
        public final Builder subscriptionProviderArn(String subscriptionProviderArn) {
            this.subscriptionProviderArn = subscriptionProviderArn;
            return this;
        }

        public final String getSubscriptionProviderSource() {
            return subscriptionProviderSource;
        }

        public final void setSubscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
        }

        @Override
        public final Builder subscriptionProviderSource(String subscriptionProviderSource) {
            this.subscriptionProviderSource = subscriptionProviderSource;
            return this;
        }

        @Override
        public final Builder subscriptionProviderSource(SubscriptionProviderSource subscriptionProviderSource) {
            this.subscriptionProviderSource(subscriptionProviderSource == null ? null : subscriptionProviderSource.toString());
            return this;
        }

        public final String getSubscriptionProviderStatus() {
            return subscriptionProviderStatus;
        }

        public final void setSubscriptionProviderStatus(String subscriptionProviderStatus) {
            this.subscriptionProviderStatus = subscriptionProviderStatus;
        }

        @Override
        public final Builder subscriptionProviderStatus(String subscriptionProviderStatus) {
            this.subscriptionProviderStatus = subscriptionProviderStatus;
            return this;
        }

        @Override
        public final Builder subscriptionProviderStatus(SubscriptionProviderStatus subscriptionProviderStatus) {
            this.subscriptionProviderStatus(subscriptionProviderStatus == null ? null : subscriptionProviderStatus.toString());
            return this;
        }

        public final String getSubscriptionProviderStatusMessage() {
            return subscriptionProviderStatusMessage;
        }

        public final void setSubscriptionProviderStatusMessage(String subscriptionProviderStatusMessage) {
            this.subscriptionProviderStatusMessage = subscriptionProviderStatusMessage;
        }

        @Override
        public final Builder subscriptionProviderStatusMessage(String subscriptionProviderStatusMessage) {
            this.subscriptionProviderStatusMessage = subscriptionProviderStatusMessage;
            return this;
        }

        @Override
        public RegisteredSubscriptionProvider build() {
            return new RegisteredSubscriptionProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
