/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityProvidersResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<ListIdentityProvidersResponse.Builder, ListIdentityProvidersResponse> {
    private static final SdkField<List<IdentityProviderSummary>> IDENTITY_PROVIDER_SUMMARIES_FIELD = SdkField
            .<List<IdentityProviderSummary>> builder(MarshallingType.LIST)
            .memberName("IdentityProviderSummaries")
            .getter(getter(ListIdentityProvidersResponse::identityProviderSummaries))
            .setter(setter(Builder::identityProviderSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityProviderSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityProviderSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentityProvidersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_PROVIDER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<IdentityProviderSummary> identityProviderSummaries;

    private final String nextToken;

    private ListIdentityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderSummaries = builder.identityProviderSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityProviderSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityProviderSummaries() {
        return identityProviderSummaries != null && !(identityProviderSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that describes the list identity providers operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityProviderSummaries} method.
     * </p>
     * 
     * @return Metadata that describes the list identity providers operation.
     */
    public final List<IdentityProviderSummary> identityProviderSummaries() {
        return identityProviderSummaries;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityProviderSummaries() ? identityProviderSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResponse)) {
            return false;
        }
        ListIdentityProvidersResponse other = (ListIdentityProvidersResponse) obj;
        return hasIdentityProviderSummaries() == other.hasIdentityProviderSummaries()
                && Objects.equals(identityProviderSummaries(), other.identityProviderSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentityProvidersResponse")
                .add("IdentityProviderSummaries", hasIdentityProviderSummaries() ? identityProviderSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderSummaries":
            return Optional.ofNullable(clazz.cast(identityProviderSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProvidersResponse, T> g) {
        return obj -> g.apply((ListIdentityProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentityProvidersResponse> {
        /**
         * <p>
         * Metadata that describes the list identity providers operation.
         * </p>
         * 
         * @param identityProviderSummaries
         *        Metadata that describes the list identity providers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderSummaries(Collection<IdentityProviderSummary> identityProviderSummaries);

        /**
         * <p>
         * Metadata that describes the list identity providers operation.
         * </p>
         * 
         * @param identityProviderSummaries
         *        Metadata that describes the list identity providers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderSummaries(IdentityProviderSummary... identityProviderSummaries);

        /**
         * <p>
         * Metadata that describes the list identity providers operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<IdentityProviderSummary>.Builder}
         * avoiding the need to create one manually via {@link List<IdentityProviderSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityProviderSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderSummaries(List<IdentityProviderSummary>)}.
         * 
         * @param identityProviderSummaries
         *        a consumer that will call methods on {@link List<IdentityProviderSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderSummaries(List<IdentityProviderSummary>)
         */
        Builder identityProviderSummaries(Consumer<IdentityProviderSummary.Builder>... identityProviderSummaries);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private List<IdentityProviderSummary> identityProviderSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProvidersResponse model) {
            super(model);
            identityProviderSummaries(model.identityProviderSummaries);
            nextToken(model.nextToken);
        }

        public final List<IdentityProviderSummary.Builder> getIdentityProviderSummaries() {
            List<IdentityProviderSummary.Builder> result = IdentityProviderSummaryListCopier
                    .copyToBuilder(this.identityProviderSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviderSummaries(Collection<IdentityProviderSummary.BuilderImpl> identityProviderSummaries) {
            this.identityProviderSummaries = IdentityProviderSummaryListCopier.copyFromBuilder(identityProviderSummaries);
        }

        @Override
        public final Builder identityProviderSummaries(Collection<IdentityProviderSummary> identityProviderSummaries) {
            this.identityProviderSummaries = IdentityProviderSummaryListCopier.copy(identityProviderSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderSummaries(IdentityProviderSummary... identityProviderSummaries) {
            identityProviderSummaries(Arrays.asList(identityProviderSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderSummaries(Consumer<IdentityProviderSummary.Builder>... identityProviderSummaries) {
            identityProviderSummaries(Stream.of(identityProviderSummaries)
                    .map(c -> IdentityProviderSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
