/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse;

public class ListIdentityProvidersPublisher
implements SdkPublisher<ListIdentityProvidersResponse> {
    private final LicenseManagerUserSubscriptionsAsyncClient client;
    private final ListIdentityProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentityProvidersPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListIdentityProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentityProvidersPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListIdentityProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentityProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentityProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdentityProviderSummary> identityProviderSummaries() {
        Function<ListIdentityProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.identityProviderSummaries() != null) {
                return response.identityProviderSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdentityProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdentityProvidersResponseFetcher
    implements AsyncPageFetcher<ListIdentityProvidersResponse> {
        private ListIdentityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentityProvidersResponse> nextPage(ListIdentityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProvidersPublisher.this.client.listIdentityProviders(ListIdentityProvidersPublisher.this.firstRequest);
            }
            return ListIdentityProvidersPublisher.this.client.listIdentityProviders((ListIdentityProvidersRequest)((Object)ListIdentityProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

