/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher;

/**
 * Service client for accessing AWS License Manager User Subscriptions asynchronously. This can be created using the
 * static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * With License Manager, you can create user-based subscriptions to utilize licensed software with a per user
 * subscription fee on Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerUserSubscriptionsAsyncClient extends AwsClient {
    String SERVICE_NAME = "license-manager-user-subscriptions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager-user-subscriptions";

    /**
     * <p>
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note>
     *
     * @param associateUserRequest
     * @return A Java Future containing the result of the AssociateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.AssociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserResponse> associateUser(AssociateUserRequest associateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateUserRequest#builder()}
     * </p>
     *
     * @param associateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.AssociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserResponse> associateUser(Consumer<AssociateUserRequest.Builder> associateUserRequest) {
        return associateUser(AssociateUserRequest.builder().applyMutation(associateUserRequest).build());
    }

    /**
     * <p>
     * Deregisters the identity provider from providing user-based subscriptions.
     * </p>
     *
     * @param deregisterIdentityProviderRequest
     * @return A Java Future containing the result of the DeregisterIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.DeregisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterIdentityProviderResponse> deregisterIdentityProvider(
            DeregisterIdentityProviderRequest deregisterIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the identity provider from providing user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deregisterIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.DeregisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterIdentityProviderResponse> deregisterIdentityProvider(
            Consumer<DeregisterIdentityProviderRequest.Builder> deregisterIdentityProviderRequest) {
        return deregisterIdentityProvider(DeregisterIdentityProviderRequest.builder()
                .applyMutation(deregisterIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     * </p>
     *
     * @param disassociateUserRequest
     * @return A Java Future containing the result of the DisassociateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.DisassociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserResponse> disassociateUser(DisassociateUserRequest disassociateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateUserRequest#builder()}
     * </p>
     *
     * @param disassociateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.DisassociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserResponse> disassociateUser(
            Consumer<DisassociateUserRequest.Builder> disassociateUserRequest) {
        return disassociateUser(DisassociateUserRequest.builder().applyMutation(disassociateUserRequest).build());
    }

    /**
     * <p>
     * Lists the identity providers for user-based subscriptions.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the identity providers for user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        return new ListIdentityProvidersPublisher(this, listIdentityProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the EC2 instances providing user-based subscriptions.
     * </p>
     *
     * @param listInstancesRequest
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the EC2 instances providing user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        return new ListInstancesPublisher(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the user-based subscription products available from an identity provider.
     * </p>
     *
     * @param listProductSubscriptionsRequest
     * @return A Java Future containing the result of the ListProductSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProductSubscriptionsResponse> listProductSubscriptions(
            ListProductSubscriptionsRequest listProductSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user-based subscription products available from an identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProductSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProductSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listProductSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListProductSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProductSubscriptionsResponse> listProductSubscriptions(
            Consumer<ListProductSubscriptionsRequest.Builder> listProductSubscriptionsRequest) {
        return listProductSubscriptions(ListProductSubscriptionsRequest.builder().applyMutation(listProductSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher publisher = client.listProductSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher publisher = client.listProductSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProductSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsPublisher listProductSubscriptionsPaginator(
            ListProductSubscriptionsRequest listProductSubscriptionsRequest) {
        return new ListProductSubscriptionsPublisher(this, listProductSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher publisher = client.listProductSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher publisher = client.listProductSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProductSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProductSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listProductSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsPublisher listProductSubscriptionsPaginator(
            Consumer<ListProductSubscriptionsRequest.Builder> listProductSubscriptionsRequest) {
        return listProductSubscriptionsPaginator(ListProductSubscriptionsRequest.builder()
                .applyMutation(listProductSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists user associations for an identity provider.
     * </p>
     *
     * @param listUserAssociationsRequest
     * @return A Java Future containing the result of the ListUserAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserAssociationsResponse> listUserAssociations(
            ListUserAssociationsRequest listUserAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists user associations for an identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserAssociationsRequest#builder()}
     * </p>
     *
     * @param listUserAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListUserAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserAssociationsResponse> listUserAssociations(
            Consumer<ListUserAssociationsRequest.Builder> listUserAssociationsRequest) {
        return listUserAssociations(ListUserAssociationsRequest.builder().applyMutation(listUserAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher publisher = client.listUserAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher publisher = client.listUserAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsPublisher listUserAssociationsPaginator(ListUserAssociationsRequest listUserAssociationsRequest) {
        return new ListUserAssociationsPublisher(this, listUserAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher publisher = client.listUserAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher publisher = client.listUserAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserAssociationsRequest#builder()}
     * </p>
     *
     * @param listUserAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsPublisher listUserAssociationsPaginator(
            Consumer<ListUserAssociationsRequest.Builder> listUserAssociationsRequest) {
        return listUserAssociationsPaginator(ListUserAssociationsRequest.builder().applyMutation(listUserAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Registers an identity provider for user-based subscriptions.
     * </p>
     *
     * @param registerIdentityProviderRequest
     * @return A Java Future containing the result of the RegisterIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.RegisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterIdentityProviderResponse> registerIdentityProvider(
            RegisterIdentityProviderRequest registerIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an identity provider for user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterIdentityProviderRequest#builder()}
     * </p>
     *
     * @param registerIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RegisterIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.RegisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterIdentityProviderResponse> registerIdentityProvider(
            Consumer<RegisterIdentityProviderRequest.Builder> registerIdentityProviderRequest) {
        return registerIdentityProvider(RegisterIdentityProviderRequest.builder().applyMutation(registerIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Starts a product subscription for a user with the specified identity provider.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note>
     *
     * @param startProductSubscriptionRequest
     * @return A Java Future containing the result of the StartProductSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.StartProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartProductSubscriptionResponse> startProductSubscription(
            StartProductSubscriptionRequest startProductSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a product subscription for a user with the specified identity provider.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartProductSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link StartProductSubscriptionRequest#builder()}
     * </p>
     *
     * @param startProductSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartProductSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.StartProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartProductSubscriptionResponse> startProductSubscription(
            Consumer<StartProductSubscriptionRequest.Builder> startProductSubscriptionRequest) {
        return startProductSubscription(StartProductSubscriptionRequest.builder().applyMutation(startProductSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Stops a product subscription for a user with the specified identity provider.
     * </p>
     *
     * @param stopProductSubscriptionRequest
     * @return A Java Future containing the result of the StopProductSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.StopProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopProductSubscriptionResponse> stopProductSubscription(
            StopProductSubscriptionRequest stopProductSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a product subscription for a user with the specified identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopProductSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link StopProductSubscriptionRequest#builder()}
     * </p>
     *
     * @param stopProductSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StopProductSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request failed because a service quota is exceeded.</li>
     *         <li>ConflictException The request couldn't be completed because it conflicted with the current state of
     *         the resource.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>ResourceNotFoundException The resource couldn't be found.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.StopProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopProductSubscriptionResponse> stopProductSubscription(
            Consumer<StopProductSubscriptionRequest.Builder> stopProductSubscriptionRequest) {
        return stopProductSubscription(StopProductSubscriptionRequest.builder().applyMutation(stopProductSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Updates additional product configuration settings for the registered identity provider.
     * </p>
     *
     * @param updateIdentityProviderSettingsRequest
     * @return A Java Future containing the result of the UpdateIdentityProviderSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.UpdateIdentityProviderSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderSettingsResponse> updateIdentityProviderSettings(
            UpdateIdentityProviderSettingsRequest updateIdentityProviderSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates additional product configuration settings for the registered identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateIdentityProviderSettingsRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateIdentityProviderSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>InternalServerException An exception occurred with the service.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LicenseManagerUserSubscriptionsException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample LicenseManagerUserSubscriptionsAsyncClient.UpdateIdentityProviderSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderSettingsResponse> updateIdentityProviderSettings(
            Consumer<UpdateIdentityProviderSettingsRequest.Builder> updateIdentityProviderSettingsRequest) {
        return updateIdentityProviderSettings(UpdateIdentityProviderSettingsRequest.builder()
                .applyMutation(updateIdentityProviderSettingsRequest).build());
    }

    @Override
    default LicenseManagerUserSubscriptionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LicenseManagerUserSubscriptionsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerUserSubscriptionsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerUserSubscriptionsAsyncClient}.
     */
    static LicenseManagerUserSubscriptionsAsyncClientBuilder builder() {
        return new DefaultLicenseManagerUserSubscriptionsAsyncClientBuilder();
    }
}
