/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ConflictException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.CreateLicenseServerEndpointRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.CreateLicenseServerEndpointResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeleteLicenseServerEndpointRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeleteLicenseServerEndpointResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InternalServerException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ThrottlingException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ValidationException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable;

/**
 * Service client for accessing AWS License Manager User Subscriptions. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * With License Manager, you can create user-based subscriptions to utilize licensed software with a per user
 * subscription fee on Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerUserSubscriptionsClient extends AwsClient {
    String SERVICE_NAME = "license-manager-user-subscriptions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager-user-subscriptions";

    /**
     * <p>
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note>
     *
     * @param associateUserRequest
     * @return Result of the AssociateUser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.AssociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserResponse associateUser(AssociateUserRequest associateUserRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateUserRequest#builder()}
     * </p>
     *
     * @param associateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateUser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.AssociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserResponse associateUser(Consumer<AssociateUserRequest.Builder> associateUserRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return associateUser(AssociateUserRequest.builder().applyMutation(associateUserRequest).build());
    }

    /**
     * <p>
     * Creates a network endpoint for the Remote Desktop Services (RDS) license server.
     * </p>
     *
     * @param createLicenseServerEndpointRequest
     * @return Result of the CreateLicenseServerEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.CreateLicenseServerEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/CreateLicenseServerEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseServerEndpointResponse createLicenseServerEndpoint(
            CreateLicenseServerEndpointRequest createLicenseServerEndpointRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network endpoint for the Remote Desktop Services (RDS) license server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLicenseServerEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLicenseServerEndpointRequest#builder()}
     * </p>
     *
     * @param createLicenseServerEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.CreateLicenseServerEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the CreateLicenseServerEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.CreateLicenseServerEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/CreateLicenseServerEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLicenseServerEndpointResponse createLicenseServerEndpoint(
            Consumer<CreateLicenseServerEndpointRequest.Builder> createLicenseServerEndpointRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return createLicenseServerEndpoint(CreateLicenseServerEndpointRequest.builder()
                .applyMutation(createLicenseServerEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>LicenseServerEndpoint</code> resource.
     * </p>
     *
     * @param deleteLicenseServerEndpointRequest
     * @return Result of the DeleteLicenseServerEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DeleteLicenseServerEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeleteLicenseServerEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseServerEndpointResponse deleteLicenseServerEndpoint(
            DeleteLicenseServerEndpointRequest deleteLicenseServerEndpointRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>LicenseServerEndpoint</code> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLicenseServerEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLicenseServerEndpointRequest#builder()}
     * </p>
     *
     * @param deleteLicenseServerEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeleteLicenseServerEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteLicenseServerEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DeleteLicenseServerEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeleteLicenseServerEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLicenseServerEndpointResponse deleteLicenseServerEndpoint(
            Consumer<DeleteLicenseServerEndpointRequest.Builder> deleteLicenseServerEndpointRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return deleteLicenseServerEndpoint(DeleteLicenseServerEndpointRequest.builder()
                .applyMutation(deleteLicenseServerEndpointRequest).build());
    }

    /**
     * <p>
     * Deregisters the Active Directory identity provider from License Manager user-based subscriptions.
     * </p>
     *
     * @param deregisterIdentityProviderRequest
     * @return Result of the DeregisterIdentityProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DeregisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterIdentityProviderResponse deregisterIdentityProvider(
            DeregisterIdentityProviderRequest deregisterIdentityProviderRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the Active Directory identity provider from License Manager user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deregisterIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest.Builder}
     *        to create a request.
     * @return Result of the DeregisterIdentityProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DeregisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterIdentityProviderResponse deregisterIdentityProvider(
            Consumer<DeregisterIdentityProviderRequest.Builder> deregisterIdentityProviderRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return deregisterIdentityProvider(DeregisterIdentityProviderRequest.builder()
                .applyMutation(deregisterIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     * </p>
     *
     * @param disassociateUserRequest
     * @return Result of the DisassociateUser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DisassociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserResponse disassociateUser(DisassociateUserRequest disassociateUserRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateUserRequest#builder()}
     * </p>
     *
     * @param disassociateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateUser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.DisassociateUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserResponse disassociateUser(Consumer<DisassociateUserRequest.Builder> disassociateUserRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return disassociateUser(DisassociateUserRequest.builder().applyMutation(disassociateUserRequest).build());
    }

    /**
     * <p>
     * Lists the Active Directory identity providers for user-based subscriptions.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Active Directory identity providers for user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return new ListIdentityProvidersIterable(this, listIdentityProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListIdentityProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the EC2 instances providing user-based subscriptions.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the EC2 instances providing user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest.Builder}
     *        to create a request.
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client
     *             .listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return new ListInstancesIterable(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client
     *             .listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * List the Remote Desktop Services (RDS) License Server endpoints
     * </p>
     *
     * @param listLicenseServerEndpointsRequest
     * @return Result of the ListLicenseServerEndpoints operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListLicenseServerEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListLicenseServerEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseServerEndpointsResponse listLicenseServerEndpoints(
            ListLicenseServerEndpointsRequest listLicenseServerEndpointsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the Remote Desktop Services (RDS) License Server endpoints
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseServerEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseServerEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseServerEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest.Builder}
     *        to create a request.
     * @return Result of the ListLicenseServerEndpoints operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListLicenseServerEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListLicenseServerEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseServerEndpointsResponse listLicenseServerEndpoints(
            Consumer<ListLicenseServerEndpointsRequest.Builder> listLicenseServerEndpointsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listLicenseServerEndpoints(ListLicenseServerEndpointsRequest.builder()
                .applyMutation(listLicenseServerEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseServerEndpoints(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client.listLicenseServerEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client
     *             .listLicenseServerEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client.listLicenseServerEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseServerEndpoints(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLicenseServerEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListLicenseServerEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListLicenseServerEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseServerEndpointsIterable listLicenseServerEndpointsPaginator(
            ListLicenseServerEndpointsRequest listLicenseServerEndpointsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListLicenseServerEndpointsIterable(this, listLicenseServerEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLicenseServerEndpoints(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client.listLicenseServerEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client
     *             .listLicenseServerEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListLicenseServerEndpointsIterable responses = client.listLicenseServerEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLicenseServerEndpoints(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLicenseServerEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLicenseServerEndpointsRequest#builder()}
     * </p>
     *
     * @param listLicenseServerEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListLicenseServerEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListLicenseServerEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLicenseServerEndpointsIterable listLicenseServerEndpointsPaginator(
            Consumer<ListLicenseServerEndpointsRequest.Builder> listLicenseServerEndpointsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listLicenseServerEndpointsPaginator(ListLicenseServerEndpointsRequest.builder()
                .applyMutation(listLicenseServerEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists the user-based subscription products available from an identity provider.
     * </p>
     *
     * @param listProductSubscriptionsRequest
     * @return Result of the ListProductSubscriptions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsResponse listProductSubscriptions(
            ListProductSubscriptionsRequest listProductSubscriptionsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user-based subscription products available from an identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProductSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProductSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listProductSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListProductSubscriptions operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsResponse listProductSubscriptions(
            Consumer<ListProductSubscriptionsRequest.Builder> listProductSubscriptionsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listProductSubscriptions(ListProductSubscriptionsRequest.builder().applyMutation(listProductSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client.listProductSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client
     *             .listProductSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client.listProductSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProductSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsIterable listProductSubscriptionsPaginator(
            ListProductSubscriptionsRequest listProductSubscriptionsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return new ListProductSubscriptionsIterable(this, listProductSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client.listProductSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client
     *             .listProductSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsIterable responses = client.listProductSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProductSubscriptions(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProductSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProductSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listProductSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListProductSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProductSubscriptionsIterable listProductSubscriptionsPaginator(
            Consumer<ListProductSubscriptionsRequest.Builder> listProductSubscriptionsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listProductSubscriptionsPaginator(ListProductSubscriptionsRequest.builder()
                .applyMutation(listProductSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListTagsForResourceRequest.Builder}
     *        to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListTagsForResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists user associations for an identity provider.
     * </p>
     *
     * @param listUserAssociationsRequest
     * @return Result of the ListUserAssociations operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsResponse listUserAssociations(ListUserAssociationsRequest listUserAssociationsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists user associations for an identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserAssociationsRequest#builder()}
     * </p>
     *
     * @param listUserAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListUserAssociations operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsResponse listUserAssociations(
            Consumer<ListUserAssociationsRequest.Builder> listUserAssociationsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return listUserAssociations(ListUserAssociationsRequest.builder().applyMutation(listUserAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client.listUserAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client
     *             .listUserAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client.listUserAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsIterable listUserAssociationsPaginator(ListUserAssociationsRequest listUserAssociationsRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return new ListUserAssociationsIterable(this, listUserAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client.listUserAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client
     *             .listUserAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsIterable responses = client.listUserAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAssociations(software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserAssociationsRequest#builder()}
     * </p>
     *
     * @param listUserAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.ListUserAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAssociationsIterable listUserAssociationsPaginator(
            Consumer<ListUserAssociationsRequest.Builder> listUserAssociationsRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        return listUserAssociationsPaginator(ListUserAssociationsRequest.builder().applyMutation(listUserAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Registers an identity provider for user-based subscriptions.
     * </p>
     *
     * @param registerIdentityProviderRequest
     * @return Result of the RegisterIdentityProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.RegisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterIdentityProviderResponse registerIdentityProvider(
            RegisterIdentityProviderRequest registerIdentityProviderRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an identity provider for user-based subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterIdentityProviderRequest#builder()}
     * </p>
     *
     * @param registerIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest.Builder}
     *        to create a request.
     * @return Result of the RegisterIdentityProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.RegisterIdentityProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterIdentityProviderResponse registerIdentityProvider(
            Consumer<RegisterIdentityProviderRequest.Builder> registerIdentityProviderRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return registerIdentityProvider(RegisterIdentityProviderRequest.builder().applyMutation(registerIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Starts a product subscription for a user with the specified identity provider.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note>
     *
     * @param startProductSubscriptionRequest
     * @return Result of the StartProductSubscription operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.StartProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default StartProductSubscriptionResponse startProductSubscription(
            StartProductSubscriptionRequest startProductSubscriptionRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a product subscription for a user with the specified identity provider.
     * </p>
     * <note>
     * <p>
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing
     * periods that haven't closed (marked as <b>Pending</b> billing status) in Amazon Web Services Billing. For more
     * information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html">Viewing your
     * monthly charges</a> in the <i>Amazon Web Services Billing User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartProductSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link StartProductSubscriptionRequest#builder()}
     * </p>
     *
     * @param startProductSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest.Builder}
     *        to create a request.
     * @return Result of the StartProductSubscription operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.StartProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default StartProductSubscriptionResponse startProductSubscription(
            Consumer<StartProductSubscriptionRequest.Builder> startProductSubscriptionRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return startProductSubscription(StartProductSubscriptionRequest.builder().applyMutation(startProductSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Stops a product subscription for a user with the specified identity provider.
     * </p>
     *
     * @param stopProductSubscriptionRequest
     * @return Result of the StopProductSubscription operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.StopProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default StopProductSubscriptionResponse stopProductSubscription(StopProductSubscriptionRequest stopProductSubscriptionRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a product subscription for a user with the specified identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopProductSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link StopProductSubscriptionRequest#builder()}
     * </p>
     *
     * @param stopProductSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest.Builder}
     *        to create a request.
     * @return Result of the StopProductSubscription operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws ConflictException
     *         The request couldn't be completed because it conflicted with the current state of the resource.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.StopProductSubscription
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default StopProductSubscriptionResponse stopProductSubscription(
            Consumer<StopProductSubscriptionRequest.Builder> stopProductSubscriptionRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return stopProductSubscription(StopProductSubscriptionRequest.builder().applyMutation(stopProductSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.TagResourceRequest.Builder}
     *        to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.UntagResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UntagResourceRequest.Builder}
     *        to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ResourceNotFoundException
     *         The resource couldn't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.UntagResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates additional product configuration settings for the registered identity provider.
     * </p>
     *
     * @param updateIdentityProviderSettingsRequest
     * @return Result of the UpdateIdentityProviderSettings operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.UpdateIdentityProviderSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderSettingsResponse updateIdentityProviderSettings(
            UpdateIdentityProviderSettingsRequest updateIdentityProviderSettingsRequest) throws ValidationException,
            ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            LicenseManagerUserSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates additional product configuration settings for the registered identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateIdentityProviderSettingsRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateIdentityProviderSettings operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerUserSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerUserSubscriptionsClient.UpdateIdentityProviderSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderSettingsResponse updateIdentityProviderSettings(
            Consumer<UpdateIdentityProviderSettingsRequest.Builder> updateIdentityProviderSettingsRequest)
            throws ValidationException, ThrottlingException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, LicenseManagerUserSubscriptionsException {
        return updateIdentityProviderSettings(UpdateIdentityProviderSettingsRequest.builder()
                .applyMutation(updateIdentityProviderSettingsRequest).build());
    }

    /**
     * Create a {@link LicenseManagerUserSubscriptionsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerUserSubscriptionsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerUserSubscriptionsClient}.
     */
    static LicenseManagerUserSubscriptionsClientBuilder builder() {
        return new DefaultLicenseManagerUserSubscriptionsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LicenseManagerUserSubscriptionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
