/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseServerEndpointRequest extends LicenseManagerUserSubscriptionsRequest implements
        ToCopyableBuilder<CreateLicenseServerEndpointRequest.Builder, CreateLicenseServerEndpointRequest> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderArn").getter(getter(CreateLicenseServerEndpointRequest::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build())
            .build();

    private static final SdkField<LicenseServerSettings> LICENSE_SERVER_SETTINGS_FIELD = SdkField
            .<LicenseServerSettings> builder(MarshallingType.SDK_POJO).memberName("LicenseServerSettings")
            .getter(getter(CreateLicenseServerEndpointRequest::licenseServerSettings))
            .setter(setter(Builder::licenseServerSettings)).constructor(LicenseServerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerSettings").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateLicenseServerEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD,
            LICENSE_SERVER_SETTINGS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityProviderArn;

    private final LicenseServerSettings licenseServerSettings;

    private final Map<String, String> tags;

    private CreateLicenseServerEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.identityProviderArn = builder.identityProviderArn;
        this.licenseServerSettings = builder.licenseServerSettings;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the <code>IdentityProvider</code> resource that contains details
     * about a registered identity provider. In the case of Active Directory, that can be a self-managed Active
     * Directory or an Amazon Web Services Managed Active Directory that contains user identity details.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the <code>IdentityProvider</code> resource that contains
     *         details about a registered identity provider. In the case of Active Directory, that can be a self-managed
     *         Active Directory or an Amazon Web Services Managed Active Directory that contains user identity details.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * <p>
     * The <code>LicenseServerSettings</code> resource to create for the endpoint. The settings include the type of
     * license server and the Secrets Manager secret that enables administrators to add or remove users associated with
     * the license server.
     * </p>
     * 
     * @return The <code>LicenseServerSettings</code> resource to create for the endpoint. The settings include the type
     *         of license server and the Secrets Manager secret that enables administrators to add or remove users
     *         associated with the license server.
     */
    public final LicenseServerSettings licenseServerSettings() {
        return licenseServerSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that apply for the license server endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that apply for the license server endpoint.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseServerEndpointRequest)) {
            return false;
        }
        CreateLicenseServerEndpointRequest other = (CreateLicenseServerEndpointRequest) obj;
        return Objects.equals(identityProviderArn(), other.identityProviderArn())
                && Objects.equals(licenseServerSettings(), other.licenseServerSettings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseServerEndpointRequest").add("IdentityProviderArn", identityProviderArn())
                .add("LicenseServerSettings", licenseServerSettings())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "LicenseServerSettings":
            return Optional.ofNullable(clazz.cast(licenseServerSettings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("LicenseServerSettings", LICENSE_SERVER_SETTINGS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseServerEndpointRequest, T> g) {
        return obj -> g.apply((CreateLicenseServerEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseServerEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the <code>IdentityProvider</code> resource that contains
         * details about a registered identity provider. In the case of Active Directory, that can be a self-managed
         * Active Directory or an Amazon Web Services Managed Active Directory that contains user identity details.
         * </p>
         * 
         * @param identityProviderArn
         *        The Amazon Resource Name (ARN) that identifies the <code>IdentityProvider</code> resource that
         *        contains details about a registered identity provider. In the case of Active Directory, that can be a
         *        self-managed Active Directory or an Amazon Web Services Managed Active Directory that contains user
         *        identity details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The <code>LicenseServerSettings</code> resource to create for the endpoint. The settings include the type of
         * license server and the Secrets Manager secret that enables administrators to add or remove users associated
         * with the license server.
         * </p>
         * 
         * @param licenseServerSettings
         *        The <code>LicenseServerSettings</code> resource to create for the endpoint. The settings include the
         *        type of license server and the Secrets Manager secret that enables administrators to add or remove
         *        users associated with the license server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerSettings(LicenseServerSettings licenseServerSettings);

        /**
         * <p>
         * The <code>LicenseServerSettings</code> resource to create for the endpoint. The settings include the type of
         * license server and the Secrets Manager secret that enables administrators to add or remove users associated
         * with the license server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LicenseServerSettings.Builder} avoiding
         * the need to create one manually via {@link LicenseServerSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LicenseServerSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #licenseServerSettings(LicenseServerSettings)}.
         * 
         * @param licenseServerSettings
         *        a consumer that will call methods on {@link LicenseServerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseServerSettings(LicenseServerSettings)
         */
        default Builder licenseServerSettings(Consumer<LicenseServerSettings.Builder> licenseServerSettings) {
            return licenseServerSettings(LicenseServerSettings.builder().applyMutation(licenseServerSettings).build());
        }

        /**
         * <p>
         * The tags that apply for the license server endpoint.
         * </p>
         * 
         * @param tags
         *        The tags that apply for the license server endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsRequest.BuilderImpl implements Builder {
        private String identityProviderArn;

        private LicenseServerSettings licenseServerSettings;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseServerEndpointRequest model) {
            super(model);
            identityProviderArn(model.identityProviderArn);
            licenseServerSettings(model.licenseServerSettings);
            tags(model.tags);
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final LicenseServerSettings.Builder getLicenseServerSettings() {
            return licenseServerSettings != null ? licenseServerSettings.toBuilder() : null;
        }

        public final void setLicenseServerSettings(LicenseServerSettings.BuilderImpl licenseServerSettings) {
            this.licenseServerSettings = licenseServerSettings != null ? licenseServerSettings.build() : null;
        }

        @Override
        public final Builder licenseServerSettings(LicenseServerSettings licenseServerSettings) {
            this.licenseServerSettings = licenseServerSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseServerEndpointRequest build() {
            return new CreateLicenseServerEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
