/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the credential provider for user administration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CredentialsProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CredentialsProvider.Builder, CredentialsProvider> {
    private static final SdkField<SecretsManagerCredentialsProvider> SECRETS_MANAGER_CREDENTIALS_PROVIDER_FIELD = SdkField
            .<SecretsManagerCredentialsProvider> builder(MarshallingType.SDK_POJO)
            .memberName("SecretsManagerCredentialsProvider")
            .getter(getter(CredentialsProvider::secretsManagerCredentialsProvider))
            .setter(setter(Builder::secretsManagerCredentialsProvider))
            .constructor(SecretsManagerCredentialsProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerCredentialsProvider")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SECRETS_MANAGER_CREDENTIALS_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SecretsManagerCredentialsProvider secretsManagerCredentialsProvider;

    private final Type type;

    private CredentialsProvider(BuilderImpl builder) {
        this.secretsManagerCredentialsProvider = builder.secretsManagerCredentialsProvider;
        this.type = builder.type;
    }

    /**
     * <p>
     * Identifies the Secrets Manager secret that contains credentials needed for user administration in the Active
     * Directory.
     * </p>
     * 
     * @return Identifies the Secrets Manager secret that contains credentials needed for user administration in the
     *         Active Directory.
     */
    public final SecretsManagerCredentialsProvider secretsManagerCredentialsProvider() {
        return secretsManagerCredentialsProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerCredentialsProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialsProvider)) {
            return false;
        }
        CredentialsProvider other = (CredentialsProvider) obj;
        return Objects.equals(secretsManagerCredentialsProvider(), other.secretsManagerCredentialsProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CredentialsProvider")
                .add("SecretsManagerCredentialsProvider", secretsManagerCredentialsProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretsManagerCredentialsProvider":
            return Optional.ofNullable(clazz.cast(secretsManagerCredentialsProvider()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #secretsManagerCredentialsProvider()} initialized to the given
     * value.
     *
     * <p>
     * Identifies the Secrets Manager secret that contains credentials needed for user administration in the Active
     * Directory.
     * </p>
     * 
     * @param secretsManagerCredentialsProvider
     *        Identifies the Secrets Manager secret that contains credentials needed for user administration in the
     *        Active Directory.
     */
    public static CredentialsProvider fromSecretsManagerCredentialsProvider(
            SecretsManagerCredentialsProvider secretsManagerCredentialsProvider) {
        return builder().secretsManagerCredentialsProvider(secretsManagerCredentialsProvider).build();
    }

    /**
     * Create an instance of this class with {@link #secretsManagerCredentialsProvider()} initialized to the given
     * value.
     *
     * <p>
     * Identifies the Secrets Manager secret that contains credentials needed for user administration in the Active
     * Directory.
     * </p>
     * 
     * @param secretsManagerCredentialsProvider
     *        Identifies the Secrets Manager secret that contains credentials needed for user administration in the
     *        Active Directory.
     */
    public static CredentialsProvider fromSecretsManagerCredentialsProvider(
            Consumer<SecretsManagerCredentialsProvider.Builder> secretsManagerCredentialsProvider) {
        SecretsManagerCredentialsProvider.Builder builder = SecretsManagerCredentialsProvider.builder();
        secretsManagerCredentialsProvider.accept(builder);
        return fromSecretsManagerCredentialsProvider(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretsManagerCredentialsProvider", SECRETS_MANAGER_CREDENTIALS_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialsProvider, T> g) {
        return obj -> g.apply((CredentialsProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CredentialsProvider> {
        /**
         * <p>
         * Identifies the Secrets Manager secret that contains credentials needed for user administration in the Active
         * Directory.
         * </p>
         * 
         * @param secretsManagerCredentialsProvider
         *        Identifies the Secrets Manager secret that contains credentials needed for user administration in the
         *        Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerCredentialsProvider(SecretsManagerCredentialsProvider secretsManagerCredentialsProvider);

        /**
         * <p>
         * Identifies the Secrets Manager secret that contains credentials needed for user administration in the Active
         * Directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerCredentialsProvider.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerCredentialsProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerCredentialsProvider.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #secretsManagerCredentialsProvider(SecretsManagerCredentialsProvider)}.
         * 
         * @param secretsManagerCredentialsProvider
         *        a consumer that will call methods on {@link SecretsManagerCredentialsProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerCredentialsProvider(SecretsManagerCredentialsProvider)
         */
        default Builder secretsManagerCredentialsProvider(
                Consumer<SecretsManagerCredentialsProvider.Builder> secretsManagerCredentialsProvider) {
            return secretsManagerCredentialsProvider(SecretsManagerCredentialsProvider.builder()
                    .applyMutation(secretsManagerCredentialsProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SecretsManagerCredentialsProvider secretsManagerCredentialsProvider;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialsProvider model) {
            secretsManagerCredentialsProvider(model.secretsManagerCredentialsProvider);
        }

        public final SecretsManagerCredentialsProvider.Builder getSecretsManagerCredentialsProvider() {
            return secretsManagerCredentialsProvider != null ? secretsManagerCredentialsProvider.toBuilder() : null;
        }

        public final void setSecretsManagerCredentialsProvider(
                SecretsManagerCredentialsProvider.BuilderImpl secretsManagerCredentialsProvider) {
            Object oldValue = this.secretsManagerCredentialsProvider;
            this.secretsManagerCredentialsProvider = secretsManagerCredentialsProvider != null ? secretsManagerCredentialsProvider
                    .build() : null;
            handleUnionValueChange(Type.SECRETS_MANAGER_CREDENTIALS_PROVIDER, oldValue, this.secretsManagerCredentialsProvider);
        }

        @Override
        public final Builder secretsManagerCredentialsProvider(SecretsManagerCredentialsProvider secretsManagerCredentialsProvider) {
            Object oldValue = this.secretsManagerCredentialsProvider;
            this.secretsManagerCredentialsProvider = secretsManagerCredentialsProvider;
            handleUnionValueChange(Type.SECRETS_MANAGER_CREDENTIALS_PROVIDER, oldValue, this.secretsManagerCredentialsProvider);
            return this;
        }

        @Override
        public CredentialsProvider build() {
            return new CredentialsProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CredentialsProvider#type()
     */
    public enum Type {
        SECRETS_MANAGER_CREDENTIALS_PROVIDER,

        UNKNOWN_TO_SDK_VERSION
    }
}
