/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes users of an EC2 instance providing user-based subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceUserSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceUserSummary.Builder, InstanceUserSummary> {
    private static final SdkField<String> ASSOCIATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationDate").getter(getter(InstanceUserSummary::associationDate))
            .setter(setter(Builder::associationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDate").build()).build();

    private static final SdkField<String> DISASSOCIATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisassociationDate").getter(getter(InstanceUserSummary::disassociationDate))
            .setter(setter(Builder::disassociationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociationDate").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(InstanceUserSummary::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(InstanceUserSummary::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceUserSummary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceUserArn").getter(getter(InstanceUserSummary::instanceUserArn))
            .setter(setter(Builder::instanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceUserArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InstanceUserSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(InstanceUserSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(InstanceUserSummary::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_DATE_FIELD,
            DISASSOCIATION_DATE_FIELD, DOMAIN_FIELD, IDENTITY_PROVIDER_FIELD, INSTANCE_ID_FIELD, INSTANCE_USER_ARN_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationDate;

    private final String disassociationDate;

    private final String domain;

    private final IdentityProvider identityProvider;

    private final String instanceId;

    private final String instanceUserArn;

    private final String status;

    private final String statusMessage;

    private final String username;

    private InstanceUserSummary(BuilderImpl builder) {
        this.associationDate = builder.associationDate;
        this.disassociationDate = builder.disassociationDate;
        this.domain = builder.domain;
        this.identityProvider = builder.identityProvider;
        this.instanceId = builder.instanceId;
        this.instanceUserArn = builder.instanceUserArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.username = builder.username;
    }

    /**
     * <p>
     * The date a user was associated with an EC2 instance.
     * </p>
     * 
     * @return The date a user was associated with an EC2 instance.
     */
    public final String associationDate() {
        return associationDate;
    }

    /**
     * <p>
     * The date a user was disassociated from an EC2 instance.
     * </p>
     * 
     * @return The date a user was disassociated from an EC2 instance.
     */
    public final String disassociationDate() {
        return disassociationDate;
    }

    /**
     * <p>
     * The domain name of the Active Directory that contains the user information for the product subscription.
     * </p>
     * 
     * @return The domain name of the Active Directory that contains the user information for the product subscription.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The <code>IdentityProvider</code> resource specifies details about the identity provider.
     * </p>
     * 
     * @return The <code>IdentityProvider</code> resource specifies details about the identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The ID of the EC2 instance that provides user-based subscriptions.
     * </p>
     * 
     * @return The ID of the EC2 instance that provides user-based subscriptions.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the instance user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the instance user.
     */
    public final String instanceUserArn() {
        return instanceUserArn;
    }

    /**
     * <p>
     * The status of a user associated with an EC2 instance.
     * </p>
     * 
     * @return The status of a user associated with an EC2 instance.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The status message for users of an EC2 instance.
     * </p>
     * 
     * @return The status message for users of an EC2 instance.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The user name from the identity provider for the user.
     * </p>
     * 
     * @return The user name from the identity provider for the user.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationDate());
        hashCode = 31 * hashCode + Objects.hashCode(disassociationDate());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceUserSummary)) {
            return false;
        }
        InstanceUserSummary other = (InstanceUserSummary) obj;
        return Objects.equals(associationDate(), other.associationDate())
                && Objects.equals(disassociationDate(), other.disassociationDate()) && Objects.equals(domain(), other.domain())
                && Objects.equals(identityProvider(), other.identityProvider())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceUserArn(), other.instanceUserArn())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceUserSummary").add("AssociationDate", associationDate())
                .add("DisassociationDate", disassociationDate()).add("Domain", domain())
                .add("IdentityProvider", identityProvider()).add("InstanceId", instanceId())
                .add("InstanceUserArn", instanceUserArn()).add("Status", status()).add("StatusMessage", statusMessage())
                .add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationDate":
            return Optional.ofNullable(clazz.cast(associationDate()));
        case "DisassociationDate":
            return Optional.ofNullable(clazz.cast(disassociationDate()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceUserArn":
            return Optional.ofNullable(clazz.cast(instanceUserArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationDate", ASSOCIATION_DATE_FIELD);
        map.put("DisassociationDate", DISASSOCIATION_DATE_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceUserArn", INSTANCE_USER_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Username", USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceUserSummary, T> g) {
        return obj -> g.apply((InstanceUserSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceUserSummary> {
        /**
         * <p>
         * The date a user was associated with an EC2 instance.
         * </p>
         * 
         * @param associationDate
         *        The date a user was associated with an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDate(String associationDate);

        /**
         * <p>
         * The date a user was disassociated from an EC2 instance.
         * </p>
         * 
         * @param disassociationDate
         *        The date a user was disassociated from an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociationDate(String disassociationDate);

        /**
         * <p>
         * The domain name of the Active Directory that contains the user information for the product subscription.
         * </p>
         * 
         * @param domain
         *        The domain name of the Active Directory that contains the user information for the product
         *        subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * </p>
         * 
         * @param identityProvider
         *        The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * The <code>IdentityProvider</code> resource specifies details about the identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The ID of the EC2 instance that provides user-based subscriptions.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance that provides user-based subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the instance user.
         * </p>
         * 
         * @param instanceUserArn
         *        The Amazon Resource Name (ARN) that identifies the instance user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUserArn(String instanceUserArn);

        /**
         * <p>
         * The status of a user associated with an EC2 instance.
         * </p>
         * 
         * @param status
         *        The status of a user associated with an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The status message for users of an EC2 instance.
         * </p>
         * 
         * @param statusMessage
         *        The status message for users of an EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The user name from the identity provider for the user.
         * </p>
         * 
         * @param username
         *        The user name from the identity provider for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String associationDate;

        private String disassociationDate;

        private String domain;

        private IdentityProvider identityProvider;

        private String instanceId;

        private String instanceUserArn;

        private String status;

        private String statusMessage;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceUserSummary model) {
            associationDate(model.associationDate);
            disassociationDate(model.disassociationDate);
            domain(model.domain);
            identityProvider(model.identityProvider);
            instanceId(model.instanceId);
            instanceUserArn(model.instanceUserArn);
            status(model.status);
            statusMessage(model.statusMessage);
            username(model.username);
        }

        public final String getAssociationDate() {
            return associationDate;
        }

        public final void setAssociationDate(String associationDate) {
            this.associationDate = associationDate;
        }

        @Override
        public final Builder associationDate(String associationDate) {
            this.associationDate = associationDate;
            return this;
        }

        public final String getDisassociationDate() {
            return disassociationDate;
        }

        public final void setDisassociationDate(String disassociationDate) {
            this.disassociationDate = disassociationDate;
        }

        @Override
        public final Builder disassociationDate(String disassociationDate) {
            this.disassociationDate = disassociationDate;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceUserArn() {
            return instanceUserArn;
        }

        public final void setInstanceUserArn(String instanceUserArn) {
            this.instanceUserArn = instanceUserArn;
        }

        @Override
        public final Builder instanceUserArn(String instanceUserArn) {
            this.instanceUserArn = instanceUserArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public InstanceUserSummary build() {
            return new InstanceUserSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
