/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserAssociationsResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<ListUserAssociationsResponse.Builder, ListUserAssociationsResponse> {
    private static final SdkField<List<InstanceUserSummary>> INSTANCE_USER_SUMMARIES_FIELD = SdkField
            .<List<InstanceUserSummary>> builder(MarshallingType.LIST)
            .memberName("InstanceUserSummaries")
            .getter(getter(ListUserAssociationsResponse::instanceUserSummaries))
            .setter(setter(Builder::instanceUserSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceUserSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceUserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceUserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUserAssociationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_USER_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceUserSummary> instanceUserSummaries;

    private final String nextToken;

    private ListUserAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceUserSummaries = builder.instanceUserSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceUserSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceUserSummaries() {
        return instanceUserSummaries != null && !(instanceUserSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that describes the list user association operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceUserSummaries} method.
     * </p>
     * 
     * @return Metadata that describes the list user association operation.
     */
    public final List<InstanceUserSummary> instanceUserSummaries() {
        return instanceUserSummaries;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceUserSummaries() ? instanceUserSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserAssociationsResponse)) {
            return false;
        }
        ListUserAssociationsResponse other = (ListUserAssociationsResponse) obj;
        return hasInstanceUserSummaries() == other.hasInstanceUserSummaries()
                && Objects.equals(instanceUserSummaries(), other.instanceUserSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUserAssociationsResponse")
                .add("InstanceUserSummaries", hasInstanceUserSummaries() ? instanceUserSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceUserSummaries":
            return Optional.ofNullable(clazz.cast(instanceUserSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceUserSummaries", INSTANCE_USER_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserAssociationsResponse, T> g) {
        return obj -> g.apply((ListUserAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUserAssociationsResponse> {
        /**
         * <p>
         * Metadata that describes the list user association operation.
         * </p>
         * 
         * @param instanceUserSummaries
         *        Metadata that describes the list user association operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUserSummaries(Collection<InstanceUserSummary> instanceUserSummaries);

        /**
         * <p>
         * Metadata that describes the list user association operation.
         * </p>
         * 
         * @param instanceUserSummaries
         *        Metadata that describes the list user association operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUserSummaries(InstanceUserSummary... instanceUserSummaries);

        /**
         * <p>
         * Metadata that describes the list user association operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #instanceUserSummaries(List<InstanceUserSummary>)}.
         * 
         * @param instanceUserSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceUserSummaries(java.util.Collection<InstanceUserSummary>)
         */
        Builder instanceUserSummaries(Consumer<InstanceUserSummary.Builder>... instanceUserSummaries);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private List<InstanceUserSummary> instanceUserSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserAssociationsResponse model) {
            super(model);
            instanceUserSummaries(model.instanceUserSummaries);
            nextToken(model.nextToken);
        }

        public final List<InstanceUserSummary.Builder> getInstanceUserSummaries() {
            List<InstanceUserSummary.Builder> result = InstanceUserSummaryListCopier.copyToBuilder(this.instanceUserSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceUserSummaries(Collection<InstanceUserSummary.BuilderImpl> instanceUserSummaries) {
            this.instanceUserSummaries = InstanceUserSummaryListCopier.copyFromBuilder(instanceUserSummaries);
        }

        @Override
        public final Builder instanceUserSummaries(Collection<InstanceUserSummary> instanceUserSummaries) {
            this.instanceUserSummaries = InstanceUserSummaryListCopier.copy(instanceUserSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUserSummaries(InstanceUserSummary... instanceUserSummaries) {
            instanceUserSummaries(Arrays.asList(instanceUserSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUserSummaries(Consumer<InstanceUserSummary.Builder>... instanceUserSummaries) {
            instanceUserSummaries(Stream.of(instanceUserSummaries)
                    .map(c -> InstanceUserSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUserAssociationsResponse build() {
            return new ListUserAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
