/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseServerEndpointResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<CreateLicenseServerEndpointResponse.Builder, CreateLicenseServerEndpointResponse> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderArn").getter(getter(CreateLicenseServerEndpointResponse::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build())
            .build();

    private static final SdkField<String> LICENSE_SERVER_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseServerEndpointArn").getter(getter(CreateLicenseServerEndpointResponse::licenseServerEndpointArn))
            .setter(setter(Builder::licenseServerEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerEndpointArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD,
            LICENSE_SERVER_ENDPOINT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityProviderArn;

    private final String licenseServerEndpointArn;

    private CreateLicenseServerEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderArn = builder.identityProviderArn;
        this.licenseServerEndpointArn = builder.licenseServerEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity provider specified in the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the identity provider specified in the request.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * <p>
     * The ARN of the <code>LicenseServerEndpoint</code> resource.
     * </p>
     * 
     * @return The ARN of the <code>LicenseServerEndpoint</code> resource.
     */
    public final String licenseServerEndpointArn() {
        return licenseServerEndpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServerEndpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseServerEndpointResponse)) {
            return false;
        }
        CreateLicenseServerEndpointResponse other = (CreateLicenseServerEndpointResponse) obj;
        return Objects.equals(identityProviderArn(), other.identityProviderArn())
                && Objects.equals(licenseServerEndpointArn(), other.licenseServerEndpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseServerEndpointResponse").add("IdentityProviderArn", identityProviderArn())
                .add("LicenseServerEndpointArn", licenseServerEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "LicenseServerEndpointArn":
            return Optional.ofNullable(clazz.cast(licenseServerEndpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("LicenseServerEndpointArn", LICENSE_SERVER_ENDPOINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseServerEndpointResponse, T> g) {
        return obj -> g.apply((CreateLicenseServerEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseServerEndpointResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity provider specified in the request.
         * </p>
         * 
         * @param identityProviderArn
         *        The Amazon Resource Name (ARN) of the identity provider specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The ARN of the <code>LicenseServerEndpoint</code> resource.
         * </p>
         * 
         * @param licenseServerEndpointArn
         *        The ARN of the <code>LicenseServerEndpoint</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServerEndpointArn(String licenseServerEndpointArn);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private String identityProviderArn;

        private String licenseServerEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseServerEndpointResponse model) {
            super(model);
            identityProviderArn(model.identityProviderArn);
            licenseServerEndpointArn(model.licenseServerEndpointArn);
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final String getLicenseServerEndpointArn() {
            return licenseServerEndpointArn;
        }

        public final void setLicenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
        }

        @Override
        public final Builder licenseServerEndpointArn(String licenseServerEndpointArn) {
            this.licenseServerEndpointArn = licenseServerEndpointArn;
            return this;
        }

        @Override
        public CreateLicenseServerEndpointResponse build() {
            return new CreateLicenseServerEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
