/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Refers to an identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProvider.Builder, IdentityProvider> {
    private static final SdkField<ActiveDirectoryIdentityProvider> ACTIVE_DIRECTORY_IDENTITY_PROVIDER_FIELD = SdkField
            .<ActiveDirectoryIdentityProvider> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveDirectoryIdentityProvider")
            .getter(getter(IdentityProvider::activeDirectoryIdentityProvider))
            .setter(setter(Builder::activeDirectoryIdentityProvider))
            .constructor(ActiveDirectoryIdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryIdentityProvider")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACTIVE_DIRECTORY_IDENTITY_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider;

    private final Type type;

    private IdentityProvider(BuilderImpl builder) {
        this.activeDirectoryIdentityProvider = builder.activeDirectoryIdentityProvider;
        this.type = builder.type;
    }

    /**
     * <p>
     * The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a specific
     * Active Directory identity provider.
     * </p>
     * 
     * @return The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
     *         specific Active Directory identity provider.
     */
    public final ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider() {
        return activeDirectoryIdentityProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryIdentityProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider other = (IdentityProvider) obj;
        return Objects.equals(activeDirectoryIdentityProvider(), other.activeDirectoryIdentityProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProvider").add("ActiveDirectoryIdentityProvider", activeDirectoryIdentityProvider())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveDirectoryIdentityProvider":
            return Optional.ofNullable(clazz.cast(activeDirectoryIdentityProvider()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #activeDirectoryIdentityProvider()} initialized to the given value.
     *
     * <p>
     * The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a specific
     * Active Directory identity provider.
     * </p>
     * 
     * @param activeDirectoryIdentityProvider
     *        The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
     *        specific Active Directory identity provider.
     */
    public static IdentityProvider fromActiveDirectoryIdentityProvider(
            ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider) {
        return builder().activeDirectoryIdentityProvider(activeDirectoryIdentityProvider).build();
    }

    /**
     * Create an instance of this class with {@link #activeDirectoryIdentityProvider()} initialized to the given value.
     *
     * <p>
     * The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a specific
     * Active Directory identity provider.
     * </p>
     * 
     * @param activeDirectoryIdentityProvider
     *        The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
     *        specific Active Directory identity provider.
     */
    public static IdentityProvider fromActiveDirectoryIdentityProvider(
            Consumer<ActiveDirectoryIdentityProvider.Builder> activeDirectoryIdentityProvider) {
        ActiveDirectoryIdentityProvider.Builder builder = ActiveDirectoryIdentityProvider.builder();
        activeDirectoryIdentityProvider.accept(builder);
        return fromActiveDirectoryIdentityProvider(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActiveDirectoryIdentityProvider", ACTIVE_DIRECTORY_IDENTITY_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProvider, T> g) {
        return obj -> g.apply((IdentityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProvider> {
        /**
         * <p>
         * The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
         * specific Active Directory identity provider.
         * </p>
         * 
         * @param activeDirectoryIdentityProvider
         *        The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
         *        specific Active Directory identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryIdentityProvider(ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider);

        /**
         * <p>
         * The <code>ActiveDirectoryIdentityProvider</code> resource contains settings and other details about a
         * specific Active Directory identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveDirectoryIdentityProvider.Builder}
         * avoiding the need to create one manually via {@link ActiveDirectoryIdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveDirectoryIdentityProvider.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activeDirectoryIdentityProvider(ActiveDirectoryIdentityProvider)}.
         * 
         * @param activeDirectoryIdentityProvider
         *        a consumer that will call methods on {@link ActiveDirectoryIdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryIdentityProvider(ActiveDirectoryIdentityProvider)
         */
        default Builder activeDirectoryIdentityProvider(
                Consumer<ActiveDirectoryIdentityProvider.Builder> activeDirectoryIdentityProvider) {
            return activeDirectoryIdentityProvider(ActiveDirectoryIdentityProvider.builder()
                    .applyMutation(activeDirectoryIdentityProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProvider model) {
            activeDirectoryIdentityProvider(model.activeDirectoryIdentityProvider);
        }

        public final ActiveDirectoryIdentityProvider.Builder getActiveDirectoryIdentityProvider() {
            return activeDirectoryIdentityProvider != null ? activeDirectoryIdentityProvider.toBuilder() : null;
        }

        public final void setActiveDirectoryIdentityProvider(
                ActiveDirectoryIdentityProvider.BuilderImpl activeDirectoryIdentityProvider) {
            Object oldValue = this.activeDirectoryIdentityProvider;
            this.activeDirectoryIdentityProvider = activeDirectoryIdentityProvider != null ? activeDirectoryIdentityProvider
                    .build() : null;
            handleUnionValueChange(Type.ACTIVE_DIRECTORY_IDENTITY_PROVIDER, oldValue, this.activeDirectoryIdentityProvider);
        }

        @Override
        public final Builder activeDirectoryIdentityProvider(ActiveDirectoryIdentityProvider activeDirectoryIdentityProvider) {
            Object oldValue = this.activeDirectoryIdentityProvider;
            this.activeDirectoryIdentityProvider = activeDirectoryIdentityProvider;
            handleUnionValueChange(Type.ACTIVE_DIRECTORY_IDENTITY_PROVIDER, oldValue, this.activeDirectoryIdentityProvider);
            return this;
        }

        @Override
        public IdentityProvider build() {
            return new IdentityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IdentityProvider#type()
     */
    public enum Type {
        ACTIVE_DIRECTORY_IDENTITY_PROVIDER,

        UNKNOWN_TO_SDK_VERSION
    }
}
