/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings to configure your license server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseServerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseServerSettings.Builder, LicenseServerSettings> {
    private static final SdkField<ServerSettings> SERVER_SETTINGS_FIELD = SdkField
            .<ServerSettings> builder(MarshallingType.SDK_POJO).memberName("ServerSettings")
            .getter(getter(LicenseServerSettings::serverSettings)).setter(setter(Builder::serverSettings))
            .constructor(ServerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSettings").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerType").getter(getter(LicenseServerSettings::serverTypeAsString))
            .setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_SETTINGS_FIELD,
            SERVER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServerSettings serverSettings;

    private final String serverType;

    private LicenseServerSettings(BuilderImpl builder) {
        this.serverSettings = builder.serverSettings;
        this.serverType = builder.serverType;
    }

    /**
     * <p>
     * The <code>ServerSettings</code> resource contains the settings for your server.
     * </p>
     * 
     * @return The <code>ServerSettings</code> resource contains the settings for your server.
     */
    public final ServerSettings serverSettings() {
        return serverSettings;
    }

    /**
     * <p>
     * The type of license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of license server.
     * @see ServerType
     */
    public final ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of license server.
     * @see ServerType
     */
    public final String serverTypeAsString() {
        return serverType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverSettings());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseServerSettings)) {
            return false;
        }
        LicenseServerSettings other = (LicenseServerSettings) obj;
        return Objects.equals(serverSettings(), other.serverSettings())
                && Objects.equals(serverTypeAsString(), other.serverTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseServerSettings").add("ServerSettings", serverSettings())
                .add("ServerType", serverTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerSettings":
            return Optional.ofNullable(clazz.cast(serverSettings()));
        case "ServerType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerSettings", SERVER_SETTINGS_FIELD);
        map.put("ServerType", SERVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseServerSettings, T> g) {
        return obj -> g.apply((LicenseServerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseServerSettings> {
        /**
         * <p>
         * The <code>ServerSettings</code> resource contains the settings for your server.
         * </p>
         * 
         * @param serverSettings
         *        The <code>ServerSettings</code> resource contains the settings for your server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSettings(ServerSettings serverSettings);

        /**
         * <p>
         * The <code>ServerSettings</code> resource contains the settings for your server.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerSettings.Builder} avoiding the need
         * to create one manually via {@link ServerSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #serverSettings(ServerSettings)}.
         * 
         * @param serverSettings
         *        a consumer that will call methods on {@link ServerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSettings(ServerSettings)
         */
        default Builder serverSettings(Consumer<ServerSettings.Builder> serverSettings) {
            return serverSettings(ServerSettings.builder().applyMutation(serverSettings).build());
        }

        /**
         * <p>
         * The type of license server.
         * </p>
         * 
         * @param serverType
         *        The type of license server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of license server.
         * </p>
         * 
         * @param serverType
         *        The type of license server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);
    }

    static final class BuilderImpl implements Builder {
        private ServerSettings serverSettings;

        private String serverType;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseServerSettings model) {
            serverSettings(model.serverSettings);
            serverType(model.serverType);
        }

        public final ServerSettings.Builder getServerSettings() {
            return serverSettings != null ? serverSettings.toBuilder() : null;
        }

        public final void setServerSettings(ServerSettings.BuilderImpl serverSettings) {
            this.serverSettings = serverSettings != null ? serverSettings.build() : null;
        }

        @Override
        public final Builder serverSettings(ServerSettings serverSettings) {
            this.serverSettings = serverSettings;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        @Override
        public LicenseServerSettings build() {
            return new LicenseServerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
