/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Server settings that are specific to a Remote Desktop Services (RDS) license server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsSalSettings implements SdkPojo, Serializable, ToCopyableBuilder<RdsSalSettings.Builder, RdsSalSettings> {
    private static final SdkField<CredentialsProvider> RDS_SAL_CREDENTIALS_PROVIDER_FIELD = SdkField
            .<CredentialsProvider> builder(MarshallingType.SDK_POJO).memberName("RdsSalCredentialsProvider")
            .getter(getter(RdsSalSettings::rdsSalCredentialsProvider)).setter(setter(Builder::rdsSalCredentialsProvider))
            .constructor(CredentialsProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsSalCredentialsProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RDS_SAL_CREDENTIALS_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CredentialsProvider rdsSalCredentialsProvider;

    private RdsSalSettings(BuilderImpl builder) {
        this.rdsSalCredentialsProvider = builder.rdsSalCredentialsProvider;
    }

    /**
     * <p>
     * The <code>CredentialsProvider</code> resource contains a reference to the credentials provider that's used for
     * RDS license server user administration.
     * </p>
     * 
     * @return The <code>CredentialsProvider</code> resource contains a reference to the credentials provider that's
     *         used for RDS license server user administration.
     */
    public final CredentialsProvider rdsSalCredentialsProvider() {
        return rdsSalCredentialsProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rdsSalCredentialsProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsSalSettings)) {
            return false;
        }
        RdsSalSettings other = (RdsSalSettings) obj;
        return Objects.equals(rdsSalCredentialsProvider(), other.rdsSalCredentialsProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsSalSettings").add("RdsSalCredentialsProvider", rdsSalCredentialsProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsSalCredentialsProvider":
            return Optional.ofNullable(clazz.cast(rdsSalCredentialsProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RdsSalCredentialsProvider", RDS_SAL_CREDENTIALS_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsSalSettings, T> g) {
        return obj -> g.apply((RdsSalSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsSalSettings> {
        /**
         * <p>
         * The <code>CredentialsProvider</code> resource contains a reference to the credentials provider that's used
         * for RDS license server user administration.
         * </p>
         * 
         * @param rdsSalCredentialsProvider
         *        The <code>CredentialsProvider</code> resource contains a reference to the credentials provider that's
         *        used for RDS license server user administration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsSalCredentialsProvider(CredentialsProvider rdsSalCredentialsProvider);

        /**
         * <p>
         * The <code>CredentialsProvider</code> resource contains a reference to the credentials provider that's used
         * for RDS license server user administration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CredentialsProvider.Builder} avoiding the
         * need to create one manually via {@link CredentialsProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CredentialsProvider.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsSalCredentialsProvider(CredentialsProvider)}.
         * 
         * @param rdsSalCredentialsProvider
         *        a consumer that will call methods on {@link CredentialsProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsSalCredentialsProvider(CredentialsProvider)
         */
        default Builder rdsSalCredentialsProvider(Consumer<CredentialsProvider.Builder> rdsSalCredentialsProvider) {
            return rdsSalCredentialsProvider(CredentialsProvider.builder().applyMutation(rdsSalCredentialsProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CredentialsProvider rdsSalCredentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsSalSettings model) {
            rdsSalCredentialsProvider(model.rdsSalCredentialsProvider);
        }

        public final CredentialsProvider.Builder getRdsSalCredentialsProvider() {
            return rdsSalCredentialsProvider != null ? rdsSalCredentialsProvider.toBuilder() : null;
        }

        public final void setRdsSalCredentialsProvider(CredentialsProvider.BuilderImpl rdsSalCredentialsProvider) {
            this.rdsSalCredentialsProvider = rdsSalCredentialsProvider != null ? rdsSalCredentialsProvider.build() : null;
        }

        @Override
        public final Builder rdsSalCredentialsProvider(CredentialsProvider rdsSalCredentialsProvider) {
            this.rdsSalCredentialsProvider = rdsSalCredentialsProvider;
            return this;
        }

        @Override
        public RdsSalSettings build() {
            return new RdsSalSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
