/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProductSubscriptionResponse extends LicenseManagerUserSubscriptionsResponse implements
        ToCopyableBuilder<StartProductSubscriptionResponse.Builder, StartProductSubscriptionResponse> {
    private static final SdkField<ProductUserSummary> PRODUCT_USER_SUMMARY_FIELD = SdkField
            .<ProductUserSummary> builder(MarshallingType.SDK_POJO).memberName("ProductUserSummary")
            .getter(getter(StartProductSubscriptionResponse::productUserSummary)).setter(setter(Builder::productUserSummary))
            .constructor(ProductUserSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductUserSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_USER_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProductUserSummary productUserSummary;

    private StartProductSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.productUserSummary = builder.productUserSummary;
    }

    /**
     * <p>
     * Metadata that describes the start product subscription operation.
     * </p>
     * 
     * @return Metadata that describes the start product subscription operation.
     */
    public final ProductUserSummary productUserSummary() {
        return productUserSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productUserSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProductSubscriptionResponse)) {
            return false;
        }
        StartProductSubscriptionResponse other = (StartProductSubscriptionResponse) obj;
        return Objects.equals(productUserSummary(), other.productUserSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProductSubscriptionResponse").add("ProductUserSummary", productUserSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductUserSummary":
            return Optional.ofNullable(clazz.cast(productUserSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductUserSummary", PRODUCT_USER_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProductSubscriptionResponse, T> g) {
        return obj -> g.apply((StartProductSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartProductSubscriptionResponse> {
        /**
         * <p>
         * Metadata that describes the start product subscription operation.
         * </p>
         * 
         * @param productUserSummary
         *        Metadata that describes the start product subscription operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUserSummary(ProductUserSummary productUserSummary);

        /**
         * <p>
         * Metadata that describes the start product subscription operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProductUserSummary.Builder} avoiding the
         * need to create one manually via {@link ProductUserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProductUserSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #productUserSummary(ProductUserSummary)}.
         * 
         * @param productUserSummary
         *        a consumer that will call methods on {@link ProductUserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productUserSummary(ProductUserSummary)
         */
        default Builder productUserSummary(Consumer<ProductUserSummary.Builder> productUserSummary) {
            return productUserSummary(ProductUserSummary.builder().applyMutation(productUserSummary).build());
        }
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsResponse.BuilderImpl implements Builder {
        private ProductUserSummary productUserSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProductSubscriptionResponse model) {
            super(model);
            productUserSummary(model.productUserSummary);
        }

        public final ProductUserSummary.Builder getProductUserSummary() {
            return productUserSummary != null ? productUserSummary.toBuilder() : null;
        }

        public final void setProductUserSummary(ProductUserSummary.BuilderImpl productUserSummary) {
            this.productUserSummary = productUserSummary != null ? productUserSummary.build() : null;
        }

        @Override
        public final Builder productUserSummary(ProductUserSummary productUserSummary) {
            this.productUserSummary = productUserSummary;
            return this;
        }

        @Override
        public StartProductSubscriptionResponse build() {
            return new StartProductSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
