/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Active Directory identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectoryIdentityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveDirectoryIdentityProvider.Builder, ActiveDirectoryIdentityProvider> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ActiveDirectoryIdentityProvider::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<ActiveDirectorySettings> ACTIVE_DIRECTORY_SETTINGS_FIELD = SdkField
            .<ActiveDirectorySettings> builder(MarshallingType.SDK_POJO).memberName("ActiveDirectorySettings")
            .getter(getter(ActiveDirectoryIdentityProvider::activeDirectorySettings))
            .setter(setter(Builder::activeDirectorySettings)).constructor(ActiveDirectorySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectorySettings").build())
            .build();

    private static final SdkField<String> ACTIVE_DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryType").getter(getter(ActiveDirectoryIdentityProvider::activeDirectoryTypeAsString))
            .setter(setter(Builder::activeDirectoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryType").build())
            .build();

    private static final SdkField<Boolean> IS_SHARED_ACTIVE_DIRECTORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsSharedActiveDirectory").getter(getter(ActiveDirectoryIdentityProvider::isSharedActiveDirectory))
            .setter(setter(Builder::isSharedActiveDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsSharedActiveDirectory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            ACTIVE_DIRECTORY_SETTINGS_FIELD, ACTIVE_DIRECTORY_TYPE_FIELD, IS_SHARED_ACTIVE_DIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final ActiveDirectorySettings activeDirectorySettings;

    private final String activeDirectoryType;

    private final Boolean isSharedActiveDirectory;

    private ActiveDirectoryIdentityProvider(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.activeDirectorySettings = builder.activeDirectorySettings;
        this.activeDirectoryType = builder.activeDirectoryType;
        this.isSharedActiveDirectory = builder.isSharedActiveDirectory;
    }

    /**
     * <p>
     * The directory ID for an Active Directory identity provider.
     * </p>
     * 
     * @return The directory ID for an Active Directory identity provider.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The <code>ActiveDirectorySettings</code> resource contains details about the Active Directory, including network
     * access details such as domain name and IP addresses, and the credential provider for user administration.
     * </p>
     * 
     * @return The <code>ActiveDirectorySettings</code> resource contains details about the Active Directory, including
     *         network access details such as domain name and IP addresses, and the credential provider for user
     *         administration.
     */
    public final ActiveDirectorySettings activeDirectorySettings() {
        return activeDirectorySettings;
    }

    /**
     * <p>
     * The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed Active
     * Directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryType} will return {@link ActiveDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed
     *         Active Directory.
     * @see ActiveDirectoryType
     */
    public final ActiveDirectoryType activeDirectoryType() {
        return ActiveDirectoryType.fromValue(activeDirectoryType);
    }

    /**
     * <p>
     * The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed Active
     * Directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryType} will return {@link ActiveDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed
     *         Active Directory.
     * @see ActiveDirectoryType
     */
    public final String activeDirectoryTypeAsString() {
        return activeDirectoryType;
    }

    /**
     * <p>
     * Whether this directory is shared from an Amazon Web Services Managed Active Directory. The default value is
     * false.
     * </p>
     * 
     * @return Whether this directory is shared from an Amazon Web Services Managed Active Directory. The default value
     *         is false.
     */
    public final Boolean isSharedActiveDirectory() {
        return isSharedActiveDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectorySettings());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isSharedActiveDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryIdentityProvider)) {
            return false;
        }
        ActiveDirectoryIdentityProvider other = (ActiveDirectoryIdentityProvider) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(activeDirectorySettings(), other.activeDirectorySettings())
                && Objects.equals(activeDirectoryTypeAsString(), other.activeDirectoryTypeAsString())
                && Objects.equals(isSharedActiveDirectory(), other.isSharedActiveDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveDirectoryIdentityProvider").add("DirectoryId", directoryId())
                .add("ActiveDirectorySettings", activeDirectorySettings())
                .add("ActiveDirectoryType", activeDirectoryTypeAsString())
                .add("IsSharedActiveDirectory", isSharedActiveDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "ActiveDirectorySettings":
            return Optional.ofNullable(clazz.cast(activeDirectorySettings()));
        case "ActiveDirectoryType":
            return Optional.ofNullable(clazz.cast(activeDirectoryTypeAsString()));
        case "IsSharedActiveDirectory":
            return Optional.ofNullable(clazz.cast(isSharedActiveDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("ActiveDirectorySettings", ACTIVE_DIRECTORY_SETTINGS_FIELD);
        map.put("ActiveDirectoryType", ACTIVE_DIRECTORY_TYPE_FIELD);
        map.put("IsSharedActiveDirectory", IS_SHARED_ACTIVE_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryIdentityProvider, T> g) {
        return obj -> g.apply((ActiveDirectoryIdentityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectoryIdentityProvider> {
        /**
         * <p>
         * The directory ID for an Active Directory identity provider.
         * </p>
         * 
         * @param directoryId
         *        The directory ID for an Active Directory identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The <code>ActiveDirectorySettings</code> resource contains details about the Active Directory, including
         * network access details such as domain name and IP addresses, and the credential provider for user
         * administration.
         * </p>
         * 
         * @param activeDirectorySettings
         *        The <code>ActiveDirectorySettings</code> resource contains details about the Active Directory,
         *        including network access details such as domain name and IP addresses, and the credential provider for
         *        user administration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectorySettings(ActiveDirectorySettings activeDirectorySettings);

        /**
         * <p>
         * The <code>ActiveDirectorySettings</code> resource contains details about the Active Directory, including
         * network access details such as domain name and IP addresses, and the credential provider for user
         * administration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveDirectorySettings.Builder} avoiding
         * the need to create one manually via {@link ActiveDirectorySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveDirectorySettings.Builder#build()} is called immediately
         * and its result is passed to {@link #activeDirectorySettings(ActiveDirectorySettings)}.
         * 
         * @param activeDirectorySettings
         *        a consumer that will call methods on {@link ActiveDirectorySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectorySettings(ActiveDirectorySettings)
         */
        default Builder activeDirectorySettings(Consumer<ActiveDirectorySettings.Builder> activeDirectorySettings) {
            return activeDirectorySettings(ActiveDirectorySettings.builder().applyMutation(activeDirectorySettings).build());
        }

        /**
         * <p>
         * The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed
         * Active Directory.
         * </p>
         * 
         * @param activeDirectoryType
         *        The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services
         *        Managed Active Directory.
         * @see ActiveDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryType
         */
        Builder activeDirectoryType(String activeDirectoryType);

        /**
         * <p>
         * The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services Managed
         * Active Directory.
         * </p>
         * 
         * @param activeDirectoryType
         *        The type of Active Directory – either a self-managed Active Directory or an Amazon Web Services
         *        Managed Active Directory.
         * @see ActiveDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryType
         */
        Builder activeDirectoryType(ActiveDirectoryType activeDirectoryType);

        /**
         * <p>
         * Whether this directory is shared from an Amazon Web Services Managed Active Directory. The default value is
         * false.
         * </p>
         * 
         * @param isSharedActiveDirectory
         *        Whether this directory is shared from an Amazon Web Services Managed Active Directory. The default
         *        value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSharedActiveDirectory(Boolean isSharedActiveDirectory);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private ActiveDirectorySettings activeDirectorySettings;

        private String activeDirectoryType;

        private Boolean isSharedActiveDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryIdentityProvider model) {
            directoryId(model.directoryId);
            activeDirectorySettings(model.activeDirectorySettings);
            activeDirectoryType(model.activeDirectoryType);
            isSharedActiveDirectory(model.isSharedActiveDirectory);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final ActiveDirectorySettings.Builder getActiveDirectorySettings() {
            return activeDirectorySettings != null ? activeDirectorySettings.toBuilder() : null;
        }

        public final void setActiveDirectorySettings(ActiveDirectorySettings.BuilderImpl activeDirectorySettings) {
            this.activeDirectorySettings = activeDirectorySettings != null ? activeDirectorySettings.build() : null;
        }

        @Override
        public final Builder activeDirectorySettings(ActiveDirectorySettings activeDirectorySettings) {
            this.activeDirectorySettings = activeDirectorySettings;
            return this;
        }

        public final String getActiveDirectoryType() {
            return activeDirectoryType;
        }

        public final void setActiveDirectoryType(String activeDirectoryType) {
            this.activeDirectoryType = activeDirectoryType;
        }

        @Override
        public final Builder activeDirectoryType(String activeDirectoryType) {
            this.activeDirectoryType = activeDirectoryType;
            return this;
        }

        @Override
        public final Builder activeDirectoryType(ActiveDirectoryType activeDirectoryType) {
            this.activeDirectoryType(activeDirectoryType == null ? null : activeDirectoryType.toString());
            return this;
        }

        public final Boolean getIsSharedActiveDirectory() {
            return isSharedActiveDirectory;
        }

        public final void setIsSharedActiveDirectory(Boolean isSharedActiveDirectory) {
            this.isSharedActiveDirectory = isSharedActiveDirectory;
        }

        @Override
        public final Builder isSharedActiveDirectory(Boolean isSharedActiveDirectory) {
            this.isSharedActiveDirectory = isSharedActiveDirectory;
            return this;
        }

        @Override
        public ActiveDirectoryIdentityProvider build() {
            return new ActiveDirectoryIdentityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
