/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains network access and credential details that are needed for user administration in the Active Directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectorySettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveDirectorySettings.Builder, ActiveDirectorySettings> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ActiveDirectorySettings::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<String>> DOMAIN_IPV4_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainIpv4List")
            .getter(getter(ActiveDirectorySettings::domainIpv4List))
            .setter(setter(Builder::domainIpv4List))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIpv4List").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DOMAIN_IPV6_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainIpv6List")
            .getter(getter(ActiveDirectorySettings::domainIpv6List))
            .setter(setter(Builder::domainIpv6List))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIpv6List").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CredentialsProvider> DOMAIN_CREDENTIALS_PROVIDER_FIELD = SdkField
            .<CredentialsProvider> builder(MarshallingType.SDK_POJO).memberName("DomainCredentialsProvider")
            .getter(getter(ActiveDirectorySettings::domainCredentialsProvider))
            .setter(setter(Builder::domainCredentialsProvider)).constructor(CredentialsProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCredentialsProvider").build())
            .build();

    private static final SdkField<DomainNetworkSettings> DOMAIN_NETWORK_SETTINGS_FIELD = SdkField
            .<DomainNetworkSettings> builder(MarshallingType.SDK_POJO).memberName("DomainNetworkSettings")
            .getter(getter(ActiveDirectorySettings::domainNetworkSettings)).setter(setter(Builder::domainNetworkSettings))
            .constructor(DomainNetworkSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNetworkSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_IPV4_LIST_FIELD, DOMAIN_IPV6_LIST_FIELD, DOMAIN_CREDENTIALS_PROVIDER_FIELD, DOMAIN_NETWORK_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final List<String> domainIpv4List;

    private final List<String> domainIpv6List;

    private final CredentialsProvider domainCredentialsProvider;

    private final DomainNetworkSettings domainNetworkSettings;

    private ActiveDirectorySettings(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.domainIpv4List = builder.domainIpv4List;
        this.domainIpv6List = builder.domainIpv6List;
        this.domainCredentialsProvider = builder.domainCredentialsProvider;
        this.domainNetworkSettings = builder.domainNetworkSettings;
    }

    /**
     * <p>
     * The domain name for the Active Directory.
     * </p>
     * 
     * @return The domain name for the Active Directory.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainIpv4List property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainIpv4List() {
        return domainIpv4List != null && !(domainIpv4List instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of domain IPv4 addresses that are used for the Active Directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainIpv4List} method.
     * </p>
     * 
     * @return A list of domain IPv4 addresses that are used for the Active Directory.
     */
    public final List<String> domainIpv4List() {
        return domainIpv4List;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainIpv6List property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainIpv6List() {
        return domainIpv6List != null && !(domainIpv6List instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of domain IPv6 addresses that are used for the Active Directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainIpv6List} method.
     * </p>
     * 
     * @return A list of domain IPv6 addresses that are used for the Active Directory.
     */
    public final List<String> domainIpv6List() {
        return domainIpv6List;
    }

    /**
     * <p>
     * Points to the <code>CredentialsProvider</code> resource that contains information about the credential provider
     * for user administration.
     * </p>
     * 
     * @return Points to the <code>CredentialsProvider</code> resource that contains information about the credential
     *         provider for user administration.
     */
    public final CredentialsProvider domainCredentialsProvider() {
        return domainCredentialsProvider;
    }

    /**
     * <p>
     * The <code>DomainNetworkSettings</code> resource contains an array of subnets that apply for the Active Directory.
     * </p>
     * 
     * @return The <code>DomainNetworkSettings</code> resource contains an array of subnets that apply for the Active
     *         Directory.
     */
    public final DomainNetworkSettings domainNetworkSettings() {
        return domainNetworkSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainIpv4List() ? domainIpv4List() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainIpv6List() ? domainIpv6List() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainCredentialsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(domainNetworkSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectorySettings)) {
            return false;
        }
        ActiveDirectorySettings other = (ActiveDirectorySettings) obj;
        return Objects.equals(domainName(), other.domainName()) && hasDomainIpv4List() == other.hasDomainIpv4List()
                && Objects.equals(domainIpv4List(), other.domainIpv4List()) && hasDomainIpv6List() == other.hasDomainIpv6List()
                && Objects.equals(domainIpv6List(), other.domainIpv6List())
                && Objects.equals(domainCredentialsProvider(), other.domainCredentialsProvider())
                && Objects.equals(domainNetworkSettings(), other.domainNetworkSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveDirectorySettings").add("DomainName", domainName())
                .add("DomainIpv4List", hasDomainIpv4List() ? domainIpv4List() : null)
                .add("DomainIpv6List", hasDomainIpv6List() ? domainIpv6List() : null)
                .add("DomainCredentialsProvider", domainCredentialsProvider())
                .add("DomainNetworkSettings", domainNetworkSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainIpv4List":
            return Optional.ofNullable(clazz.cast(domainIpv4List()));
        case "DomainIpv6List":
            return Optional.ofNullable(clazz.cast(domainIpv6List()));
        case "DomainCredentialsProvider":
            return Optional.ofNullable(clazz.cast(domainCredentialsProvider()));
        case "DomainNetworkSettings":
            return Optional.ofNullable(clazz.cast(domainNetworkSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DomainIpv4List", DOMAIN_IPV4_LIST_FIELD);
        map.put("DomainIpv6List", DOMAIN_IPV6_LIST_FIELD);
        map.put("DomainCredentialsProvider", DOMAIN_CREDENTIALS_PROVIDER_FIELD);
        map.put("DomainNetworkSettings", DOMAIN_NETWORK_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectorySettings, T> g) {
        return obj -> g.apply((ActiveDirectorySettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectorySettings> {
        /**
         * <p>
         * The domain name for the Active Directory.
         * </p>
         * 
         * @param domainName
         *        The domain name for the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of domain IPv4 addresses that are used for the Active Directory.
         * </p>
         * 
         * @param domainIpv4List
         *        A list of domain IPv4 addresses that are used for the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIpv4List(Collection<String> domainIpv4List);

        /**
         * <p>
         * A list of domain IPv4 addresses that are used for the Active Directory.
         * </p>
         * 
         * @param domainIpv4List
         *        A list of domain IPv4 addresses that are used for the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIpv4List(String... domainIpv4List);

        /**
         * <p>
         * A list of domain IPv6 addresses that are used for the Active Directory.
         * </p>
         * 
         * @param domainIpv6List
         *        A list of domain IPv6 addresses that are used for the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIpv6List(Collection<String> domainIpv6List);

        /**
         * <p>
         * A list of domain IPv6 addresses that are used for the Active Directory.
         * </p>
         * 
         * @param domainIpv6List
         *        A list of domain IPv6 addresses that are used for the Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIpv6List(String... domainIpv6List);

        /**
         * <p>
         * Points to the <code>CredentialsProvider</code> resource that contains information about the credential
         * provider for user administration.
         * </p>
         * 
         * @param domainCredentialsProvider
         *        Points to the <code>CredentialsProvider</code> resource that contains information about the credential
         *        provider for user administration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainCredentialsProvider(CredentialsProvider domainCredentialsProvider);

        /**
         * <p>
         * Points to the <code>CredentialsProvider</code> resource that contains information about the credential
         * provider for user administration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CredentialsProvider.Builder} avoiding the
         * need to create one manually via {@link CredentialsProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CredentialsProvider.Builder#build()} is called immediately and
         * its result is passed to {@link #domainCredentialsProvider(CredentialsProvider)}.
         * 
         * @param domainCredentialsProvider
         *        a consumer that will call methods on {@link CredentialsProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainCredentialsProvider(CredentialsProvider)
         */
        default Builder domainCredentialsProvider(Consumer<CredentialsProvider.Builder> domainCredentialsProvider) {
            return domainCredentialsProvider(CredentialsProvider.builder().applyMutation(domainCredentialsProvider).build());
        }

        /**
         * <p>
         * The <code>DomainNetworkSettings</code> resource contains an array of subnets that apply for the Active
         * Directory.
         * </p>
         * 
         * @param domainNetworkSettings
         *        The <code>DomainNetworkSettings</code> resource contains an array of subnets that apply for the Active
         *        Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNetworkSettings(DomainNetworkSettings domainNetworkSettings);

        /**
         * <p>
         * The <code>DomainNetworkSettings</code> resource contains an array of subnets that apply for the Active
         * Directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainNetworkSettings.Builder} avoiding
         * the need to create one manually via {@link DomainNetworkSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainNetworkSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #domainNetworkSettings(DomainNetworkSettings)}.
         * 
         * @param domainNetworkSettings
         *        a consumer that will call methods on {@link DomainNetworkSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNetworkSettings(DomainNetworkSettings)
         */
        default Builder domainNetworkSettings(Consumer<DomainNetworkSettings.Builder> domainNetworkSettings) {
            return domainNetworkSettings(DomainNetworkSettings.builder().applyMutation(domainNetworkSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private List<String> domainIpv4List = DefaultSdkAutoConstructList.getInstance();

        private List<String> domainIpv6List = DefaultSdkAutoConstructList.getInstance();

        private CredentialsProvider domainCredentialsProvider;

        private DomainNetworkSettings domainNetworkSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectorySettings model) {
            domainName(model.domainName);
            domainIpv4List(model.domainIpv4List);
            domainIpv6List(model.domainIpv6List);
            domainCredentialsProvider(model.domainCredentialsProvider);
            domainNetworkSettings(model.domainNetworkSettings);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getDomainIpv4List() {
            if (domainIpv4List instanceof SdkAutoConstructList) {
                return null;
            }
            return domainIpv4List;
        }

        public final void setDomainIpv4List(Collection<String> domainIpv4List) {
            this.domainIpv4List = ActiveDirectorySettingsDomainIpv4ListListCopier.copy(domainIpv4List);
        }

        @Override
        public final Builder domainIpv4List(Collection<String> domainIpv4List) {
            this.domainIpv4List = ActiveDirectorySettingsDomainIpv4ListListCopier.copy(domainIpv4List);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIpv4List(String... domainIpv4List) {
            domainIpv4List(Arrays.asList(domainIpv4List));
            return this;
        }

        public final Collection<String> getDomainIpv6List() {
            if (domainIpv6List instanceof SdkAutoConstructList) {
                return null;
            }
            return domainIpv6List;
        }

        public final void setDomainIpv6List(Collection<String> domainIpv6List) {
            this.domainIpv6List = ActiveDirectorySettingsDomainIpv6ListListCopier.copy(domainIpv6List);
        }

        @Override
        public final Builder domainIpv6List(Collection<String> domainIpv6List) {
            this.domainIpv6List = ActiveDirectorySettingsDomainIpv6ListListCopier.copy(domainIpv6List);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIpv6List(String... domainIpv6List) {
            domainIpv6List(Arrays.asList(domainIpv6List));
            return this;
        }

        public final CredentialsProvider.Builder getDomainCredentialsProvider() {
            return domainCredentialsProvider != null ? domainCredentialsProvider.toBuilder() : null;
        }

        public final void setDomainCredentialsProvider(CredentialsProvider.BuilderImpl domainCredentialsProvider) {
            this.domainCredentialsProvider = domainCredentialsProvider != null ? domainCredentialsProvider.build() : null;
        }

        @Override
        public final Builder domainCredentialsProvider(CredentialsProvider domainCredentialsProvider) {
            this.domainCredentialsProvider = domainCredentialsProvider;
            return this;
        }

        public final DomainNetworkSettings.Builder getDomainNetworkSettings() {
            return domainNetworkSettings != null ? domainNetworkSettings.toBuilder() : null;
        }

        public final void setDomainNetworkSettings(DomainNetworkSettings.BuilderImpl domainNetworkSettings) {
            this.domainNetworkSettings = domainNetworkSettings != null ? domainNetworkSettings.build() : null;
        }

        @Override
        public final Builder domainNetworkSettings(DomainNetworkSettings domainNetworkSettings) {
            this.domainNetworkSettings = domainNetworkSettings;
            return this;
        }

        @Override
        public ActiveDirectorySettings build() {
            return new ActiveDirectorySettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
