/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateUserRequest extends LicenseManagerUserSubscriptionsRequest implements
        ToCopyableBuilder<DisassociateUserRequest.Builder, DisassociateUserRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(DisassociateUserRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DisassociateUserRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(DisassociateUserRequest::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceUserArn").getter(getter(DisassociateUserRequest::instanceUserArn))
            .setter(setter(Builder::instanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceUserArn").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DisassociateUserRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            INSTANCE_ID_FIELD, IDENTITY_PROVIDER_FIELD, INSTANCE_USER_ARN_FIELD, DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String username;

    private final String instanceId;

    private final IdentityProvider identityProvider;

    private final String instanceUserArn;

    private final String domain;

    private DisassociateUserRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.instanceId = builder.instanceId;
        this.identityProvider = builder.identityProvider;
        this.instanceUserArn = builder.instanceUserArn;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The user name from the Active Directory identity provider for the user.
     * </p>
     * 
     * @return The user name from the Active Directory identity provider for the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The ID of the EC2 instance which provides user-based subscriptions.
     * </p>
     * 
     * @return The ID of the EC2 instance which provides user-based subscriptions.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An object that specifies details for the Active Directory identity provider.
     * </p>
     * 
     * @return An object that specifies details for the Active Directory identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user to disassociate from the EC2 instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user to disassociate from the EC2 instance.
     */
    public final String instanceUserArn() {
        return instanceUserArn;
    }

    /**
     * <p>
     * The domain name of the Active Directory that contains information for the user to disassociate.
     * </p>
     * 
     * @return The domain name of the Active Directory that contains information for the user to disassociate.
     */
    public final String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(instanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateUserRequest)) {
            return false;
        }
        DisassociateUserRequest other = (DisassociateUserRequest) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(identityProvider(), other.identityProvider())
                && Objects.equals(instanceUserArn(), other.instanceUserArn()) && Objects.equals(domain(), other.domain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateUserRequest").add("Username", username()).add("InstanceId", instanceId())
                .add("IdentityProvider", identityProvider()).add("InstanceUserArn", instanceUserArn()).add("Domain", domain())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "InstanceUserArn":
            return Optional.ofNullable(clazz.cast(instanceUserArn()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("InstanceUserArn", INSTANCE_USER_ARN_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateUserRequest, T> g) {
        return obj -> g.apply((DisassociateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerUserSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateUserRequest> {
        /**
         * <p>
         * The user name from the Active Directory identity provider for the user.
         * </p>
         * 
         * @param username
         *        The user name from the Active Directory identity provider for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The ID of the EC2 instance which provides user-based subscriptions.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance which provides user-based subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An object that specifies details for the Active Directory identity provider.
         * </p>
         * 
         * @param identityProvider
         *        An object that specifies details for the Active Directory identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * An object that specifies details for the Active Directory identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user to disassociate from the EC2 instance.
         * </p>
         * 
         * @param instanceUserArn
         *        The Amazon Resource Name (ARN) of the user to disassociate from the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUserArn(String instanceUserArn);

        /**
         * <p>
         * The domain name of the Active Directory that contains information for the user to disassociate.
         * </p>
         * 
         * @param domain
         *        The domain name of the Active Directory that contains information for the user to disassociate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsRequest.BuilderImpl implements Builder {
        private String username;

        private String instanceId;

        private IdentityProvider identityProvider;

        private String instanceUserArn;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateUserRequest model) {
            super(model);
            username(model.username);
            instanceId(model.instanceId);
            identityProvider(model.identityProvider);
            instanceUserArn(model.instanceUserArn);
            domain(model.domain);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getInstanceUserArn() {
            return instanceUserArn;
        }

        public final void setInstanceUserArn(String instanceUserArn) {
            this.instanceUserArn = instanceUserArn;
        }

        @Override
        public final Builder instanceUserArn(String instanceUserArn) {
            this.instanceUserArn = instanceUserArn;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateUserRequest build() {
            return new DisassociateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
