/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderSummary.Builder, IdentityProviderSummary> {
    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(IdentityProviderSummary::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.<Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(IdentityProviderSummary::settings)).setter(setter(Builder::settings))
            .constructor(Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(IdentityProviderSummary::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IdentityProviderSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderArn").getter(getter(IdentityProviderSummary::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build())
            .build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(IdentityProviderSummary::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(IdentityProviderSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD,
            SETTINGS_FIELD, PRODUCT_FIELD, STATUS_FIELD, IDENTITY_PROVIDER_ARN_FIELD, FAILURE_MESSAGE_FIELD,
            OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IdentityProvider identityProvider;

    private final Settings settings;

    private final String product;

    private final String status;

    private final String identityProviderArn;

    private final String failureMessage;

    private final String ownerAccountId;

    private IdentityProviderSummary(BuilderImpl builder) {
        this.identityProvider = builder.identityProvider;
        this.settings = builder.settings;
        this.product = builder.product;
        this.status = builder.status;
        this.identityProviderArn = builder.identityProviderArn;
        this.failureMessage = builder.failureMessage;
        this.ownerAccountId = builder.ownerAccountId;
    }

    /**
     * <p>
     * The <code>IdentityProvider</code> resource contains information about an identity provider.
     * </p>
     * 
     * @return The <code>IdentityProvider</code> resource contains information about an identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The <code>Settings</code> resource contains details about the registered identity provider’s product related
     * configuration settings, such as the subnets to provision VPC endpoints.
     * </p>
     * 
     * @return The <code>Settings</code> resource contains details about the registered identity provider’s product
     *         related configuration settings, such as the subnets to provision VPC endpoints.
     */
    public final Settings settings() {
        return settings;
    }

    /**
     * <p>
     * The name of the user-based subscription product.
     * </p>
     * 
     * @return The name of the user-based subscription product.
     */
    public final String product() {
        return product;
    }

    /**
     * <p>
     * The status of the identity provider.
     * </p>
     * 
     * @return The status of the identity provider.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the identity provider.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * <p>
     * The failure message associated with an identity provider.
     * </p>
     * 
     * @return The failure message associated with an identity provider.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The AWS Account ID of the owner of this resource.
     * </p>
     * 
     * @return The AWS Account ID of the owner of this resource.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderSummary)) {
            return false;
        }
        IdentityProviderSummary other = (IdentityProviderSummary) obj;
        return Objects.equals(identityProvider(), other.identityProvider()) && Objects.equals(settings(), other.settings())
                && Objects.equals(product(), other.product()) && Objects.equals(status(), other.status())
                && Objects.equals(identityProviderArn(), other.identityProviderArn())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(ownerAccountId(), other.ownerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderSummary").add("IdentityProvider", identityProvider())
                .add("Settings", settings()).add("Product", product()).add("Status", status())
                .add("IdentityProviderArn", identityProviderArn()).add("FailureMessage", failureMessage())
                .add("OwnerAccountId", ownerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "IdentityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Product", PRODUCT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderSummary, T> g) {
        return obj -> g.apply((IdentityProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderSummary> {
        /**
         * <p>
         * The <code>IdentityProvider</code> resource contains information about an identity provider.
         * </p>
         * 
         * @param identityProvider
         *        The <code>IdentityProvider</code> resource contains information about an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * The <code>IdentityProvider</code> resource contains information about an identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The <code>Settings</code> resource contains details about the registered identity provider’s product related
         * configuration settings, such as the subnets to provision VPC endpoints.
         * </p>
         * 
         * @param settings
         *        The <code>Settings</code> resource contains details about the registered identity provider’s product
         *        related configuration settings, such as the subnets to provision VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Settings settings);

        /**
         * <p>
         * The <code>Settings</code> resource contains details about the registered identity provider’s product related
         * configuration settings, such as the subnets to provision VPC endpoints.
         * </p>
         * This is a convenience method that creates an instance of the {@link Settings.Builder} avoiding the need to
         * create one manually via {@link Settings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Settings.Builder#build()} is called immediately and its result is
         * passed to {@link #settings(Settings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(Settings)
         */
        default Builder settings(Consumer<Settings.Builder> settings) {
            return settings(Settings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * The name of the user-based subscription product.
         * </p>
         * 
         * @param product
         *        The name of the user-based subscription product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * The status of the identity provider.
         * </p>
         * 
         * @param status
         *        The status of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity provider.
         * </p>
         * 
         * @param identityProviderArn
         *        The Amazon Resource Name (ARN) of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The failure message associated with an identity provider.
         * </p>
         * 
         * @param failureMessage
         *        The failure message associated with an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The AWS Account ID of the owner of this resource.
         * </p>
         * 
         * @param ownerAccountId
         *        The AWS Account ID of the owner of this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);
    }

    static final class BuilderImpl implements Builder {
        private IdentityProvider identityProvider;

        private Settings settings;

        private String product;

        private String status;

        private String identityProviderArn;

        private String failureMessage;

        private String ownerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderSummary model) {
            identityProvider(model.identityProvider);
            settings(model.settings);
            product(model.product);
            status(model.status);
            identityProviderArn(model.identityProviderArn);
            failureMessage(model.failureMessage);
            ownerAccountId(model.ownerAccountId);
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final Settings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        @Override
        public IdentityProviderSummary build() {
            return new IdentityProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
