/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Remote Desktop Services (RDS) license server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseServer implements SdkPojo, Serializable, ToCopyableBuilder<LicenseServer.Builder, LicenseServer> {
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(LicenseServer::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(LicenseServer::healthStatusAsString)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv4Address").getter(getter(LicenseServer::ipv4Address)).setter(setter(Builder::ipv4Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Address").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Address").getter(getter(LicenseServer::ipv6Address)).setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_STATUS_FIELD,
            HEALTH_STATUS_FIELD, IPV4_ADDRESS_FIELD, IPV6_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String provisioningStatus;

    private final String healthStatus;

    private final String ipv4Address;

    private final String ipv6Address;

    private LicenseServer(BuilderImpl builder) {
        this.provisioningStatus = builder.provisioningStatus;
        this.healthStatus = builder.healthStatus;
        this.ipv4Address = builder.ipv4Address;
        this.ipv6Address = builder.ipv6Address;
    }

    /**
     * <p>
     * The current state of the provisioning process for the RDS license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link LicenseServerEndpointProvisioningStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The current state of the provisioning process for the RDS license server.
     * @see LicenseServerEndpointProvisioningStatus
     */
    public final LicenseServerEndpointProvisioningStatus provisioningStatus() {
        return LicenseServerEndpointProvisioningStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The current state of the provisioning process for the RDS license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link LicenseServerEndpointProvisioningStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The current state of the provisioning process for the RDS license server.
     * @see LicenseServerEndpointProvisioningStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * The health status of the RDS license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link LicenseServerHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of the RDS license server.
     * @see LicenseServerHealthStatus
     */
    public final LicenseServerHealthStatus healthStatus() {
        return LicenseServerHealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * The health status of the RDS license server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link LicenseServerHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of the RDS license server.
     * @see LicenseServerHealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * A list of domain IPv4 addresses that are used for the RDS license server.
     * </p>
     * 
     * @return A list of domain IPv4 addresses that are used for the RDS license server.
     */
    public final String ipv4Address() {
        return ipv4Address;
    }

    /**
     * <p>
     * A list of domain IPv6 addresses that are used for the RDS license server.
     * </p>
     * 
     * @return A list of domain IPv6 addresses that are used for the RDS license server.
     */
    public final String ipv6Address() {
        return ipv6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseServer)) {
            return false;
        }
        LicenseServer other = (LicenseServer) obj;
        return Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(ipv4Address(), other.ipv4Address()) && Objects.equals(ipv6Address(), other.ipv6Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseServer").add("ProvisioningStatus", provisioningStatusAsString())
                .add("HealthStatus", healthStatusAsString()).add("Ipv4Address", ipv4Address()).add("Ipv6Address", ipv6Address())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "Ipv4Address":
            return Optional.ofNullable(clazz.cast(ipv4Address()));
        case "Ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        map.put("Ipv4Address", IPV4_ADDRESS_FIELD);
        map.put("Ipv6Address", IPV6_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseServer, T> g) {
        return obj -> g.apply((LicenseServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseServer> {
        /**
         * <p>
         * The current state of the provisioning process for the RDS license server.
         * </p>
         * 
         * @param provisioningStatus
         *        The current state of the provisioning process for the RDS license server.
         * @see LicenseServerEndpointProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerEndpointProvisioningStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The current state of the provisioning process for the RDS license server.
         * </p>
         * 
         * @param provisioningStatus
         *        The current state of the provisioning process for the RDS license server.
         * @see LicenseServerEndpointProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerEndpointProvisioningStatus
         */
        Builder provisioningStatus(LicenseServerEndpointProvisioningStatus provisioningStatus);

        /**
         * <p>
         * The health status of the RDS license server.
         * </p>
         * 
         * @param healthStatus
         *        The health status of the RDS license server.
         * @see LicenseServerHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerHealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The health status of the RDS license server.
         * </p>
         * 
         * @param healthStatus
         *        The health status of the RDS license server.
         * @see LicenseServerHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseServerHealthStatus
         */
        Builder healthStatus(LicenseServerHealthStatus healthStatus);

        /**
         * <p>
         * A list of domain IPv4 addresses that are used for the RDS license server.
         * </p>
         * 
         * @param ipv4Address
         *        A list of domain IPv4 addresses that are used for the RDS license server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Address(String ipv4Address);

        /**
         * <p>
         * A list of domain IPv6 addresses that are used for the RDS license server.
         * </p>
         * 
         * @param ipv6Address
         *        A list of domain IPv6 addresses that are used for the RDS license server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);
    }

    static final class BuilderImpl implements Builder {
        private String provisioningStatus;

        private String healthStatus;

        private String ipv4Address;

        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseServer model) {
            provisioningStatus(model.provisioningStatus);
            healthStatus(model.healthStatus);
            ipv4Address(model.ipv4Address);
            ipv6Address(model.ipv6Address);
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(LicenseServerEndpointProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(LicenseServerHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getIpv4Address() {
            return ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        @Override
        public LicenseServer build() {
            return new LicenseServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
